/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.ASCIICharProp;
import com.forgerock.opendj.util.Iterators;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.util.Reject;

public final class AttributeDescription
implements Comparable<AttributeDescription> {
    private static final ThreadLocal<WeakHashMap<Schema, Map<String, AttributeDescription>>> CACHE = new ThreadLocal<WeakHashMap<Schema, Map<String, AttributeDescription>>>(){

        @Override
        protected WeakHashMap<Schema, Map<String, AttributeDescription>> initialValue() {
            return new WeakHashMap<Schema, Map<String, AttributeDescription>>();
        }
    };
    private static final ZeroOptionImpl ZERO_OPTION_IMPL = new ZeroOptionImpl();
    private static final AttributeDescription OBJECT_CLASS;
    private static final int ATTRIBUTE_DESCRIPTION_CACHE_SIZE = 512;
    private final String attributeDescription;
    private final String nameOrOid;
    private final AttributeType attributeType;
    private final Impl optionsPimpl;

    public AttributeDescription withOption(String option) {
        Reject.ifNull((Object)option);
        String normalizedOption = StaticUtils.toLowerCase(option);
        if (this.optionsPimpl.hasOption(normalizedOption)) {
            return this;
        }
        String newAttributeDescription = AttributeDescription.appendOption(this.attributeDescription, option);
        Impl impl = this.optionsPimpl;
        if (impl instanceof ZeroOptionImpl) {
            return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, new SingleOptionImpl(option, normalizedOption));
        }
        if (impl instanceof SingleOptionImpl) {
            SingleOptionImpl simpl = (SingleOptionImpl)impl;
            String[] newOptions = new String[]{simpl.option, option};
            String[] newNormalizedOptions = new String[2];
            if (normalizedOption.compareTo(simpl.normalizedOption) < 0) {
                newNormalizedOptions[0] = normalizedOption;
                newNormalizedOptions[1] = simpl.normalizedOption;
            } else {
                newNormalizedOptions[0] = simpl.normalizedOption;
                newNormalizedOptions[1] = normalizedOption;
            }
            return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, new MultiOptionImpl(newOptions, newNormalizedOptions));
        }
        MultiOptionImpl mimpl = (MultiOptionImpl)impl;
        int sz1 = mimpl.options.length;
        String[] newOptions = Arrays.copyOf(mimpl.options, sz1 + 1);
        newOptions[sz1] = option;
        int sz2 = mimpl.normalizedOptions.length;
        String[] newNormalizedOptions = new String[sz2 + 1];
        boolean inserted = false;
        for (int i = 0; i < sz2; ++i) {
            if (!inserted) {
                String s = mimpl.normalizedOptions[i];
                if (normalizedOption.compareTo(s) < 0) {
                    newNormalizedOptions[i] = normalizedOption;
                    newNormalizedOptions[i + 1] = s;
                    inserted = true;
                    continue;
                }
                newNormalizedOptions[i] = s;
                continue;
            }
            newNormalizedOptions[i + 1] = mimpl.normalizedOptions[i];
        }
        if (!inserted) {
            newNormalizedOptions[sz2] = normalizedOption;
        }
        return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, new MultiOptionImpl(newOptions, newNormalizedOptions));
    }

    public AttributeDescription withoutOption(String option) {
        int i;
        Reject.ifNull((Object)option);
        String normalizedOption = StaticUtils.toLowerCase(option);
        if (!this.optionsPimpl.hasOption(normalizedOption)) {
            return this;
        }
        String oldAttributeDescription = this.attributeDescription;
        StringBuilder builder = new StringBuilder(oldAttributeDescription.length() - option.length() - 1);
        String normalizedOldAttributeDescription = StaticUtils.toLowerCase(oldAttributeDescription);
        int index = normalizedOldAttributeDescription.indexOf(normalizedOption);
        builder.append(oldAttributeDescription, 0, index - 1);
        builder.append(oldAttributeDescription, index + option.length(), oldAttributeDescription.length());
        String newAttributeDescription = builder.toString();
        Impl impl = this.optionsPimpl;
        if (impl instanceof ZeroOptionImpl) {
            throw new IllegalStateException("ZeroOptionImpl unexpected");
        }
        if (impl instanceof SingleOptionImpl) {
            return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, ZERO_OPTION_IMPL);
        }
        MultiOptionImpl mimpl = (MultiOptionImpl)impl;
        if (mimpl.options.length == 2) {
            String remainingOption = StaticUtils.toLowerCase(mimpl.options[0]).equals(normalizedOption) ? mimpl.options[1] : mimpl.options[0];
            String remainingNormalizedOption = mimpl.normalizedOptions[0].equals(normalizedOption) ? mimpl.normalizedOptions[1] : mimpl.normalizedOptions[0];
            return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, new SingleOptionImpl(remainingOption, remainingNormalizedOption));
        }
        String[] newOptions = new String[mimpl.options.length - 1];
        String[] newNormalizedOptions = new String[mimpl.normalizedOptions.length - 1];
        int j = 0;
        for (i = 0; i < mimpl.options.length; ++i) {
            if (StaticUtils.toLowerCase(mimpl.options[i]).equals(normalizedOption)) continue;
            newOptions[j++] = mimpl.options[i];
        }
        j = 0;
        for (i = 0; i < mimpl.normalizedOptions.length; ++i) {
            if (mimpl.normalizedOptions[i].equals(normalizedOption)) continue;
            newNormalizedOptions[j++] = mimpl.normalizedOptions[i];
        }
        return new AttributeDescription(newAttributeDescription, this.nameOrOid, this.attributeType, new MultiOptionImpl(newOptions, newNormalizedOptions));
    }

    public static AttributeDescription create(AttributeType attributeType) {
        return AttributeDescription.create(attributeType.getNameOrOID(), attributeType);
    }

    @Deprecated
    public static AttributeDescription create(String attributeName, AttributeType attributeType) {
        Reject.ifNull((Object[])new Comparable[]{attributeName, attributeType});
        if (attributeType == OBJECT_CLASS.getAttributeType()) {
            return OBJECT_CLASS;
        }
        return new AttributeDescription(attributeName, attributeName, attributeType, ZERO_OPTION_IMPL);
    }

    public static AttributeDescription create(AttributeType attributeType, String option) {
        return AttributeDescription.create(attributeType.getNameOrOID(), attributeType, option);
    }

    @Deprecated
    public static AttributeDescription create(String attributeName, AttributeType attributeType, String option) {
        Reject.ifNull((Object[])new Comparable[]{attributeName, attributeType, option});
        String attributeDescription = AttributeDescription.appendOption(attributeName, option);
        String normalizedOption = StaticUtils.toLowerCase(option);
        return new AttributeDescription(attributeDescription, attributeName, attributeType, new SingleOptionImpl(option, normalizedOption));
    }

    private static String appendOption(String oid, String option) {
        StringBuilder builder = new StringBuilder(oid.length() + option.length() + 1);
        builder.append(oid);
        builder.append(';');
        builder.append(option);
        return builder.toString();
    }

    @Deprecated
    public static AttributeDescription create(String attributeName, AttributeType attributeType, String ... options) {
        Reject.ifNull((Object[])options);
        return AttributeDescription.create(attributeName, attributeType, Arrays.asList(options));
    }

    public static AttributeDescription create(AttributeType attributeType, String ... options) {
        Reject.ifNull((Object[])options);
        return AttributeDescription.create(attributeType.getNameOrOID(), attributeType, Arrays.asList(options));
    }

    public static AttributeDescription create(AttributeType attributeType, Collection<String> options) {
        return AttributeDescription.create(attributeType.getNameOrOID(), attributeType, options);
    }

    @Deprecated
    public static AttributeDescription create(String attributeName, AttributeType attributeType, Collection<String> options) {
        Reject.ifNull((Object[])new Comparable[]{attributeName, attributeType});
        Collection<String> opts = options != null ? options : Collections.emptySet();
        switch (opts.size()) {
            case 0: {
                return AttributeDescription.create(attributeName, attributeType);
            }
            case 1: {
                return AttributeDescription.create(attributeName, attributeType, opts.iterator().next());
            }
        }
        String[] optionsList = new String[opts.size()];
        Object[] normalizedOptions = new String[opts.size()];
        Iterator<String> it = opts.iterator();
        StringBuilder builder = new StringBuilder(attributeName.length() + it.next().length() + it.next().length() + 2);
        builder.append(attributeName);
        int i = 0;
        for (String option : opts) {
            builder.append(';');
            builder.append(option);
            optionsList[i] = option;
            normalizedOptions[i++] = StaticUtils.toLowerCase(option);
        }
        Arrays.sort(normalizedOptions);
        String attributeDescription = builder.toString();
        return new AttributeDescription(attributeDescription, attributeName, attributeType, new MultiOptionImpl(optionsList, (String[])normalizedOptions));
    }

    public static AttributeDescription objectClass() {
        return OBJECT_CLASS;
    }

    public static AttributeDescription valueOf(String attributeDescription) {
        return AttributeDescription.valueOf(attributeDescription, Schema.getDefaultSchema());
    }

    public static AttributeDescription valueOf(String attributeDescription, Schema schema) {
        Reject.ifNull((Object[])new Object[]{attributeDescription, schema});
        WeakHashMap<Schema, Map<String, AttributeDescription>> threadLocalMap = CACHE.get();
        LinkedHashMap<String, AttributeDescription> schemaLocalMap = threadLocalMap.get(schema);
        AttributeDescription ad = null;
        if (schemaLocalMap == null) {
            schemaLocalMap = new LinkedHashMap<String, AttributeDescription>(512, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, AttributeDescription> eldest) {
                    return this.size() > 512;
                }
            };
            threadLocalMap.put(schema, (Map<String, AttributeDescription>)schemaLocalMap);
        } else {
            ad = schemaLocalMap.get(attributeDescription);
        }
        if (ad == null) {
            ad = AttributeDescription.valueOf0(attributeDescription, schema);
            schemaLocalMap.put(attributeDescription, ad);
        }
        return ad;
    }

    private static int skipTrailingWhiteSpace(String attributeDescription, int i, int length) {
        while (i < length) {
            char c = attributeDescription.charAt(i);
            if (c != ' ') {
                LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_INTERNAL_WHITESPACE.get((Object)attributeDescription);
                throw new LocalizedIllegalArgumentException(message);
            }
            ++i;
        }
        return i;
    }

    private static AttributeDescription valueOf0(String attributeDescription, Schema schema) {
        String oid;
        int i;
        boolean allowMalformedNamesAndOptions = schema.getOption(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
        int length = attributeDescription.length();
        char c = '\u0000';
        for (i = 0; i < length && (c = attributeDescription.charAt(i)) == ' '; ++i) {
        }
        if (i == length) {
            LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_EMPTY.get((Object)attributeDescription);
            throw new LocalizedIllegalArgumentException(message);
        }
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        if (cp == null) {
            LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
            throw new LocalizedIllegalArgumentException(message);
        }
        int attributeTypeStart = i++;
        if (cp.isLetter()) {
            while (i < length && (c = attributeDescription.charAt(i)) != ';' && c != ' ') {
                cp = ASCIICharProp.valueOf(c);
                if (!cp.isKeyChar(allowMalformedNamesAndOptions)) {
                    LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
                    throw new LocalizedIllegalArgumentException(message);
                }
                ++i;
            }
        } else if (cp.isDigit()) {
            ++i;
            while (i < length && (c = attributeDescription.charAt(i)) != ';' && c != ' ') {
                cp = ASCIICharProp.valueOf(c);
                if (c != '.' && !cp.isDigit()) {
                    LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
                    throw new LocalizedIllegalArgumentException(message);
                }
                ++i;
            }
        } else {
            LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
            throw new LocalizedIllegalArgumentException(message);
        }
        int attributeTypeEnd = i;
        if (c == ' ') {
            i = AttributeDescription.skipTrailingWhiteSpace(attributeDescription, i + 1, length);
        }
        if ((oid = attributeTypeStart == 0 && attributeTypeEnd == length ? attributeDescription : attributeDescription.substring(attributeTypeStart, attributeTypeEnd)).length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_NO_TYPE.get((Object)attributeDescription);
            throw new LocalizedIllegalArgumentException(message);
        }
        AttributeType attributeType = schema.getAttributeType(oid);
        if (i == length) {
            if (attributeType == OBJECT_CLASS.getAttributeType() && attributeDescription.equals(OBJECT_CLASS.toString())) {
                return OBJECT_CLASS;
            }
            return new AttributeDescription(attributeDescription, oid, attributeType, ZERO_OPTION_IMPL);
        }
        StringBuilder builder = null;
        int optionStart = ++i;
        while (i < length && (c = attributeDescription.charAt(i)) != ' ' && c != ';') {
            cp = ASCIICharProp.valueOf(c);
            if (!cp.isKeyChar(allowMalformedNamesAndOptions)) {
                LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (builder == null) {
                if (cp.isUpperCase()) {
                    builder = new StringBuilder(length - optionStart);
                    builder.append(attributeDescription, optionStart, i);
                    builder.append(cp.toLowerCase());
                }
            } else {
                builder.append(cp.toLowerCase());
            }
            ++i;
        }
        String option = attributeDescription.substring(optionStart, i);
        String normalizedOption = builder != null ? builder.toString() : option;
        if (option.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_EMPTY_OPTION.get((Object)attributeDescription);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (c == ' ') {
            i = AttributeDescription.skipTrailingWhiteSpace(attributeDescription, i + 1, length);
        }
        if (i == length) {
            return new AttributeDescription(attributeDescription, oid, attributeType, new SingleOptionImpl(option, normalizedOption));
        }
        LinkedList<String> options = new LinkedList<String>();
        options.add(option);
        TreeSet<String> normalizedOptions = new TreeSet<String>();
        normalizedOptions.add(normalizedOption);
        while (i < length) {
            builder = null;
            optionStart = ++i;
            while (i < length && (c = attributeDescription.charAt(i)) != ' ' && c != ';') {
                cp = ASCIICharProp.valueOf(c);
                if (!cp.isKeyChar(allowMalformedNamesAndOptions)) {
                    LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_ILLEGAL_CHARACTER.get((Object)attributeDescription, (Object)Character.valueOf(c), (Object)i);
                    throw new LocalizedIllegalArgumentException(message);
                }
                if (builder == null) {
                    if (cp.isUpperCase()) {
                        builder = new StringBuilder(length - optionStart);
                        builder.append(attributeDescription, optionStart, i);
                        builder.append(cp.toLowerCase());
                    }
                } else {
                    builder.append(cp.toLowerCase());
                }
                ++i;
            }
            option = attributeDescription.substring(optionStart, i);
            normalizedOption = builder != null ? builder.toString() : option;
            if (option.length() == 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTRIBUTE_DESCRIPTION_EMPTY_OPTION.get((Object)attributeDescription);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (c == ' ') {
                i = AttributeDescription.skipTrailingWhiteSpace(attributeDescription, i + 1, length);
            }
            options.add(option);
            normalizedOptions.add(normalizedOption);
        }
        return new AttributeDescription(attributeDescription, oid, attributeType, new MultiOptionImpl(options.toArray(new String[options.size()]), normalizedOptions.toArray(new String[normalizedOptions.size()])));
    }

    private AttributeDescription(String attributeDescription, String attributeName, AttributeType attributeType, Impl pimpl) {
        this.attributeDescription = attributeDescription;
        this.nameOrOid = attributeName;
        this.attributeType = attributeType;
        this.optionsPimpl = pimpl;
    }

    @Override
    public int compareTo(AttributeDescription other) {
        int result = this.attributeType.compareTo(other.attributeType);
        if (result != 0) {
            return result;
        }
        return this.optionsPimpl.compareTo(other.optionsPimpl);
    }

    public boolean hasOption(String option) {
        String normalizedOption = StaticUtils.toLowerCase(option);
        return this.optionsPimpl.hasOption(normalizedOption);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttributeDescription) {
            AttributeDescription other = (AttributeDescription)o;
            return this.attributeType.equals(other.attributeType) && this.optionsPimpl.equals(other.optionsPimpl);
        }
        return false;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Deprecated
    public String getNameOrOID() {
        return this.nameOrOid;
    }

    public Iterable<String> getOptions() {
        return this.optionsPimpl;
    }

    public int hashCode() {
        return this.attributeType.hashCode() * 31 + this.optionsPimpl.hashCode();
    }

    public boolean hasOptions() {
        return this.optionsPimpl.hasOptions();
    }

    public boolean isObjectClass() {
        return this.attributeType.isObjectClass() && !this.hasOptions();
    }

    public boolean isPlaceHolder() {
        return this.attributeType.isPlaceHolder();
    }

    public boolean isSubTypeOf(AttributeDescription other) {
        return this.attributeType.isSubTypeOf(other.attributeType) && this.optionsPimpl.isSubTypeOf(other.optionsPimpl);
    }

    public boolean isSuperTypeOf(AttributeDescription other) {
        return this.attributeType.isSuperTypeOf(other.attributeType) && this.optionsPimpl.isSuperTypeOf(other.optionsPimpl);
    }

    public boolean matches(AttributeDescription other) {
        if (this == other) {
            return true;
        }
        return this.attributeType.matches(other.attributeType) && this.optionsPimpl.equals(other.optionsPimpl);
    }

    public String toString() {
        return this.attributeDescription;
    }

    static {
        AttributeType attributeType = Schema.getCoreSchema().getAttributeType("2.5.4.0");
        String attributeName = attributeType.getNameOrOID();
        OBJECT_CLASS = new AttributeDescription(attributeName, attributeName, attributeType, ZERO_OPTION_IMPL);
    }

    private static final class ZeroOptionImpl
    extends Impl {
        private ZeroOptionImpl() {
        }

        @Override
        public int compareTo(Impl other) {
            return this == other ? 0 : -1;
        }

        @Override
        public boolean hasOption(String normalizedOption) {
            return false;
        }

        @Override
        public boolean equals(Impl other) {
            return this == other;
        }

        @Override
        public String firstNormalizedOption() {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean hasOptions() {
            return false;
        }

        @Override
        public boolean isSubTypeOf(Impl other) {
            return this == other;
        }

        @Override
        public boolean isSuperTypeOf(Impl other) {
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static final class SingleOptionImpl
    extends Impl {
        private final String normalizedOption;
        private final String option;

        private SingleOptionImpl(String option, String normalizedOption) {
            this.option = option;
            this.normalizedOption = normalizedOption;
        }

        @Override
        public int compareTo(Impl other) {
            if (other == ZERO_OPTION_IMPL) {
                return 1;
            }
            if (other.size() == 1) {
                return this.normalizedOption.compareTo(other.firstNormalizedOption());
            }
            return -1;
        }

        @Override
        public boolean hasOption(String normalizedOption) {
            return this.normalizedOption.equals(normalizedOption);
        }

        @Override
        public boolean equals(Impl other) {
            return other.size() == 1 && other.hasOption(this.normalizedOption);
        }

        @Override
        public String firstNormalizedOption() {
            return this.normalizedOption;
        }

        @Override
        public int hashCode() {
            return this.normalizedOption.hashCode();
        }

        @Override
        public boolean hasOptions() {
            return true;
        }

        @Override
        public boolean isSubTypeOf(Impl other) {
            return other == ZERO_OPTION_IMPL || this.equals(other);
        }

        @Override
        public boolean isSuperTypeOf(Impl other) {
            return other.hasOption(this.normalizedOption);
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.singletonIterator(this.option);
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class MultiOptionImpl
    extends Impl {
        private final String[] normalizedOptions;
        private final String[] options;

        private MultiOptionImpl(String[] options, String[] normalizedOptions) {
            if (normalizedOptions.length < 2) {
                throw new AssertionError();
            }
            this.options = options;
            this.normalizedOptions = normalizedOptions;
        }

        @Override
        public int compareTo(Impl other) {
            int thisSize = this.normalizedOptions.length;
            int otherSize = other.size();
            if (thisSize < otherSize) {
                return -1;
            }
            if (thisSize > otherSize) {
                return 1;
            }
            MultiOptionImpl otherImpl = (MultiOptionImpl)other;
            for (int i = 0; i < thisSize; ++i) {
                String o1 = this.normalizedOptions[i];
                String o2 = otherImpl.normalizedOptions[i];
                int result = o1.compareTo(o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        @Override
        public boolean hasOption(String normalizedOption) {
            int sz = this.normalizedOptions.length;
            for (int i = 0; i < sz; ++i) {
                if (!this.normalizedOptions[i].equals(normalizedOption)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Impl other) {
            if (other instanceof MultiOptionImpl) {
                MultiOptionImpl tmp = (MultiOptionImpl)other;
                return Arrays.equals(this.normalizedOptions, tmp.normalizedOptions);
            }
            return false;
        }

        @Override
        public String firstNormalizedOption() {
            return this.normalizedOptions[0];
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.normalizedOptions);
        }

        @Override
        public boolean hasOptions() {
            return true;
        }

        @Override
        public boolean isSubTypeOf(Impl other) {
            if (other == ZERO_OPTION_IMPL) {
                return true;
            }
            if (other.size() == 1) {
                return this.hasOption(other.firstNormalizedOption());
            }
            if (other.size() > this.size()) {
                return false;
            }
            MultiOptionImpl tmp = (MultiOptionImpl)other;
            for (String normalizedOption : tmp.normalizedOptions) {
                if (this.hasOption(normalizedOption)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSuperTypeOf(Impl other) {
            for (String normalizedOption : this.normalizedOptions) {
                if (other.hasOption(normalizedOption)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return Iterators.arrayIterator(this.options);
        }

        @Override
        public int size() {
            return this.normalizedOptions.length;
        }
    }

    private static abstract class Impl
    implements Iterable<String> {
        protected Impl() {
        }

        public abstract int compareTo(Impl var1);

        public abstract boolean hasOption(String var1);

        public abstract boolean equals(Impl var1);

        public abstract String firstNormalizedOption();

        public abstract int hashCode();

        public abstract boolean hasOptions();

        public abstract boolean isSubTypeOf(Impl var1);

        public abstract boolean isSuperTypeOf(Impl var1);

        public abstract int size();
    }
}

