/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.handlers.syslog.SyslogConnection;
import org.forgerock.audit.handlers.syslog.SyslogPublisher;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsynchronousSyslogPublisher
implements SyslogPublisher {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousSyslogPublisher.class);
    private static final int CAPACITY = 5000;
    private final SyslogConnection connection;
    private final BlockingQueue<byte[]> queue;
    private final ExecutorService executorService;
    private volatile boolean stopRequested;

    AsynchronousSyslogPublisher(final String name, SyslogConnection connection) {
        Reject.ifNull((Object)connection);
        this.connection = connection;
        this.queue = new LinkedBlockingQueue<byte[]>(5000);
        this.stopRequested = false;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, name);
            }
        });
        this.executorService.execute(new WriterTask());
    }

    @Override
    public void publishMessage(String syslogMessage) throws IOException {
        boolean interrupted = false;
        while (!this.stopRequested) {
            try {
                this.queue.put(syslogMessage.getBytes(StandardCharsets.UTF_8));
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.stopRequested = true;
        this.executorService.shutdown();
        boolean interrupted = false;
        while (!this.executorService.isTerminated()) {
            try {
                this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.connection.close();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void publishBufferedMessages(List<byte[]> syslogMessages) {
        for (byte[] syslogMessage : syslogMessages) {
            try {
                this.connection.reconnect();
                this.connection.send(syslogMessage);
            }
            catch (IOException ex) {
                logger.error("Error when writing a message, message size: " + syslogMessage.length, (Throwable)ex);
                this.connection.close();
            }
        }
        try {
            this.connection.flush();
        }
        catch (IOException ex) {
            logger.error("Error when flushing the connection", (Throwable)ex);
        }
    }

    private class WriterTask
    implements Runnable {
        private WriterTask() {
        }

        @Override
        public void run() {
            ArrayList drainList = new ArrayList(5000);
            boolean interrupted = false;
            while (!AsynchronousSyslogPublisher.this.stopRequested || !AsynchronousSyslogPublisher.this.queue.isEmpty()) {
                try {
                    AsynchronousSyslogPublisher.this.queue.drainTo(drainList, 5000);
                    if (drainList.isEmpty()) {
                        byte[] message = (byte[])AsynchronousSyslogPublisher.this.queue.poll(10L, TimeUnit.SECONDS);
                        if (message == null) continue;
                        AsynchronousSyslogPublisher.this.publishBufferedMessages(Arrays.asList(new byte[][]{message}));
                        continue;
                    }
                    AsynchronousSyslogPublisher.this.publishBufferedMessages(drainList);
                    drainList.clear();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

