/*
 * The contents of this file are subject to the terms of the Common Development and
 * Distribution License (the License). You may not use this file except in compliance with the
 * License.
 *
 * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 * specific language governing permission and limitations under the License.
 *
 * When distributing Covered Software, include this CDDL Header Notice in each file and include
 * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 * Header, with the fields enclosed by brackets [] replaced by your own identifying
 * information: "Portions Copyright [year] [name of copyright owner]".
 *
 * Copyright 2008 Sun Microsystems, Inc.
 */

package org.opends.guitools.controlpanel.event;

import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;

/**
 * The event used to notify that a backup has been created.
 *
 */
public class BackupCreatedEvent
{
  private BackupDescriptor newBackup;

  /**
   * The constructor of the event.
   * @param newBackup the created backup.
   */
  public BackupCreatedEvent(BackupDescriptor newBackup)
  {
    this.newBackup = newBackup;
  }

  /**
   * Returns the backup descriptor.
   * @return the backup descriptor.
   */
  public BackupDescriptor getBackupDescriptor()
  {
    return newBackup;
  }
}
