/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.VersionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ToolVersionHandler
implements VersionHandler {
    private final String moduleName;

    public static VersionHandler newSdkVersionHandler() {
        return ToolVersionHandler.newToolVersionHandler("opendj-core");
    }

    public static VersionHandler newToolVersionHandler(String moduleName) {
        return new ToolVersionHandler(moduleName);
    }

    private ToolVersionHandler(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public void printVersion() {
        System.out.println(this.getVersion());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVersion() + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try {
            URL manifestUrl;
            Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            do {
                if (!manifests.hasMoreElements()) return null;
            } while (!(manifestUrl = manifests.nextElement()).toString().contains(this.moduleName));
            try (InputStream manifestStream = manifestUrl.openStream();){
                Attributes attrs = new Manifest(manifestStream).getMainAttributes();
                String string = attrs.getValue("Bundle-Version") + " (revision " + attrs.getValue("SCM-Revision") + ")";
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while determining opendj tool version", e);
        }
    }
}

