/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedActionMethods;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InterfaceCollectionInstance;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandlerUtils;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.annotations.Delete;
import org.forgerock.json.resource.annotations.Patch;
import org.forgerock.json.resource.annotations.Read;
import org.forgerock.json.resource.annotations.Update;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

class AnnotationCollectionInstance
extends InterfaceCollectionInstance {
    private final AnnotatedMethod readMethod;
    private final AnnotatedMethod updateMethod;
    private final AnnotatedMethod deleteMethod;
    private final AnnotatedMethod patchMethod;
    private final AnnotatedActionMethods actionMethods;

    public AnnotationCollectionInstance(Object requestHandler) {
        super(null);
        this.readMethod = AnnotatedMethod.findMethod(requestHandler, Read.class, true);
        this.updateMethod = AnnotatedMethod.findMethod(requestHandler, Update.class, true);
        this.deleteMethod = AnnotatedMethod.findMethod(requestHandler, Delete.class, true);
        this.patchMethod = AnnotatedMethod.findMethod(requestHandler, Patch.class, true);
        this.actionMethods = AnnotatedActionMethods.findAll(requestHandler, true);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return RequestHandlerUtils.handle(this.readMethod, context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return RequestHandlerUtils.handle(this.updateMethod, context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return RequestHandlerUtils.handle(this.deleteMethod, context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return RequestHandlerUtils.handle(this.patchMethod, context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.actionMethods.invoke(context, request, Resources.idOf(context));
    }
}

