/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.client.EntityTagVirtualAttributeCfgClient;
import org.forgerock.opendj.server.config.meta.VirtualAttributeCfgDefn;
import org.forgerock.opendj.server.config.server.EntityTagVirtualAttributeCfg;
import org.forgerock.opendj.server.config.server.VirtualAttributeCfg;

public final class EntityTagVirtualAttributeCfgDefn
extends ManagedObjectDefinition<EntityTagVirtualAttributeCfgClient, EntityTagVirtualAttributeCfg> {
    private static final EntityTagVirtualAttributeCfgDefn INSTANCE = new EntityTagVirtualAttributeCfgDefn();
    private static final AttributeTypePropertyDefinition PD_ATTRIBUTE_TYPE;
    private static final EnumPropertyDefinition<ChecksumAlgorithm> PD_CHECKSUM_ALGORITHM;
    private static final EnumPropertyDefinition<VirtualAttributeCfgDefn.ConflictBehavior> PD_CONFLICT_BEHAVIOR;
    private static final AttributeTypePropertyDefinition PD_EXCLUDED_ATTRIBUTE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static EntityTagVirtualAttributeCfgDefn getInstance() {
        return INSTANCE;
    }

    private EntityTagVirtualAttributeCfgDefn() {
        super("entity-tag-virtual-attribute", VirtualAttributeCfgDefn.getInstance());
    }

    @Override
    public EntityTagVirtualAttributeCfgClient createClientConfiguration(ManagedObject<? extends EntityTagVirtualAttributeCfgClient> impl) {
        return new EntityTagVirtualAttributeCfgClientImpl(impl);
    }

    @Override
    public EntityTagVirtualAttributeCfg createServerConfiguration(ServerManagedObject<? extends EntityTagVirtualAttributeCfg> impl) {
        return new EntityTagVirtualAttributeCfgServerImpl(impl);
    }

    @Override
    public Class<EntityTagVirtualAttributeCfg> getServerConfigurationClass() {
        return EntityTagVirtualAttributeCfg.class;
    }

    public AttributeTypePropertyDefinition getAttributeTypePropertyDefinition() {
        return PD_ATTRIBUTE_TYPE;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return VirtualAttributeCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public EnumPropertyDefinition<ChecksumAlgorithm> getChecksumAlgorithmPropertyDefinition() {
        return PD_CHECKSUM_ALGORITHM;
    }

    public EnumPropertyDefinition<VirtualAttributeCfgDefn.ConflictBehavior> getConflictBehaviorPropertyDefinition() {
        return PD_CONFLICT_BEHAVIOR;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return VirtualAttributeCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AttributeTypePropertyDefinition getExcludedAttributePropertyDefinition() {
        return PD_EXCLUDED_ATTRIBUTE;
    }

    public StringPropertyDefinition getFilterPropertyDefinition() {
        return VirtualAttributeCfgDefn.getInstance().getFilterPropertyDefinition();
    }

    public DNPropertyDefinition getGroupDNPropertyDefinition() {
        return VirtualAttributeCfgDefn.getInstance().getGroupDNPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<VirtualAttributeCfgDefn.Scope> getScopePropertyDefinition() {
        return VirtualAttributeCfgDefn.getInstance().getScopePropertyDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "attribute-type");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "attribute-type"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("etag");
        builder.setDefaultBehaviorProvider(provider);
        PD_ATTRIBUTE_TYPE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ATTRIBUTE_TYPE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "checksum-algorithm");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "checksum-algorithm"));
        provider = new DefinedDefaultBehaviorProvider("adler-32");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(ChecksumAlgorithm.class);
        PD_CHECKSUM_ALGORITHM = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECKSUM_ALGORITHM);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "conflict-behavior");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "conflict-behavior"));
        provider = new DefinedDefaultBehaviorProvider("real-overrides-virtual");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(VirtualAttributeCfgDefn.ConflictBehavior.class);
        PD_CONFLICT_BEHAVIOR = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONFLICT_BEHAVIOR);
        builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "excluded-attribute");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "excluded-attribute"));
        provider = new DefinedDefaultBehaviorProvider("ds-sync-hist");
        builder.setDefaultBehaviorProvider(provider);
        PD_EXCLUDED_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_EXCLUDED_ATTRIBUTE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.EntityTagVirtualAttributeProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.VirtualAttributeProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class EntityTagVirtualAttributeCfgServerImpl
    implements EntityTagVirtualAttributeCfg {
        private ServerManagedObject<? extends EntityTagVirtualAttributeCfg> impl;
        private final AttributeType pAttributeType;
        private final SortedSet<DN> pBaseDN;
        private final ChecksumAlgorithm pChecksumAlgorithm;
        private final VirtualAttributeCfgDefn.ConflictBehavior pConflictBehavior;
        private final boolean pEnabled;
        private final SortedSet<AttributeType> pExcludedAttribute;
        private final SortedSet<String> pFilter;
        private final SortedSet<DN> pGroupDN;
        private final String pJavaClass;
        private final VirtualAttributeCfgDefn.Scope pScope;

        private EntityTagVirtualAttributeCfgServerImpl(ServerManagedObject<? extends EntityTagVirtualAttributeCfg> impl) {
            this.impl = impl;
            this.pAttributeType = impl.getPropertyValue(INSTANCE.getAttributeTypePropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pChecksumAlgorithm = impl.getPropertyValue(INSTANCE.getChecksumAlgorithmPropertyDefinition());
            this.pConflictBehavior = impl.getPropertyValue(INSTANCE.getConflictBehaviorPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pExcludedAttribute = impl.getPropertyValues((PropertyDefinition)INSTANCE.getExcludedAttributePropertyDefinition());
            this.pFilter = impl.getPropertyValues((PropertyDefinition)INSTANCE.getFilterPropertyDefinition());
            this.pGroupDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getGroupDNPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pScope = impl.getPropertyValue(INSTANCE.getScopePropertyDefinition());
        }

        @Override
        public void addEntityTagChangeListener(ConfigurationChangeListener<EntityTagVirtualAttributeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeEntityTagChangeListener(ConfigurationChangeListener<EntityTagVirtualAttributeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<VirtualAttributeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<VirtualAttributeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getAttributeType() {
            return this.pAttributeType;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public ChecksumAlgorithm getChecksumAlgorithm() {
            return this.pChecksumAlgorithm;
        }

        @Override
        public VirtualAttributeCfgDefn.ConflictBehavior getConflictBehavior() {
            return this.pConflictBehavior;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public SortedSet<AttributeType> getExcludedAttribute() {
            return this.pExcludedAttribute;
        }

        @Override
        public SortedSet<String> getFilter() {
            return this.pFilter;
        }

        @Override
        public SortedSet<DN> getGroupDN() {
            return this.pGroupDN;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public VirtualAttributeCfgDefn.Scope getScope() {
            return this.pScope;
        }

        @Override
        public Class<? extends EntityTagVirtualAttributeCfg> configurationClass() {
            return EntityTagVirtualAttributeCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class EntityTagVirtualAttributeCfgClientImpl
    implements EntityTagVirtualAttributeCfgClient {
        private ManagedObject<? extends EntityTagVirtualAttributeCfgClient> impl;

        private EntityTagVirtualAttributeCfgClientImpl(ManagedObject<? extends EntityTagVirtualAttributeCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getAttributeType() {
            return this.impl.getPropertyValue(INSTANCE.getAttributeTypePropertyDefinition());
        }

        @Override
        public void setAttributeType(AttributeType value) {
            this.impl.setPropertyValue(INSTANCE.getAttributeTypePropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public ChecksumAlgorithm getChecksumAlgorithm() {
            return this.impl.getPropertyValue(INSTANCE.getChecksumAlgorithmPropertyDefinition());
        }

        @Override
        public void setChecksumAlgorithm(ChecksumAlgorithm value) {
            this.impl.setPropertyValue(INSTANCE.getChecksumAlgorithmPropertyDefinition(), value);
        }

        @Override
        public VirtualAttributeCfgDefn.ConflictBehavior getConflictBehavior() {
            return this.impl.getPropertyValue(INSTANCE.getConflictBehaviorPropertyDefinition());
        }

        @Override
        public void setConflictBehavior(VirtualAttributeCfgDefn.ConflictBehavior value) {
            this.impl.setPropertyValue(INSTANCE.getConflictBehaviorPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AttributeType> getExcludedAttribute() {
            return this.impl.getPropertyValues(INSTANCE.getExcludedAttributePropertyDefinition());
        }

        @Override
        public void setExcludedAttribute(Collection<AttributeType> values) {
            this.impl.setPropertyValues(INSTANCE.getExcludedAttributePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getFilter() {
            return this.impl.getPropertyValues(INSTANCE.getFilterPropertyDefinition());
        }

        @Override
        public void setFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getFilterPropertyDefinition(), values);
        }

        @Override
        public SortedSet<DN> getGroupDN() {
            return this.impl.getPropertyValues(INSTANCE.getGroupDNPropertyDefinition());
        }

        @Override
        public void setGroupDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getGroupDNPropertyDefinition(), values);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public VirtualAttributeCfgDefn.Scope getScope() {
            return this.impl.getPropertyValue(INSTANCE.getScopePropertyDefinition());
        }

        @Override
        public void setScope(VirtualAttributeCfgDefn.Scope value) {
            this.impl.setPropertyValue(INSTANCE.getScopePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends EntityTagVirtualAttributeCfgClient, ? extends EntityTagVirtualAttributeCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum ChecksumAlgorithm {
        ADLER_32("adler-32"),
        CRC_32("crc-32");

        private final String name;

        private ChecksumAlgorithm(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

