/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CoreSchemaCfgClient;
import org.forgerock.opendj.server.config.meta.SchemaProviderCfgDefn;
import org.forgerock.opendj.server.config.server.CoreSchemaCfg;
import org.forgerock.opendj.server.config.server.SchemaProviderCfg;

public final class CoreSchemaCfgDefn
extends ManagedObjectDefinition<CoreSchemaCfgClient, CoreSchemaCfg> {
    private static final CoreSchemaCfgDefn INSTANCE = new CoreSchemaCfgDefn();
    private static final BooleanPropertyDefinition PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;
    private static final StringPropertyDefinition PD_DISABLED_MATCHING_RULE;
    private static final StringPropertyDefinition PD_DISABLED_SYNTAX;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final BooleanPropertyDefinition PD_STRICT_FORMAT_COUNTRY_STRING;
    private static final BooleanPropertyDefinition PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;

    public static CoreSchemaCfgDefn getInstance() {
        return INSTANCE;
    }

    private CoreSchemaCfgDefn() {
        super("core-schema", SchemaProviderCfgDefn.getInstance());
    }

    @Override
    public CoreSchemaCfgClient createClientConfiguration(ManagedObject<? extends CoreSchemaCfgClient> impl) {
        return new CoreSchemaCfgClientImpl(impl);
    }

    @Override
    public CoreSchemaCfg createServerConfiguration(ServerManagedObject<? extends CoreSchemaCfg> impl) {
        return new CoreSchemaCfgServerImpl(impl);
    }

    @Override
    public Class<CoreSchemaCfg> getServerConfigurationClass() {
        return CoreSchemaCfg.class;
    }

    public BooleanPropertyDefinition getAllowZeroLengthValuesDirectoryStringPropertyDefinition() {
        return PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING;
    }

    public StringPropertyDefinition getDisabledMatchingRulePropertyDefinition() {
        return PD_DISABLED_MATCHING_RULE;
    }

    public StringPropertyDefinition getDisabledSyntaxPropertyDefinition() {
        return PD_DISABLED_SYNTAX;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SchemaProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public BooleanPropertyDefinition getStrictFormatCountryStringPropertyDefinition() {
        return PD_STRICT_FORMAT_COUNTRY_STRING;
    }

    public BooleanPropertyDefinition getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition() {
        return PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-zero-length-values-directory-string");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-zero-length-values-directory-string"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_ZERO_LENGTH_VALUES_DIRECTORY_STRING);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-matching-rule");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-matching-rule"));
        provider = new DefinedDefaultBehaviorProvider("NONE");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-9.]+\\d|NONE)$", "OID");
        PD_DISABLED_MATCHING_RULE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISABLED_MATCHING_RULE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "disabled-syntax");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-syntax"));
        provider = new DefinedDefaultBehaviorProvider("NONE");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-9.]+\\d|NONE)$", "OID");
        PD_DISABLED_SYNTAX = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISABLED_SYNTAX);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.schema.CoreSchemaProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.schema.SchemaProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strict-format-country-string");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strict-format-country-string"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRICT_FORMAT_COUNTRY_STRING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRICT_FORMAT_COUNTRY_STRING);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "strip-syntax-min-upper-bound-attribute-type-description"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STRIP_SYNTAX_MIN_UPPER_BOUND_ATTRIBUTE_TYPE_DESCRIPTION);
    }

    private static class CoreSchemaCfgServerImpl
    implements CoreSchemaCfg {
        private ServerManagedObject<? extends CoreSchemaCfg> impl;
        private final boolean pAllowZeroLengthValuesDirectoryString;
        private final SortedSet<String> pDisabledMatchingRule;
        private final SortedSet<String> pDisabledSyntax;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final boolean pStrictFormatCountryString;
        private final boolean pStripSyntaxMinUpperBoundAttributeTypeDescription;

        private CoreSchemaCfgServerImpl(ServerManagedObject<? extends CoreSchemaCfg> impl) {
            this.impl = impl;
            this.pAllowZeroLengthValuesDirectoryString = impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
            this.pDisabledMatchingRule = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDisabledMatchingRulePropertyDefinition());
            this.pDisabledSyntax = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDisabledSyntaxPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pStrictFormatCountryString = impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
            this.pStripSyntaxMinUpperBoundAttributeTypeDescription = impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
        }

        @Override
        public void addCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCoreSchemaChangeListener(ConfigurationChangeListener<CoreSchemaCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SchemaProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAllowZeroLengthValuesDirectoryString() {
            return this.pAllowZeroLengthValuesDirectoryString;
        }

        @Override
        public SortedSet<String> getDisabledMatchingRule() {
            return this.pDisabledMatchingRule;
        }

        @Override
        public SortedSet<String> getDisabledSyntax() {
            return this.pDisabledSyntax;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public boolean isStrictFormatCountryString() {
            return this.pStrictFormatCountryString;
        }

        @Override
        public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
            return this.pStripSyntaxMinUpperBoundAttributeTypeDescription;
        }

        @Override
        public Class<? extends CoreSchemaCfg> configurationClass() {
            return CoreSchemaCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class CoreSchemaCfgClientImpl
    implements CoreSchemaCfgClient {
        private ManagedObject<? extends CoreSchemaCfgClient> impl;

        private CoreSchemaCfgClientImpl(ManagedObject<? extends CoreSchemaCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAllowZeroLengthValuesDirectoryString() {
            return this.impl.getPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition());
        }

        @Override
        public void setAllowZeroLengthValuesDirectoryString(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowZeroLengthValuesDirectoryStringPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getDisabledMatchingRule() {
            return this.impl.getPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition());
        }

        @Override
        public void setDisabledMatchingRule(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDisabledMatchingRulePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getDisabledSyntax() {
            return this.impl.getPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition());
        }

        @Override
        public void setDisabledSyntax(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDisabledSyntaxPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public boolean isStrictFormatCountryString() {
            return this.impl.getPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition());
        }

        @Override
        public void setStrictFormatCountryString(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStrictFormatCountryStringPropertyDefinition(), value);
        }

        @Override
        public boolean isStripSyntaxMinUpperBoundAttributeTypeDescription() {
            return this.impl.getPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition());
        }

        @Override
        public void setStripSyntaxMinUpperBoundAttributeTypeDescription(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getStripSyntaxMinUpperBoundAttributeTypeDescriptionPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends CoreSchemaCfgClient, ? extends CoreSchemaCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

