/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AdministrationConnectorCfgClient;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.server.AdministrationConnectorCfg;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class AdministrationConnectorCfgDefn
extends ManagedObjectDefinition<AdministrationConnectorCfgClient, AdministrationConnectorCfg> {
    private static final AdministrationConnectorCfgDefn INSTANCE = new AdministrationConnectorCfgDefn();
    private static final AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> PD_KEY_MANAGER_PROVIDER;
    private static final IPAddressPropertyDefinition PD_LISTEN_ADDRESS;
    private static final IntegerPropertyDefinition PD_LISTEN_PORT;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final StringPropertyDefinition PD_SSL_CIPHER_SUITE;
    private static final StringPropertyDefinition PD_SSL_PROTOCOL;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;

    public static AdministrationConnectorCfgDefn getInstance() {
        return INSTANCE;
    }

    private AdministrationConnectorCfgDefn() {
        super("administration-connector", TopCfgDefn.getInstance());
    }

    @Override
    public AdministrationConnectorCfgClient createClientConfiguration(ManagedObject<? extends AdministrationConnectorCfgClient> impl) {
        return new AdministrationConnectorCfgClientImpl(impl);
    }

    @Override
    public AdministrationConnectorCfg createServerConfiguration(ServerManagedObject<? extends AdministrationConnectorCfg> impl) {
        return new AdministrationConnectorCfgServerImpl(impl);
    }

    @Override
    public Class<AdministrationConnectorCfg> getServerConfigurationClass() {
        return AdministrationConnectorCfg.class;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER;
    }

    public IPAddressPropertyDefinition getListenAddressPropertyDefinition() {
        return PD_LISTEN_ADDRESS;
    }

    public IntegerPropertyDefinition getListenPortPropertyDefinition() {
        return PD_LISTEN_PORT;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public StringPropertyDefinition getSSLCipherSuitePropertyDefinition() {
        return PD_SSL_CIPHER_SUITE;
    }

    public StringPropertyDefinition getSSLProtocolPropertyDefinition() {
        return PD_SSL_PROTOCOL;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "key-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("key-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_KEY_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_KEY_MANAGER_PROVIDER.getSourceConstraint());
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "listen-address");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "listen-address"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("0.0.0.0");
        builder.setDefaultBehaviorProvider(provider);
        PD_LISTEN_ADDRESS = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_ADDRESS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "listen-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_LISTEN_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_PORT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cipher-suite");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-cipher-suite"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cipher-suite"));
        PD_SSL_CIPHER_SUITE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CIPHER_SUITE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-protocol");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ssl-protocol"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-protocol"));
        PD_SSL_PROTOCOL = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_PROTOCOL);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class AdministrationConnectorCfgServerImpl
    implements AdministrationConnectorCfg {
        private ServerManagedObject<? extends AdministrationConnectorCfg> impl;
        private final String pKeyManagerProvider;
        private final SortedSet<InetAddress> pListenAddress;
        private final int pListenPort;
        private final SortedSet<String> pSSLCertNickname;
        private final SortedSet<String> pSSLCipherSuite;
        private final SortedSet<String> pSSLProtocol;
        private final String pTrustManagerProvider;

        private AdministrationConnectorCfgServerImpl(ServerManagedObject<? extends AdministrationConnectorCfg> impl) {
            this.impl = impl;
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pListenAddress = impl.getPropertyValues((PropertyDefinition)INSTANCE.getListenAddressPropertyDefinition());
            this.pListenPort = impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pSSLCipherSuite = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCipherSuitePropertyDefinition());
            this.pSSLProtocol = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLProtocolPropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AdministrationConnectorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AdministrationConnectorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.pListenAddress;
        }

        @Override
        public int getListenPort() {
            return this.pListenPort;
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.pSSLCipherSuite;
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.pSSLProtocol;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public Class<? extends AdministrationConnectorCfg> configurationClass() {
            return AdministrationConnectorCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class AdministrationConnectorCfgClientImpl
    implements AdministrationConnectorCfgClient {
        private ManagedObject<? extends AdministrationConnectorCfgClient> impl;

        private AdministrationConnectorCfgClientImpl(ManagedObject<? extends AdministrationConnectorCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.impl.getPropertyValues(INSTANCE.getListenAddressPropertyDefinition());
        }

        @Override
        public void setListenAddress(Collection<InetAddress> values) {
            this.impl.setPropertyValues(INSTANCE.getListenAddressPropertyDefinition(), values);
        }

        @Override
        public Integer getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public void setListenPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getListenPortPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLCipherSuite() {
            return this.impl.getPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition());
        }

        @Override
        public void setSSLCipherSuite(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCipherSuitePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getSSLProtocol() {
            return this.impl.getPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition());
        }

        @Override
        public void setSSLProtocol(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLProtocolPropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends AdministrationConnectorCfgClient, ? extends AdministrationConnectorCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

