/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.HelpCallback;
import com.forgerock.opendj.cli.MenuBuilder;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.cli.ValidationCallback;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.ContainsCondition;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.CLIProfile;
import org.forgerock.opendj.config.dsconfig.DSConfig;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.PropertyEditorModification;
import org.forgerock.opendj.config.dsconfig.PropertyValueEditor;
import org.forgerock.opendj.config.dsconfig.SetPropSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;

final class CreateSubCommandHandler<C extends ConfigurationClient, S extends Configuration>
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private static final Character OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
    private static final String OPTION_DSCFG_LONG_REMOVE = "remove";
    private static final String OPTION_DSCFG_LONG_RESET = "reset";
    private final List<StringArgument> namingArgs;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertySetArgument;
    private final RelationDefinition<C, S> relation;
    private final SubCommand subCommand;
    private final StringArgument typeArgument;
    private final String typeUsage;
    private final SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> types;

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(parser, p, r, r.getNamingPropertyDefinition(), p.child(r, "DUMMY"));
    }

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, SetRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(parser, p, r, null, p.child(r));
    }

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(parser, p, r, null, p.child(r));
    }

    public static <C extends ConfigurationClient, S extends Configuration> MenuResult<String> createManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> parent, InstantiableRelationDefinition<C, S> rd) throws ClientException {
        return CreateSubCommandHandler.createManagedObject(app, context, parent, rd, null);
    }

    private static <C extends ConfigurationClient, S extends Configuration> MenuResult<String> createManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> parent, InstantiableRelationDefinition<C, S> rd, SubCommandHandler handler) throws ClientException {
        AbstractManagedObjectDefinition d = rd.getChildDefinition();
        MenuResult result = CreateSubCommandHandler.getTypeInteractively(app, d, Collections.emptySet());
        if (!result.isSuccess()) {
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            return MenuResult.quit();
        }
        ManagedObjectDefinition mod = (ManagedObjectDefinition)result.getValue();
        app.println();
        app.println();
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        ManagedObject<C> mo = CreateSubCommandHandler.createChildInteractively(app, parent, rd, mod, exceptions);
        MenuResult<Void> result2 = CreateSubCommandHandler.commitManagedObject(app, context, mo, handler);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        return MenuResult.success((Object)mo.getManagedObjectPath().getName());
    }

    /*
     * Unable to fully structure code
     */
    private static MenuResult<Void> checkReferences(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException {
        d = mo.getManagedObjectDefinition();
        ufn = d.getUserFriendlyName();
        try {
            for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                if (!(pd instanceof AggregationPropertyDefinition) || !(apd = (AggregationPropertyDefinition)pd).getTargetNeedsEnablingCondition().evaluate(context, mo)) continue;
                for (String name : mo.getPropertyValues(apd)) {
                    path = apd.getChildPath(name);
                    rufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    try {
                        ref = context.getManagedObject(path);
                    }
                    catch (DefinitionDecodingException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get((Object)rufn, (Object)rufn, (Object)rufn);
                        throw new ClientException(ReturnCode.OTHER, msg);
                    }
                    catch (ManagedObjectDecodingException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get((Object)rufn);
                        throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
                    }
                    catch (ManagedObjectNotFoundException e) {
                        msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get((Object)rufn);
                        throw new ClientException(ReturnCode.NO_SUCH_OBJECT, msg);
                    }
                    condition = apd.getTargetIsEnabledCondition();
                    while (!condition.evaluate(context, ref)) {
                        isBadReference = true;
                        if (condition instanceof ContainsCondition) {
                            cvc = (ContainsCondition)condition;
                            app.println();
                            if (app.confirmAction(DsconfigMessages.INFO_EDITOR_PROMPT_ENABLED_REFERENCED_COMPONENT.get((Object)rufn, (Object)name, (Object)ufn), true)) {
                                cvc.setPropertyValue(ref);
                                try {
                                    ref.commit();
                                    isBadReference = false;
                                }
                                catch (MissingMandatoryPropertiesException e) {
                                    app.errPrintln();
                                    ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                                    app.errPrintln();
                                    if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT.get((Object)rufn), true)) ** GOTO lbl68
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl68
                                    isBadReference = false;
                                }
                                catch (ConcurrentModificationException e) {
                                    msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get((Object)ufn);
                                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
                                }
                                catch (OperationRejectedException e) {
                                    app.errPrintln();
                                    ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                                    app.errPrintln();
                                    if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT.get((Object)rufn), true)) ** GOTO lbl68
                                    result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                    if (result.isQuit()) {
                                        return result;
                                    }
                                    if (!result.isSuccess()) ** GOTO lbl68
                                    isBadReference = false;
                                }
                                catch (ManagedObjectAlreadyExistsException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                        } else {
                            app.println();
                            if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_TO_ENABLE.get((Object)rufn, (Object)name, (Object)ufn), true)) {
                                result = SetPropSubCommandHandler.modifyManagedObject(app, context, ref, handler);
                                if (result.isQuit()) {
                                    return result;
                                }
                                if (result.isSuccess()) {
                                    isBadReference = false;
                                }
                            }
                        }
lbl68:
                        // 13 sources

                        if (!isBadReference) continue;
                        app.errPrintln();
                        app.errPrintln(DsconfigMessages.ERR_SET_REFERENCED_COMPONENT_DISABLED.get((Object)ufn, (Object)rufn));
                        app.errPrintln();
                        if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) {
                            return MenuResult.again();
                        }
                        return MenuResult.cancel();
                    }
                }
            }
        }
        catch (AuthorizationException e) {
            msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)ufn);
            throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
        }
        catch (LdapException e) {
            msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get((Object)ufn, (Object)e.getMessage());
            throw new ClientException(ReturnCode.OTHER, msg);
        }
        return MenuResult.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MenuResult<Void> commitManagedObject(ConsoleApplication app, ManagementContext context, ManagedObject<?> mo, SubCommandHandler handler) throws ClientException {
        ManagedObjectDefinition<?, Configuration> d = mo.getManagedObjectDefinition();
        LocalizableMessage ufn = d.getUserFriendlyName();
        PropertyValueEditor editor = new PropertyValueEditor(app, context);
        while (true) {
            LocalizableMessage msg;
            if (app.isInteractive()) {
                TreeSet properties = new TreeSet();
                for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                    if (CreateSubCommandHandler.cannotDisplay(app, pd)) continue;
                    properties.add(pd);
                }
                MenuResult<Void> result = editor.edit(mo, properties, true);
                if (result.isSuccess() && (result = CreateSubCommandHandler.checkReferences(app, context, mo, handler)).isAgain()) continue;
                if (result.isQuit()) {
                    if (app.isMenuDrivenMode()) return MenuResult.quit();
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get((Object)ufn));
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
            }
            try {
                mo.commit();
                if (app.isInteractive() || app.isVerbose()) {
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_CREATE_SUCCESS.get((Object)ufn));
                }
                if (handler == null) return MenuResult.success();
                for (PropertyEditorModification<?> mod : editor.getModifications()) {
                    try {
                        Argument arg = CreateSubCommandHandler.createArgument(mod);
                        handler.getCommandBuilder().addArgument(arg);
                    }
                    catch (ArgumentException ae) {
                        throw new RuntimeException("Unexpected error generating the command builder: " + (Object)((Object)ae), ae);
                    }
                }
                handler.setCommandBuilderUseful(true);
                return MenuResult.success();
            }
            catch (MissingMandatoryPropertiesException e) {
                if (!app.isInteractive()) {
                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, e.getMessageObject(), (Throwable)e);
                }
                app.errPrintln();
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(app, e);
                app.errPrintln();
                if (app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) continue;
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (ConcurrentModificationException e) {
                msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (OperationRejectedException e) {
                if (!app.isInteractive()) {
                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, e.getMessageObject(), (Throwable)e);
                }
                app.errPrintln();
                ArgumentExceptionFactory.displayOperationRejectedException(app, e);
                app.errPrintln();
                if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_PROMPT_EDIT_AGAIN.get((Object)ufn), true)) return MenuResult.cancel();
                continue;
            }
            catch (LdapException e) {
                msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get((Object)ufn, (Object)e.getMessage());
                return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.CLIENT_SIDE_SERVER_DOWN);
            }
            catch (ManagedObjectAlreadyExistsException e) {
                msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_MOAEE.get((Object)ufn);
                return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.ENTRY_ALREADY_EXISTS);
            }
            break;
        }
    }

    private static boolean cannotDisplay(ConsoleApplication app, PropertyDefinition<?> pd) {
        return pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED);
    }

    private static <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> createChildInteractively(ConsoleApplication app, final ManagedObject<?> parent, final InstantiableRelationDefinition<C, S> irelation, final ManagedObjectDefinition<? extends C, ? extends S> d, final List<PropertyException> exceptions) throws ClientException {
        ValidationCallback validator = new ValidationCallback<ManagedObject<? extends C>>(){

            public ManagedObject<? extends C> validate(ConsoleApplication app, String input) throws ClientException {
                ManagedObject child;
                try {
                    child = parent.createChild(irelation, d, input, exceptions);
                }
                catch (IllegalManagedObjectNameException e) {
                    app.errPrintln();
                    app.errPrintln(ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d).getMessageObject());
                    app.errPrintln();
                    return null;
                }
                try {
                    parent.getChild(irelation, input);
                }
                catch (AuthorizationException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)irelation.getUserFriendlyName());
                    throw new ClientException(ReturnCode.ERROR_USER_DATA, msg);
                }
                catch (ConcurrentModificationException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get((Object)irelation.getUserFriendlyName());
                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
                }
                catch (LdapException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get((Object)irelation.getUserFriendlyName(), (Object)e.getMessage());
                    throw new ClientException(ReturnCode.APPLICATION_ERROR, msg);
                }
                catch (DefinitionDecodingException | ManagedObjectDecodingException e) {
                }
                catch (ManagedObjectNotFoundException e) {
                    return child;
                }
                app.errPrintln();
                app.errPrintln(DsconfigMessages.ERR_DSCFG_ERROR_CREATE_NAME_ALREADY_EXISTS.get((Object)irelation.getUserFriendlyName(), (Object)input));
                app.errPrintln();
                return null;
            }
        };
        LocalizableMessage ufn = d.getUserFriendlyName();
        PropertyDefinition<?> pd = irelation.getNamingPropertyDefinition();
        if (pd != null) {
            app.println(DsconfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT_NAMING.get((Object)ufn, (Object)pd.getName()));
            app.println();
            app.errPrintln(pd.getSynopsis(), 4);
            if (pd.getDescription() != null) {
                app.println();
                app.errPrintln(pd.getDescription(), 4);
            }
            PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
            TableBuilder builder = new TableBuilder();
            builder.startRow();
            builder.appendCell((Object)DsconfigMessages.INFO_EDITOR_HEADING_SYNTAX.get());
            builder.appendCell((Object)b.getUsage(pd));
            TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
            printer.setDisplayHeadings(false);
            printer.setIndentWidth(4);
            printer.setColumnWidth(1, 0);
            app.println();
            builder.print((TablePrinter)printer);
            app.println();
            return (ManagedObject)app.readValidatedInput(DsconfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT_NAMING_CONT.get((Object)ufn), validator);
        }
        return (ManagedObject)app.readValidatedInput(DsconfigMessages.INFO_DSCFG_CREATE_NAME_PROMPT.get((Object)ufn), validator);
    }

    private static <C extends ConfigurationClient, S extends Configuration> MenuResult<ManagedObjectDefinition<? extends C, ? extends S>> getTypeInteractively(ConsoleApplication app, AbstractManagedObjectDefinition<C, S> d, Set<String> prohibitedTypes) throws ClientException {
        LinkedList<ManagedObjectDefinition<C, S>> filteredTypes = new LinkedList<ManagedObjectDefinition<C, S>>(CreateSubCommandHandler.getSubTypes(d).values());
        boolean isOnlyOneType = filteredTypes.size() == 1;
        Iterator i = filteredTypes.iterator();
        while (i.hasNext()) {
            ManagedObjectDefinition cd = (ManagedObjectDefinition)i.next();
            if (!prohibitedTypes.contains(cd.getName()) && !CreateSubCommandHandler.cannotDisplayAdvancedOrCustomTypes(app, cd)) continue;
            i.remove();
        }
        if (filteredTypes.size() == 0) {
            app.errPrintln(DsconfigMessages.ERR_DSCFG_ERROR_NO_AVAILABLE_TYPES.get((Object)d.getUserFriendlyName()));
            return MenuResult.cancel();
        }
        if (filteredTypes.size() == 1) {
            LocalizableMessage msg;
            ManagedObjectDefinition type = (ManagedObjectDefinition)filteredTypes.iterator().next();
            if (!isOnlyOneType && !app.confirmAction(msg = DsconfigMessages.INFO_DSCFG_TYPE_PROMPT_SINGLE.get((Object)d.getUserFriendlyName(), (Object)type.getUserFriendlyName()), true)) {
                return MenuResult.cancel();
            }
            return MenuResult.success((Object)type);
        }
        MenuBuilder builder = new MenuBuilder(app);
        LocalizableMessage msg = DsconfigMessages.INFO_DSCFG_CREATE_TYPE_PROMPT.get((Object)d.getUserFriendlyName());
        builder.setMultipleColumnThreshold(8);
        builder.setPrompt(msg);
        for (ManagedObjectDefinition managedObjectDefinition : filteredTypes) {
            LocalizableMessage option = managedObjectDefinition.getUserFriendlyName();
            if (CLIProfile.getInstance().isForCustomization(managedObjectDefinition)) {
                option = DsconfigMessages.INFO_DSCFG_CUSTOM_TYPE_OPTION.get((Object)option);
            } else if (managedObjectDefinition == d) {
                option = DsconfigMessages.INFO_DSCFG_GENERIC_TYPE_OPTION.get((Object)option);
            }
            builder.addNumberedOption(option, MenuResult.success((Object)managedObjectDefinition), new LocalizableMessage[0]);
        }
        builder.addHelpOption(new TypeHelpCallback(d));
        if (app.isMenuDrivenMode()) {
            builder.addCancelOption(true);
        }
        builder.addQuitOption();
        return builder.toMenu().run();
    }

    private static boolean cannotDisplayAdvancedOrCustomTypes(ConsoleApplication app, ManagedObjectDefinition<?, ?> defn) {
        return !app.isAdvancedMode() && (defn.hasOption(ManagedObjectOption.ADVANCED) || CLIProfile.getInstance().isForCustomization(defn));
    }

    private CreateSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<C, S> r, PropertyDefinition<?> pd, ManagedObjectPath<?, ?> c) throws ArgumentException {
        this.path = p;
        this.relation = r;
        this.namingPropertyDefinition = pd;
        String name = "create-" + r.getName();
        LocalizableMessage description = DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_CREATE.get((Object)r.getChildDefinition().getUserFriendlyPluralName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.types = CreateSubCommandHandler.getSubTypes(r.getChildDefinition());
        this.namingArgs = this.createNamingArgs(this.subCommand, c, true);
        this.typeUsage = CreateSubCommandHandler.getSubTypesUsage(r.getChildDefinition());
        this.propertySetArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_SET).shortIdentifier(OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand);
        StringArgument.Builder typeArgumentBuilder = (StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_TYPE).shortIdentifier(OPTION_DSCFG_SHORT_TYPE)).valuePlaceholder(DsconfigMessages.INFO_TYPE_PLACEHOLDER.get());
        if (!this.types.containsKey("generic")) {
            typeArgumentBuilder.description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_TYPE.get((Object)r.getChildDefinition().getUserFriendlyName(), (Object)this.typeUsage));
        } else {
            ((StringArgument.Builder)typeArgumentBuilder.description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_TYPE_DEFAULT.get((Object)r.getChildDefinition().getUserFriendlyName(), (Object)"generic", (Object)this.typeUsage))).defaultValue((Object)"generic");
            if (this.types.size() == 1) {
                typeArgumentBuilder.hidden();
            }
        }
        this.typeArgument = (StringArgument)typeArgumentBuilder.buildAndAddToSubCommand(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        void var12_40;
        ManagedObjectDefinition d;
        ManagedObject parent;
        ManagementContext context;
        List<String> names;
        block38: {
            Set<String> prohibitedTypes;
            MenuResult<ManagedObject<?>> result;
            LocalizableMessage rufn = this.relation.getUserFriendlyName();
            names = this.getNamingArgValues(app, this.namingArgs);
            this.getCommandBuilder().clearArguments();
            this.setCommandBuilderUseful(false);
            this.updateCommandBuilderWithSubCommand();
            context = factory.getManagementContext(app);
            try {
                result = this.getManagedObject(app, context, this.path, names);
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)rufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (DefinitionDecodingException e) {
                LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get((Object)pufn, (Object)pufn, (Object)pufn);
                throw new ClientException(ReturnCode.OTHER, msg);
            }
            catch (ManagedObjectDecodingException e) {
                LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get((Object)pufn);
                throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get((Object)rufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get((Object)pufn);
                return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.NO_SUCH_OBJECT);
            }
            catch (LdapException e) {
                throw new ClientException(ReturnCode.OTHER, LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
            }
            if (result.isQuit()) {
                if (!app.isMenuDrivenMode()) {
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get((Object)rufn));
                }
                return MenuResult.quit();
            }
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            parent = (ManagedObject)result.getValue();
            if (this.relation instanceof SetRelationDefinition) {
                SetRelationDefinition sr = (SetRelationDefinition)this.relation;
                prohibitedTypes = new HashSet();
                try {
                    void var12_34;
                    String[] arr$ = parent.listChildren(sr);
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var12_34 < len$) {
                        String child = arr$[var12_34];
                        prohibitedTypes.add(child);
                        ++var12_34;
                    }
                }
                catch (AuthorizationException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)rufn);
                    throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
                }
                catch (ConcurrentModificationException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CME.get((Object)rufn);
                    throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
                }
                catch (LdapException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get((Object)rufn, (Object)e.getMessage());
                    throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
                }
            } else {
                prohibitedTypes = Collections.emptySet();
            }
            if (!this.typeArgument.isPresent()) {
                if (app.isInteractive()) {
                    app.println();
                    app.println();
                    MenuResult<ManagedObjectDefinition<C, S>> dresult = CreateSubCommandHandler.getTypeInteractively(app, this.relation.getChildDefinition(), prohibitedTypes);
                    if (dresult.isSuccess()) {
                        d = (ManagedObjectDefinition)dresult.getValue();
                        break block38;
                    } else {
                        if (dresult.isCancel()) {
                            return MenuResult.cancel();
                        }
                        if (!app.isMenuDrivenMode()) {
                            app.println();
                            app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_CREATE_FAIL.get((Object)rufn));
                        }
                        return MenuResult.quit();
                    }
                }
                if (this.typeArgument.getDefaultValue() == null) {
                    throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument((Argument)this.typeArgument);
                }
                d = (ManagedObjectDefinition)this.types.get(this.typeArgument.getDefaultValue());
            } else {
                d = (ManagedObjectDefinition)this.types.get(this.typeArgument.getValue());
                if (d == null) {
                    throw ArgumentExceptionFactory.unknownSubType(this.relation, this.typeArgument.getValue(), this.typeUsage);
                }
            }
        }
        List propertyArgs = this.propertySetArgument.getValues();
        MyPropertyProvider provider = new MyPropertyProvider(d, this.namingPropertyDefinition, propertyArgs);
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        boolean isNameProvidedInteractively = false;
        String providedNamingArgName = null;
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            String name = names.get(names.size() - 1);
            if (name == null) {
                if (!app.isInteractive()) {
                    throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument((Argument)this.namingArgs.get(names.size() - 1));
                }
                app.println();
                app.println();
                ManagedObject<C> managedObject = CreateSubCommandHandler.createChildInteractively(app, parent, irelation, d, exceptions);
                isNameProvidedInteractively = true;
                providedNamingArgName = CLIProfile.getInstance().getNamingArgument(irelation);
            } else {
                try {
                    ManagedObject managedObject = parent.createChild(irelation, d, name, exceptions);
                }
                catch (IllegalManagedObjectNameException e) {
                    throw ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                }
            }
        } else if (this.relation instanceof SetRelationDefinition) {
            SetRelationDefinition srelation = (SetRelationDefinition)this.relation;
            ManagedObject managedObject = parent.createChild(srelation, d, exceptions);
        } else {
            OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
            ManagedObject managedObject = parent.createChild(orelation, d, exceptions);
        }
        for (PropertyDefinition<?> pd : provider.getProperties()) {
            this.setProperty((ManagedObject<?>)var12_40, provider, pd);
        }
        MenuResult<Void> result2 = CreateSubCommandHandler.commitManagedObject(app, context, var12_40, this);
        if (result2.isCancel()) {
            return MenuResult.cancel();
        }
        if (result2.isQuit()) {
            return MenuResult.quit();
        }
        this.addArgumentsToCommandBuilder(d, (ManagedObject<? extends C>)var12_40, isNameProvidedInteractively, providedNamingArgName);
        return MenuResult.success((Object)0);
    }

    private void addArgumentsToCommandBuilder(ManagedObjectDefinition<? extends C, ? extends S> d, ManagedObject<? extends C> child, boolean isNameProvidedInteractively, String providedNamingArgName) throws ArgumentException {
        CommandBuilder commandBuilder = this.getCommandBuilder();
        if (this.typeArgument.hasValue()) {
            commandBuilder.addArgument((Argument)this.typeArgument);
        } else {
            StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_TYPE).shortIdentifier(OPTION_DSCFG_SHORT_TYPE)).description(this.typeArgument.getDescription())).defaultValue((Object)this.typeArgument.getDefaultValue())).valuePlaceholder(DsconfigMessages.INFO_TYPE_PLACEHOLDER.get())).buildArgument();
            arg.addValue(this.getTypeName(d));
            commandBuilder.addArgument((Argument)arg);
        }
        if (this.propertySetArgument.hasValue()) {
            StringArgument filteredArg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_SET).shortIdentifier(OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
            for (String string : this.propertySetArgument.getValues()) {
                if (!this.canAddValue(commandBuilder, string)) continue;
                filteredArg.addValue(string);
            }
            if (filteredArg.hasValue()) {
                commandBuilder.addArgument((Argument)filteredArg);
            }
        }
        LinkedList argsCopy = new LinkedList(commandBuilder.getArguments());
        for (Argument argument : argsCopy) {
            if (argument == null || !OPTION_DSCFG_LONG_RESET.equals(argument.getLongIdentifier()) && !OPTION_DSCFG_LONG_REMOVE.equals(argument.getLongIdentifier())) continue;
            commandBuilder.removeArgument(argument);
        }
        if (isNameProvidedInteractively) {
            StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)providedNamingArgName).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildArgument();
            arg.addValue(child.getManagedObjectPath().getName());
            commandBuilder.addArgument((Argument)arg);
        } else {
            for (StringArgument stringArgument : this.namingArgs) {
                if (!stringArgument.isPresent()) continue;
                commandBuilder.addArgument((Argument)stringArgument);
            }
        }
    }

    private boolean canAddValue(CommandBuilder commandBuilder, String value) {
        int index = value.indexOf(58);
        if (index == -1) {
            return false;
        }
        String propName = value.substring(0, index);
        for (Argument arg : commandBuilder.getArguments()) {
            for (String value2 : arg.getValues()) {
                String prop2Name = this.getPropName(arg.getLongIdentifier(), value2);
                if (!propName.equalsIgnoreCase(prop2Name)) continue;
                return false;
            }
        }
        return true;
    }

    private String getPropName(String argName, String value) {
        if (OPTION_DSCFG_LONG_SET.equals(argName) || OPTION_DSCFG_LONG_REMOVE.equals(argName)) {
            int index = value.indexOf(58);
            if (index != -1) {
                return value.substring(0, index);
            }
        } else if (OPTION_DSCFG_LONG_RESET.equals(argName)) {
            return value;
        }
        return null;
    }

    private <T> void setProperty(ManagedObject<?> mo, MyPropertyProvider provider, PropertyDefinition<T> pd) {
        mo.setPropertyValues(pd, provider.getPropertyValues(pd));
    }

    private static <T> Argument createArgument(PropertyEditorModification<T> mod) throws ArgumentException {
        switch (mod.getType()) {
            case ADD: 
            case SET: {
                StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_SET).shortIdentifier(OPTION_DSCFG_SHORT_SET)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                CreateSubCommandHandler.addValues(mod, arg);
                return arg;
            }
            case RESET: {
                StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_RESET).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_RESET_PROP.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_PROPERTY_PLACEHOLDER.get())).buildArgument();
                arg.addValue(mod.getPropertyDefinition().getName());
                return arg;
            }
            case REMOVE: {
                StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_REMOVE).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_REMOVE_PROP_VAL.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_VALUE_SET_PLACEHOLDER.get())).buildArgument();
                CreateSubCommandHandler.addValues(mod, arg);
                return arg;
            }
        }
        throw new IllegalStateException("Unknown modification type: " + (Object)((Object)mod.getType()));
    }

    private static <T> void addValues(PropertyEditorModification<T> mod, StringArgument arg) {
        PropertyDefinition<T> propertyDefinition = mod.getPropertyDefinition();
        String propName = propertyDefinition.getName();
        for (Object value : mod.getModificationValues()) {
            arg.addValue(propName + ':' + CreateSubCommandHandler.getArgumentValue(propertyDefinition, value));
        }
    }

    private String getTypeName(ManagedObjectDefinition<? extends C, ? extends S> d) {
        for (String key : this.types.keySet()) {
            ManagedObjectDefinition current = (ManagedObjectDefinition)this.types.get(key);
            if (!current.equals(d)) continue;
            return key;
        }
        return d.getName();
    }

    private static final class TypeHelpCallback<C extends ConfigurationClient, S extends Configuration>
    implements HelpCallback {
        private final AbstractManagedObjectDefinition<C, S> d;

        private TypeHelpCallback(AbstractManagedObjectDefinition<C, S> d) {
            this.d = d;
        }

        public void display(ConsoleApplication app) {
            app.println(DsconfigMessages.INFO_DSCFG_CREATE_TYPE_HELP_HEADING.get((Object)this.d.getUserFriendlyPluralName()));
            app.println();
            app.println(this.d.getSynopsis());
            if (this.d.getDescription() != null) {
                app.println();
                app.println(this.d.getDescription());
            }
            app.println();
            app.println();
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(DsconfigMessages.INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_TYPE.get());
            builder.appendHeading(DsconfigMessages.INFO_DSCFG_DESCRIPTION_CREATE_HELP_HEADING_DESCR.get());
            boolean isFirst = true;
            for (ManagedObjectDefinition<C, S> mod : SubCommandHandler.getSubTypes(this.d).values()) {
                if (CreateSubCommandHandler.cannotDisplayAdvancedOrCustomTypes(app, mod)) continue;
                LocalizableMessage ufn = mod.getUserFriendlyName();
                LocalizableMessage synopsis = mod.getSynopsis();
                LocalizableMessage description = mod.getDescription();
                if (CLIProfile.getInstance().isForCustomization(mod)) {
                    ufn = DsconfigMessages.INFO_DSCFG_CUSTOM_TYPE_OPTION.get((Object)ufn);
                    synopsis = DsconfigMessages.INFO_DSCFG_CUSTOM_TYPE_SYNOPSIS.get((Object)ufn);
                    description = null;
                } else if (mod == this.d) {
                    ufn = DsconfigMessages.INFO_DSCFG_GENERIC_TYPE_OPTION.get((Object)ufn);
                    synopsis = DsconfigMessages.INFO_DSCFG_GENERIC_TYPE_SYNOPSIS.get((Object)ufn);
                    description = null;
                }
                if (!isFirst) {
                    builder.startRow();
                    builder.startRow();
                } else {
                    isFirst = false;
                }
                builder.startRow();
                builder.appendCell((Object)ufn);
                builder.appendCell((Object)synopsis);
                if (description == null) continue;
                builder.startRow();
                builder.startRow();
                builder.appendCell();
                builder.appendCell((Object)description);
            }
            TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
            printer.setColumnWidth(1, 0);
            printer.setColumnSeparator(":");
            builder.print((TablePrinter)printer);
            app.println();
            app.pressReturnToContinue();
        }
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private final Map<PropertyDefinition<?>, Collection<?>> properties = new HashMap();

        public MyPropertyProvider(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> namingPropertyDefinition, List<String> args) throws ArgumentException {
            for (String s : args) {
                PropertyDefinition<?> pd;
                int sep = s.indexOf(58);
                if (sep < 0) {
                    throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(s);
                }
                if (sep == 0) {
                    throw ArgumentExceptionFactory.missingNameInPropertyArgument(s);
                }
                String propertyName = s.substring(0, sep);
                String value = s.substring(sep + 1, s.length());
                if (value.length() == 0) {
                    throw ArgumentExceptionFactory.missingValueInPropertyArgument(s);
                }
                try {
                    pd = d.getPropertyDefinition(propertyName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
                }
                if (pd.equals(namingPropertyDefinition)) {
                    throw ArgumentExceptionFactory.unableToSetNamingProperty(d, pd);
                }
                this.addPropertyValue(d, pd, value);
            }
        }

        public Set<PropertyDefinition<?>> getProperties() {
            return this.properties.keySet();
        }

        @Override
        public <T> Collection<T> getPropertyValues(PropertyDefinition<T> d) {
            Collection<?> values = this.properties.get(d);
            if (values != null) {
                return values;
            }
            return Collections.emptySet();
        }

        private <T> void addPropertyValue(ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd, String s) throws ArgumentException {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (PropertyException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            Collection<?> values = this.properties.get(pd);
            if (values == null) {
                values = new LinkedList();
            }
            values.add(value);
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                PropertyException e = PropertyException.propertyIsSingleValuedException(pd);
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            this.properties.put(pd, values);
        }
    }
}

