/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.ManagedObjectPath;

public final class RelativeInheritedDefaultBehaviorProvider<T>
extends DefaultBehaviorProvider<T> {
    private final AbstractManagedObjectDefinition<?, ?> d;
    private final int offset;
    private final String propertyName;

    public RelativeInheritedDefaultBehaviorProvider(AbstractManagedObjectDefinition<?, ?> d, String propertyName, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.d = d;
        this.propertyName = propertyName;
        this.offset = offset;
    }

    @Override
    public <R, P> R accept(DefaultBehaviorProviderVisitor<T, R, P> v, P p) {
        return v.visitRelativeInherited(this, p);
    }

    public AbstractManagedObjectDefinition<?, ?> getManagedObjectDefinition() {
        return this.d;
    }

    public ManagedObjectPath<?, ?> getManagedObjectPath(ManagedObjectPath<?, ?> path) {
        return path.parent(this.offset);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public int getRelativeOffset() {
        return this.offset;
    }
}

