/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.WriteLockInfo;

public class LockResult {
    private LockGrantType grant;
    private WriteLockInfo info;

    public LockResult(LockGrantType grant, WriteLockInfo info) {
        this.grant = grant;
        this.info = info;
    }

    public LockGrantType getLockGrant() {
        return this.grant;
    }

    public void setAbortLsn(long abortLsn, boolean abortKnownDeleted) {
        this.setAbortLsn(abortLsn, abortKnownDeleted, false);
    }

    public void setAbortLsn(long abortLsn, boolean abortKnownDeleted, boolean createdThisTxn) {
        if (this.info != null && this.info.getNeverLocked()) {
            if (abortLsn != -1L) {
                this.info.setAbortLsn(abortLsn);
                this.info.setAbortKnownDeleted(abortKnownDeleted);
            }
            this.info.setCreatedThisTxn(createdThisTxn);
            this.info.setNeverLocked(false);
        }
    }

    public void copyAbortInfo(WriteLockInfo fromInfo) {
        if (this.info != null) {
            this.info.copyAbortInfo(fromInfo);
        }
    }

    public void copyWriteLockInfo(LockResult fromResult) {
        this.copyWriteLockInfo(fromResult.info);
    }

    public void copyWriteLockInfo(WriteLockInfo fromInfo) {
        if (fromInfo != null) {
            this.setAbortLsn(fromInfo.getAbortLsn(), fromInfo.getAbortKnownDeleted(), fromInfo.getCreatedThisTxn());
            this.copyAbortInfo(fromInfo);
        }
    }

    public WriteLockInfo getWriteLockInfo() {
        return this.info;
    }
}

