/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.INSummary;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanerFileReader
extends FileReader {
    private static final byte IS_LN = 0;
    private static final byte IS_IN = 1;
    private static final byte IS_BIN_DELTA = 2;
    private static final byte IS_DBTREE = 3;
    private static final byte IS_FILEHEADER = 4;
    private final Map<LogEntryType, EntryInfo> targetEntryMap;
    private LogEntry targetLogEntry;
    private byte targetCategory;
    private final FileSummary fileSummary;
    private final INSummary inSummary;
    private VLSN lastVLSN = VLSN.NULL_VLSN;

    public CleanerFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, Long fileNum, FileSummary fileSummary, INSummary inSummary) throws DatabaseException {
        super(env, readBufferSize, true, startLsn, fileNum, -1L, -1L);
        this.fileSummary = fileSummary;
        this.inSummary = inSummary;
        this.targetEntryMap = new HashMap<LogEntryType, EntryInfo>();
        for (LogEntryType entryType : LogEntryType.getAllTypes()) {
            if (entryType.isLNType()) {
                this.addTargetType((byte)0, entryType);
            }
            if (!entryType.isINType()) continue;
            this.addTargetType((byte)1, entryType);
        }
        this.addTargetType((byte)2, LogEntryType.LOG_BIN_DELTA);
        this.addTargetType((byte)3, LogEntryType.LOG_DBTREE);
        this.addTargetType((byte)4, LogEntryType.LOG_FILE_HEADER);
    }

    private void addTargetType(byte category, LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, new EntryInfo(entryType.getNewLogEntry(), category));
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        EntryInfo info;
        VLSN vlsn;
        LogEntryType type = LogEntryType.findType(this.currentEntryHeader.getType());
        int size = this.getLastEntrySize();
        if (this.currentEntryHeader.getType() != LogEntryType.LOG_FILE_HEADER.getTypeNum()) {
            ++this.fileSummary.totalCount;
            this.fileSummary.totalSize += size;
            if (BaseUtilizationTracker.trackObsoleteInfo(type)) {
                if (BaseUtilizationTracker.isLNType(type)) {
                    ++this.fileSummary.totalLNCount;
                    this.fileSummary.totalLNSize += size;
                } else {
                    ++this.fileSummary.totalINCount;
                    this.fileSummary.totalINSize += size;
                    if (type.isINType()) {
                        ++this.inSummary.totalINCount;
                        this.inSummary.totalINSize += size;
                    }
                    if (type.equals(LogEntryType.LOG_BIN_DELTA)) {
                        ++this.inSummary.totalBINDeltaCount;
                        this.inSummary.totalBINDeltaSize += size;
                    }
                }
            }
        }
        if (this.currentEntryHeader.isInvisible()) {
            this.skipEntry(entryBuffer);
            this.countObsolete();
            return false;
        }
        if (this.currentEntryHeader.getReplicated() && (vlsn = this.currentEntryHeader.getVLSN()) != null) {
            assert (vlsn.compareTo(this.lastVLSN) > 0) : "vlsns out of order, last=" + this.lastVLSN + " current=" + vlsn;
            this.lastVLSN = vlsn;
        }
        if ((info = this.targetEntryMap.get(type)) == null) {
            this.skipEntry(entryBuffer);
            this.countObsolete();
            return false;
        }
        this.targetCategory = info.targetCategory;
        this.targetLogEntry = info.targetLogEntry;
        this.targetLogEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        return true;
    }

    public void countObsolete() {
        LogEntryType type = LogEntryType.findType(this.currentEntryHeader.getType());
        if (!BaseUtilizationTracker.trackObsoleteInfo(type)) {
            return;
        }
        int size = this.getLastEntrySize();
        if (BaseUtilizationTracker.isLNType(type)) {
            ++this.fileSummary.obsoleteLNCount;
            this.fileSummary.obsoleteLNSize += size;
            ++this.fileSummary.obsoleteLNSizeCounted;
        } else {
            ++this.fileSummary.obsoleteINCount;
            if (type.isINType()) {
                ++this.inSummary.obsoleteINCount;
                this.inSummary.obsoleteINSize += size;
            }
            if (type.equals(LogEntryType.LOG_BIN_DELTA)) {
                ++this.inSummary.obsoleteBINDeltaCount;
                this.inSummary.obsoleteBINDeltaSize += size;
            }
        }
    }

    public boolean isIN() {
        return this.targetCategory == 1;
    }

    public boolean isBINDelta() {
        return this.targetCategory == 2;
    }

    public boolean isLN() {
        return this.targetCategory == 0;
    }

    public boolean isDbTree() {
        return this.targetCategory == 3;
    }

    public boolean isFileHeader() {
        return this.targetCategory == 4;
    }

    public LNLogEntry<?> getLNLogEntry() {
        return (LNLogEntry)this.targetLogEntry;
    }

    public boolean isLNDeleted() {
        return ((LNLogEntry)this.targetLogEntry).isDeleted();
    }

    public IN getIN(DatabaseImpl dbImpl) {
        return ((INLogEntry)this.targetLogEntry).getIN(dbImpl);
    }

    public BINDelta getBINDelta() {
        return (BINDelta)((BINDeltaLogEntry)this.targetLogEntry).getMainItem();
    }

    public FileHeader getFileHeader() {
        return (FileHeader)this.targetLogEntry.getMainItem();
    }

    public DatabaseId getDatabaseId() {
        if (this.targetCategory == 0) {
            return ((LNLogEntry)this.targetLogEntry).getDbId();
        }
        if (this.targetCategory == 1) {
            return ((INLogEntry)this.targetLogEntry).getDbId();
        }
        if (this.targetCategory == 2) {
            return ((BINDeltaLogEntry)this.targetLogEntry).getDbId();
        }
        return null;
    }

    public VLSN getLastVLSN() {
        return this.lastVLSN;
    }

    private static class EntryInfo {
        public LogEntry targetLogEntry;
        public byte targetCategory;

        EntryInfo(LogEntry targetLogEntry, byte targetCategory) {
            this.targetLogEntry = targetLogEntry;
            this.targetCategory = targetCategory;
        }
    }
}

