/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;

class CompressedOopsDetector {
    private static final String HOTSPOT_BEAN_CLASS = "com.sun.management.HotSpotDiagnosticMXBean";
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String VMOPTION_CLASS = "com.sun.management.VMOption";

    CompressedOopsDetector() {
    }

    static Boolean isEnabled() {
        try {
            return CompressedOopsDetector.isEnabledInternal();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Boolean isEnabledInternal() throws Throwable {
        Class<?> hotspotMBeanClass = Class.forName(HOTSPOT_BEAN_CLASS);
        Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), HOTSPOT_BEAN_NAME, hotspotMBeanClass);
        Method getVMOption = hotspotMBeanClass.getMethod("getVMOption", String.class);
        Object vmOption = getVMOption.invoke(hotspotMBean, "UseCompressedOops");
        Class<?> vmOptionClass = Class.forName(VMOPTION_CLASS);
        Method getValue = vmOptionClass.getMethod("getValue", new Class[0]);
        String value = (String)getValue.invoke(vmOption, new Object[0]);
        return Boolean.valueOf(value);
    }

    public static void main(String[] args) {
        try {
            System.out.println("isEnabled(): " + CompressedOopsDetector.isEnabled());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

