/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.json.JsonValue;

public final class JsonSchemaUtils {
    private static final String PROPERTIES = "properties";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String OBJECT = "object";
    private static final String FORWARD_SLASH = "/";

    private JsonSchemaUtils() {
    }

    public static Set<String> generateJsonPointers(JsonValue schema) {
        return JsonSchemaUtils.concatPrefix(JsonSchemaUtils.getPointers(schema.get(PROPERTIES)), schema.get(ID).asString());
    }

    private static Set<String> getPointers(JsonValue properties) {
        LinkedHashSet<String> pointers = new LinkedHashSet<String>();
        Set keys = properties.keys();
        for (String key : keys) {
            JsonValue property = properties.get(key);
            if (OBJECT.equals(property.get(TYPE).asString())) {
                Set<String> subPointers = JsonSchemaUtils.getPointers(property.get(PROPERTIES));
                pointers.addAll(JsonSchemaUtils.concatPrefix(subPointers, key));
                continue;
            }
            pointers.add(key);
        }
        return pointers;
    }

    private static Set<String> concatPrefix(Set<String> pointers, String id) {
        LinkedHashSet<String> newPointers = new LinkedHashSet<String>();
        if (pointers.isEmpty()) {
            newPointers.add(id);
            return newPointers;
        }
        for (String pointer : pointers) {
            StringBuilder stringBuilder = new StringBuilder();
            if (FORWARD_SLASH.equals(id)) {
                stringBuilder.append(id).append(pointer);
            } else {
                stringBuilder.append(id).append(FORWARD_SLASH).append(pointer);
            }
            newPointers.add(stringBuilder.toString());
        }
        return newPointers;
    }
}

