/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.rotation;

import java.util.concurrent.TimeUnit;
import org.forgerock.audit.rotation.RotatableObject;
import org.forgerock.audit.rotation.RotationPolicy;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class TimeLimitRotationPolicy
implements RotationPolicy {
    private final org.forgerock.util.time.Duration rotationInterval;
    private final long rotationIntervalInMillis;

    public TimeLimitRotationPolicy(org.forgerock.util.time.Duration rotationInterval) {
        this.rotationInterval = rotationInterval;
        this.rotationIntervalInMillis = rotationInterval.convertTo(TimeUnit.MILLISECONDS).getValue();
    }

    @Override
    public boolean shouldRotateFile(RotatableObject rotatable) {
        if (this.rotationInterval.isZero() || this.rotationInterval.isUnlimited()) {
            return false;
        }
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        DateTime lastRotationTime = rotatable.getLastRotationTime();
        Duration timeSinceLastRotation = new Duration((ReadableInstant)lastRotationTime, (ReadableInstant)now);
        return timeSinceLastRotation.getMillis() >= this.rotationIntervalInMillis;
    }

    public org.forgerock.util.time.Duration getRotationInterval() {
        return this.rotationInterval;
    }
}

