/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.util.Reject;

public class FileBasedEventHandlerConfiguration
extends EventHandlerConfiguration {
    @JsonPropertyDescription(value="audit.handlers.file.fileRotation")
    private FileRotation fileRotation = new FileRotation();
    @JsonPropertyDescription(value="audit.handlers.file.fileRetention")
    private FileRetention fileRetention = new FileRetention();
    @JsonPropertyDescription(value="audit.handlers.file.rotationRetentionCheckInterval")
    private String rotationRetentionCheckInterval = "5s";

    public FileRotation getFileRotation() {
        return this.fileRotation;
    }

    public void setFileRotation(FileRotation fileRotation) {
        Reject.ifNull((Object)fileRotation);
        this.fileRotation = fileRotation;
    }

    public FileRetention getFileRetention() {
        return this.fileRetention;
    }

    public void setFileRetention(FileRetention fileRetention) {
        Reject.ifNull((Object)fileRetention);
        this.fileRetention = fileRetention;
    }

    public String getRotationRetentionCheckInterval() {
        return this.rotationRetentionCheckInterval;
    }

    public void setRotationRetentionCheckInterval(String rotationRetentionCheckInterval) {
        this.rotationRetentionCheckInterval = rotationRetentionCheckInterval;
    }

    public static class FileRetention {
        public static final int UNLIMITED_HISTORY_FILES = -1;
        public static final long ANY_DISK_SPACE = -1L;
        @JsonPropertyDescription(value="audit.handlers.file.maxNumberOfHistoryFiles")
        private int maxNumberOfHistoryFiles = -1;
        @JsonPropertyDescription(value="audit.handlers.file.maxDiskSpaceToUse")
        private long maxDiskSpaceToUse = -1L;
        @JsonPropertyDescription(value="audit.handlers.file.minFreeSpaceRequired")
        private long minFreeSpaceRequired = -1L;

        public int getMaxNumberOfHistoryFiles() {
            return this.maxNumberOfHistoryFiles;
        }

        public void setMaxNumberOfHistoryFiles(int maxNumberOfHistoryFiles) {
            this.maxNumberOfHistoryFiles = maxNumberOfHistoryFiles;
        }

        public long getMaxDiskSpaceToUse() {
            return this.maxDiskSpaceToUse;
        }

        public void setMaxDiskSpaceToUse(long maxDiskSpaceToUse) {
            this.maxDiskSpaceToUse = maxDiskSpaceToUse;
        }

        public long getMinFreeSpaceRequired() {
            return this.minFreeSpaceRequired;
        }

        public void setMinFreeSpaceRequired(long minFreeSpaceRequired) {
            this.minFreeSpaceRequired = minFreeSpaceRequired;
        }
    }

    public static class FileRotation {
        public static final long NO_MAX_FILE_SIZE = -1L;
        public static final String DEFAULT_ROTATION_FILE_SUFFIX = "-yyyy.MM.dd-HH.mm.ss";
        @JsonPropertyDescription(value="audit.handlers.file.rotationEnabled")
        private boolean rotationEnabled = false;
        @JsonPropertyDescription(value="audit.handlers.file.maxFileSize")
        private long maxFileSize = -1L;
        @JsonPropertyDescription(value="audit.handlers.file.rotationFilePrefix")
        private String rotationFilePrefix = null;
        @JsonPropertyDescription(value="audit.handlers.file.rotationTimes")
        private final List<String> rotationTimes = new LinkedList<String>();
        @JsonPropertyDescription(value="audit.handlers.file.rotationFileSuffix")
        private String rotationFileSuffix = "-yyyy.MM.dd-HH.mm.ss";
        @JsonPropertyDescription(value="audit.handlers.file.rotationInterval")
        private String rotationInterval = "disabled";

        public boolean isRotationEnabled() {
            return this.rotationEnabled;
        }

        public void setRotationEnabled(boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        public void setMaxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public String getRotationFilePrefix() {
            return this.rotationFilePrefix;
        }

        public void setRotationFilePrefix(String rotationFilePrefix) {
            this.rotationFilePrefix = rotationFilePrefix;
        }

        public String getRotationFileSuffix() {
            return this.rotationFileSuffix;
        }

        public void setRotationFileSuffix(String rotationFileSuffix) {
            this.rotationFileSuffix = rotationFileSuffix;
        }

        public String getRotationInterval() {
            return this.rotationInterval;
        }

        public void setRotationInterval(String rotationInterval) {
            this.rotationInterval = rotationInterval;
        }

        public List<String> getRotationTimes() {
            return this.rotationTimes;
        }

        public void setRotationTimes(List<String> rotationTimes) {
            this.rotationTimes.addAll(rotationTimes);
        }
    }
}

