/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import org.forgerock.audit.events.AuditEventBuilder;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.Request;

abstract class StateChangeAuditEventBuilder<T extends StateChangeAuditEventBuilder<T>>
extends AuditEventBuilder<T> {
    public static final String RUN_AS = "runAs";
    public static final String OBJECT_ID = "objectId";
    public static final String OPERATION = "operation";
    public static final String BEFORE = "before";
    public static final String AFTER = "after";
    public static final String REVISION = "revision";
    public static final String CHANGED_FIELDS = "changedFields";

    StateChangeAuditEventBuilder() {
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        if (!this.jsonValue.isDefined(RUN_AS)) {
            this.runAs("");
        }
    }

    @Override
    protected void validate() {
        super.validate();
        this.requireField(RUN_AS);
        this.requireField(OBJECT_ID);
        this.requireField(OPERATION);
    }

    public final T runAs(String id) {
        this.jsonValue.put(RUN_AS, (Object)id);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T objectId(String objectId) {
        this.jsonValue.put(OBJECT_ID, (Object)objectId);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T operation(String operation) {
        this.jsonValue.put(OPERATION, (Object)operation);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T before(String state) {
        this.jsonValue.put(BEFORE, (Object)state);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T before(JsonValue state) {
        this.jsonValue.put(BEFORE, state.getObject());
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T after(String state) {
        this.jsonValue.put(AFTER, (Object)state);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T after(JsonValue state) {
        this.jsonValue.put(AFTER, state.getObject());
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T revision(String newRevision) {
        this.jsonValue.put(REVISION, (Object)newRevision);
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T changedFields(String ... fieldNames) {
        this.jsonValue.put(CHANGED_FIELDS, (Object)JsonValue.array((Object[])fieldNames));
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T objectIdFromCrestRequest(Request request) {
        this.objectId(request.getResourcePath());
        return (T)((StateChangeAuditEventBuilder)this.self());
    }

    public final T operationFromCrestRequest(Request request) {
        if (request instanceof ActionRequest) {
            String action = ((ActionRequest)request).getAction();
            this.operation(action);
        } else {
            String method = request.getRequestType().name();
            this.operation(method);
        }
        return (T)((StateChangeAuditEventBuilder)this.self());
    }
}

