/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.events.AuditEventBuilder;
import org.forgerock.http.header.CookieHeader;
import org.forgerock.http.protocol.Cookie;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessAuditEventBuilder<T extends AccessAuditEventBuilder<T>>
extends AuditEventBuilder<T> {
    public static final String SERVER = "server";
    public static final String CLIENT = "client";
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String REQUEST = "request";
    public static final String PROTOCOL = "protocol";
    public static final String OPERATION = "operation";
    public static final String SECURE = "secure";
    public static final String METHOD = "method";
    public static final String DETAIL = "detail";
    public static final String PATH = "path";
    public static final String QUERY_PARAMETERS = "queryParameters";
    public static final String HEADERS = "headers";
    public static final String HTTP = "http";
    public static final String STATUS = "status";
    public static final String STATUS_CODE = "statusCode";
    public static final String ELAPSED_TIME = "elapsedTime";
    public static final String ELAPSED_TIME_UNITS = "elapsedTimeUnits";
    public static final String RESPONSE = "response";
    public static final String COOKIES = "cookies";
    public static final String CREST_PROTOCOL = "CREST";
    private static final String HTTP_CONTEXT_NAME = "http";
    private static final String CLIENT_CONTEXT_NAME = "client";
    private static final Logger logger = LoggerFactory.getLogger(AccessAuditEventBuilder.class);
    private boolean performReverseDnsLookup = false;

    public static AccessAuditEventBuilder<?> accessEvent() {
        return new AccessAuditEventBuilder();
    }

    public final T withReverseDnsLookup() {
        this.performReverseDnsLookup = true;
        return (T)((AccessAuditEventBuilder)this.self());
    }

    protected boolean isReverseDnsLookupEnabled() {
        return this.performReverseDnsLookup;
    }

    public final T server(String ip, int port) {
        Object server = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)IP, (Object)ip), JsonValue.field((String)PORT, (Object)port)});
        this.jsonValue.put(SERVER, server);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T client(String ip, int port) {
        Object client = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)IP, (Object)ip), JsonValue.field((String)PORT, (Object)port)});
        this.jsonValue.put("client", client);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T client(String ip) {
        Object client = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)IP, (Object)ip)});
        this.jsonValue.put("client", client);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T request(String protocol, String operation) {
        Object request = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)PROTOCOL, (Object)protocol), JsonValue.field((String)OPERATION, (Object)operation)});
        this.jsonValue.put(REQUEST, request);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T request(String protocol, String operation, JsonValue detail) {
        Reject.ifNull((Object)detail);
        Object request = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)PROTOCOL, (Object)protocol), JsonValue.field((String)OPERATION, (Object)operation), JsonValue.field((String)DETAIL, (Object)detail.getObject())});
        this.jsonValue.put(REQUEST, request);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T httpRequest(boolean secure, String method, String path, Map<String, List<String>> queryParameters, Map<String, List<String>> headers) {
        List<String> cookiesHeader = headers.remove("Cookie");
        if (cookiesHeader == null || cookiesHeader.isEmpty()) {
            cookiesHeader = headers.remove("cookie");
        }
        LinkedList listOfCookies = new LinkedList();
        if (cookiesHeader != null && !cookiesHeader.isEmpty()) {
            listOfCookies.addAll(CookieHeader.valueOf((String)cookiesHeader.get(0)).getCookies());
        }
        LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
        for (Cookie cookie : listOfCookies) {
            cookies.put(cookie.getName(), cookie.getValue());
        }
        this.httpRequest(secure, method, path, queryParameters, headers, cookies);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T httpRequest(boolean secure, String method, String path, Map<String, List<String>> queryParameters, Map<String, List<String>> headers, Map<String, String> cookies) {
        Object httpRequest = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)SECURE, (Object)secure), JsonValue.field((String)METHOD, (Object)method), JsonValue.field((String)PATH, (Object)path), JsonValue.field((String)QUERY_PARAMETERS, queryParameters), JsonValue.field((String)HEADERS, headers), JsonValue.field((String)COOKIES, cookies)});
        this.getOrCreateHttp().put(REQUEST, httpRequest);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T httpResponse(Map<String, List<String>> headers) {
        Object httpResponse = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)HEADERS, headers)});
        this.getOrCreateHttp().put(RESPONSE, httpResponse);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    @VisibleForTesting
    JsonValue getOrCreateHttp() {
        if (this.jsonValue.get("http").isNull()) {
            this.jsonValue.put("http", JsonValue.object((Map.Entry[])new Map.Entry[0]));
        }
        return this.jsonValue.get("http");
    }

    @VisibleForTesting
    JsonValue getOrCreateHttpResponse() {
        if (this.getOrCreateHttp().get(RESPONSE).isNull()) {
            this.getOrCreateHttp().put(RESPONSE, JsonValue.object((Map.Entry[])new Map.Entry[0]));
        }
        return this.getOrCreateHttp().get(RESPONSE);
    }

    @VisibleForTesting
    JsonValue getOrCreateHttpResponseCookies() {
        JsonValue httpResponse = this.getOrCreateHttpResponse();
        JsonValue cookies = httpResponse.get(COOKIES);
        if (cookies.isNull()) {
            httpResponse.put(COOKIES, new ArrayList());
        }
        cookies = httpResponse.get(COOKIES);
        return cookies;
    }

    public final T response(ResponseStatus status, String statusCode, long elapsedTime, TimeUnit elapsedTimeUnits) {
        Object response = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)STATUS, (Object)(status == null ? null : status.toString())), JsonValue.field((String)STATUS_CODE, (Object)statusCode), JsonValue.field((String)ELAPSED_TIME, (Object)elapsedTime), JsonValue.field((String)ELAPSED_TIME_UNITS, (Object)(elapsedTimeUnits == null ? null : elapsedTimeUnits.name()))});
        this.jsonValue.put(RESPONSE, response);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T responseWithDetail(ResponseStatus status, String statusCode, long elapsedTime, TimeUnit elapsedTimeUnits, JsonValue detail) {
        Reject.ifNull((Object)detail);
        Object response = JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)STATUS, (Object)(status == null ? null : status.toString())), JsonValue.field((String)STATUS_CODE, (Object)statusCode), JsonValue.field((String)ELAPSED_TIME, (Object)elapsedTime), JsonValue.field((String)ELAPSED_TIME_UNITS, (Object)(elapsedTimeUnits == null ? null : elapsedTimeUnits.name())), JsonValue.field((String)DETAIL, (Object)detail.getObject())});
        this.jsonValue.put(RESPONSE, response);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T clientFromContext(Context context) {
        if (context.containsContext(ClientContext.class)) {
            ClientContext clientContext = (ClientContext)context.asContext(ClientContext.class);
            this.client(clientContext.getRemoteAddress(), clientContext.getRemotePort());
        }
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T serverFromContext(Context context) {
        if (context.containsContext(ClientContext.class)) {
            ClientContext clientContext = (ClientContext)context.asContext(ClientContext.class);
            this.server(clientContext.getLocalAddress(), clientContext.getLocalPort());
        }
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T httpFromContext(Context context) {
        if (context.containsContext("http")) {
            JsonValue httpContext = context.getContext("http").toJsonValue();
            JsonValue clientContext = context.getContext("client").toJsonValue();
            this.httpRequest(clientContext.get("isSecure").asBoolean(), httpContext.get(METHOD).asString(), httpContext.get(PATH).asString(), this.asModifiableCaseSensitiveMap(httpContext.get("parameters").asMapOfList(String.class)), this.asModifiableCaseInsensitiveMap(httpContext.get(HEADERS).asMapOfList(String.class)));
        }
        return (T)((AccessAuditEventBuilder)this.self());
    }

    private <E> Map<String, List<E>> asModifiableCaseSensitiveMap(Map<String, List<E>> map) {
        return new LinkedHashMap<String, List<E>>(map);
    }

    private <E> Map<String, List<E>> asModifiableCaseInsensitiveMap(Map<String, List<E>> map) {
        TreeMap<String, List<E>> caseInsensitiveMap = new TreeMap<String, List<E>>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveMap.putAll(map);
        return caseInsensitiveMap;
    }

    public final T requestFromCrestRequest(Request request) {
        String operation = request.getRequestType().name();
        if (request instanceof ActionRequest) {
            String action = ((ActionRequest)request).getAction();
            JsonValue detail = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"action", (Object)action)}));
            this.request(CREST_PROTOCOL, operation, detail);
        } else {
            this.request(CREST_PROTOCOL, operation);
        }
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T forContext(Context context) {
        this.transactionIdFromContext(context);
        this.clientFromContext(context);
        this.serverFromContext(context);
        this.httpFromContext(context);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public final T forHttpRequest(Context context, Request request) {
        this.forContext(context);
        this.requestFromCrestRequest(request);
        return (T)((AccessAuditEventBuilder)this.self());
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        FAILED;

    }
}

