/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.filter.FilterPolicy;

public class AuditServiceConfiguration {
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.service.handlerForQueries")
    private String handlerForQueries;
    @JsonPropertyDescription(value="audit.service.availableAuditEventHandlers")
    private List<String> availableAuditEventHandlers;
    @JsonPropertyDescription(value="audit.service.filter.policies")
    private Map<String, FilterPolicy> filterPolicies = new LinkedHashMap<String, FilterPolicy>();

    public AuditServiceConfiguration() {
    }

    public AuditServiceConfiguration(AuditServiceConfiguration config) {
        this.handlerForQueries = config.getHandlerForQueries();
        this.availableAuditEventHandlers = config.availableAuditEventHandlers;
    }

    public String getHandlerForQueries() {
        return this.handlerForQueries;
    }

    public void setHandlerForQueries(String name) {
        this.handlerForQueries = name;
    }

    public List<String> getAvailableAuditEventHandlers() {
        if (this.availableAuditEventHandlers == null) {
            return Collections.emptyList();
        }
        return this.availableAuditEventHandlers;
    }

    public void setAvailableAuditEventHandlers(List<String> availableAuditEventHandlers) {
        this.availableAuditEventHandlers = availableAuditEventHandlers;
    }

    public Map<String, FilterPolicy> getFilterPolicies() {
        return this.filterPolicies;
    }

    public void setFilterPolicies(Map<String, FilterPolicy> filterPolicies) {
        this.filterPolicies.putAll(filterPolicies);
    }
}

