/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.forgerock.util.encode.Base64;
import org.slf4j.Logger;

class CsvSecureUtils {
    static byte[] dataToSign(byte[] lastSignature, String lastHMAC) {
        byte[] toSign;
        if (lastSignature == null) {
            byte[] prevHMAC = Base64.decode((String)lastHMAC);
            toSign = Arrays.copyOf(prevHMAC, prevHMAC.length);
        } else {
            byte[] prevHMAC = Base64.decode((String)lastHMAC);
            toSign = CsvSecureUtils.concat(prevHMAC, lastSignature);
        }
        return toSign;
    }

    private static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    static byte[] dataToSign(Logger logger, Map<String, ?> values, String ... nameMapping) {
        StringBuilder tmp = new StringBuilder();
        for (String h : nameMapping) {
            Object value = values.get(h);
            if (value == null) continue;
            tmp.append(value.toString());
        }
        return tmp.toString().getBytes(StandardCharsets.UTF_8);
    }

    private CsvSecureUtils() {
    }
}

