/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanupHelper {
    static final Logger logger = LoggerFactory.getLogger(CleanupHelper.class);

    CleanupHelper() {
    }

    public static void commit(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException ex) {
                logger.warn("Failure during connection commit ", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                logger.warn("Failure during connection close ", (Throwable)ex);
            }
        }
    }

    public static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException sqlException) {
            logger.error("Unable to rollback changes to database", (Throwable)sqlException);
        }
    }
}

