/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Locale;
import org.forgerock.http.protocol.Form;

public final class Uris {
    private static final char URL_ESCAPE_CHAR = '%';
    private static final BitSet SAFE_URL_PCHAR_CHARS = new BitSet(128);
    private static final BitSet SAFE_URL_QUERY_CHARS = new BitSet(128);
    private static final BitSet SAFE_URL_FRAGMENT_CHARS = new BitSet(128);
    private static final BitSet SAFE_URL_USERINFO_CHARS = new BitSet(128);
    private static final String[] BYTE_TO_HEX;

    private Uris() {
    }

    public static URI create(String scheme, String rawUserInfo, String host, int port, String rawPath, String rawQuery, String rawFragment) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme).append(':');
        }
        if (host != null) {
            sb.append("//");
        }
        if (rawUserInfo != null) {
            sb.append(rawUserInfo).append('@');
        }
        if (host != null) {
            sb.append(host);
            if (port != -1) {
                sb.append(':').append(Integer.toString(port));
            }
        }
        if (rawPath != null) {
            sb.append(rawPath);
        }
        if (rawQuery != null) {
            sb.append('?').append(rawQuery);
        }
        if (rawFragment != null) {
            sb.append("#").append(rawFragment);
        }
        return new URI(sb.toString());
    }

    public static URI createNonStrict(String scheme, String rawUserInfo, String host, int port, String rawPath, String rawQuery, String rawFragment) throws URISyntaxException {
        return Uris.create(scheme, rawUserInfo, host, port, rawPath, Uris.asSafeQuery(rawQuery), rawFragment);
    }

    private static String asSafeQuery(String rawQuery) throws URISyntaxException {
        if (rawQuery == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(rawQuery.length() + 8);
        for (String param : rawQuery.split("&")) {
            String[] nv = param.split("=", 2);
            if (nv.length != 2) continue;
            try {
                if (builder.length() > 0) {
                    builder.append('&');
                }
                String name = Uris.urlDecodeQueryParameterNameOrValue(nv[0]);
                String value = Uris.urlDecodeQueryParameterNameOrValue(nv[1]);
                builder.append(Uris.urlEncodeQueryParameterNameOrValue(name)).append('=').append(Uris.urlEncodeQueryParameterNameOrValue(value));
            }
            catch (Exception e) {
                throw new URISyntaxException(rawQuery, "The URL query string could not be decoded");
            }
        }
        return builder.toString();
    }

    public static URI rebase(URI uri, URI base) {
        if (base == null) {
            return uri;
        }
        String scheme = base.getScheme();
        String host = base.getHost();
        int port = base.getPort();
        if (scheme == null || host == null) {
            return uri;
        }
        try {
            return Uris.create(scheme, uri.getRawUserInfo(), host, port, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI withQuery(URI uri, Form query) {
        try {
            return Uris.create(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), query.toQueryString(), uri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI withoutQueryAndFragment(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String formDecodeParameterNameOrValue(String nameOrValue) {
        try {
            return nameOrValue != null ? URLDecoder.decode(nameOrValue, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            return nameOrValue;
        }
    }

    public static String formEncodeParameterNameOrValue(String nameOrValue) {
        try {
            return nameOrValue != null ? URLEncoder.encode(nameOrValue, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            return nameOrValue;
        }
    }

    public static String urlDecodePathElement(String pathElement) {
        return Uris.urlDecode(pathElement, false);
    }

    public static String urlEncodePathElement(String pathElement) {
        return Uris.urlEncode(pathElement, SAFE_URL_PCHAR_CHARS);
    }

    public static String urlDecodeQueryParameterNameOrValue(String nameOrValue) {
        return Uris.urlDecode(nameOrValue, true);
    }

    public static String urlEncodeQueryParameterNameOrValue(String nameOrValue) {
        return Uris.urlEncode(nameOrValue, SAFE_URL_QUERY_CHARS);
    }

    public static String urlDecodeFragment(String fragment) {
        return Uris.urlDecode(fragment, false);
    }

    public static String urlEncodeFragment(String fragment) {
        return Uris.urlEncode(fragment, SAFE_URL_FRAGMENT_CHARS);
    }

    public static String urlDecodeUserInfo(String userInfo) {
        return Uris.urlDecode(userInfo, false);
    }

    public static String urlEncodeUserInfo(String userInfo) {
        return Uris.urlEncode(userInfo, SAFE_URL_USERINFO_CHARS);
    }

    private static String urlDecode(String s, boolean decodePlusToSpace) {
        if (s == null) {
            return null;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (!Uris.isUrlEscapeChar(c) && (!decodePlusToSpace || c != '+')) continue;
            return Uris.urlDecode0(s, decodePlusToSpace);
        }
        return s;
    }

    private static String urlDecode0(String s, boolean decodePlusToSpace) {
        StringBuilder builder = new StringBuilder(s.length());
        int size = s.length();
        byte[] buffer = new byte[size / 3];
        int i = 0;
        while (i < size) {
            char c = s.charAt(i);
            if (decodePlusToSpace && c == '+') {
                builder.append(' ');
                ++i;
                continue;
            }
            if (!Uris.isUrlEscapeChar(c)) {
                builder.append(c);
                ++i;
                continue;
            }
            int bufferPos = 0;
            while (i < size && Uris.isUrlEscapeChar(s.charAt(i))) {
                if (i + 2 >= size) {
                    throw new IllegalArgumentException("Path contains an incomplete percent encoding");
                }
                String hexPair = s.substring(i + 1, i + 3);
                try {
                    int octet = Integer.parseInt(hexPair, 16);
                    if (octet < 0) {
                        throw new IllegalArgumentException("Path contains an invalid percent encoding '" + hexPair + "'");
                    }
                    buffer[bufferPos++] = (byte)octet;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Path contains an invalid percent encoding '" + hexPair + "'");
                }
                i += 3;
            }
            builder.append(new String(buffer, 0, bufferPos, StandardCharsets.UTF_8));
        }
        return builder.toString();
    }

    private static String urlEncode(String s, BitSet safeChars) {
        if (s == null) {
            return null;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (safeChars.get(c)) continue;
            return Uris.urlEncode0(s, safeChars);
        }
        return s;
    }

    private static String urlEncode0(String s, BitSet safeChars) {
        byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
        int size = utf8.length;
        StringBuilder builder = new StringBuilder(size + 16);
        for (byte b : utf8) {
            int octet = b & 0xFF;
            if (safeChars.get(octet)) {
                builder.append((char)octet);
                continue;
            }
            builder.append('%');
            builder.append(BYTE_TO_HEX[octet]);
        }
        return builder.toString();
    }

    private static boolean isUrlEscapeChar(char c) {
        return c == '%';
    }

    static {
        for (char c : "-._~!$&'()*+,;=:@".toCharArray()) {
            SAFE_URL_PCHAR_CHARS.set(c);
        }
        SAFE_URL_PCHAR_CHARS.set(48, 58);
        SAFE_URL_PCHAR_CHARS.set(97, 123);
        SAFE_URL_PCHAR_CHARS.set(65, 91);
        SAFE_URL_QUERY_CHARS.or(SAFE_URL_PCHAR_CHARS);
        SAFE_URL_QUERY_CHARS.set(47);
        SAFE_URL_QUERY_CHARS.set(63);
        SAFE_URL_QUERY_CHARS.clear(38);
        SAFE_URL_QUERY_CHARS.clear(61);
        SAFE_URL_QUERY_CHARS.clear(43);
        SAFE_URL_FRAGMENT_CHARS.or(SAFE_URL_PCHAR_CHARS);
        SAFE_URL_FRAGMENT_CHARS.set(47);
        SAFE_URL_FRAGMENT_CHARS.set(63);
        SAFE_URL_USERINFO_CHARS.or(SAFE_URL_PCHAR_CHARS);
        SAFE_URL_USERINFO_CHARS.clear(64);
        BYTE_TO_HEX = new String[256];
        for (int i = 0; i < BYTE_TO_HEX.length; ++i) {
            Uris.BYTE_TO_HEX[i] = String.format(Locale.ROOT, "%02X", i);
        }
    }
}

