/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.ResponseException;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.AbstractRouter;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.util.Pair;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class Router
extends AbstractRouter<Router, Request, Handler>
implements Handler {
    public Router() {
    }

    public Router(Router router) {
        super(router);
    }

    @Override
    protected Router getThis() {
        return this;
    }

    @Override
    public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
        try {
            Pair bestMatch = this.getBestRoute(context, request);
            if (bestMatch != null) {
                return ((Handler)bestMatch.getSecond()).handle((Context)bestMatch.getFirst(), request);
            }
            return Promises.newResultPromise((Object)new Response(Status.NOT_FOUND));
        }
        catch (IncomparableRouteMatchException e) {
            HttpApplication.LOGGER.trace(String.format("Route for '%s' not found", RouteMatchers.getRemainingRequestUri(context, request).toString()));
            return Promises.newResultPromise((Object)new ResponseException(e.getMessage()).getResponse());
        }
    }
}

