/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.util.Objects;
import org.forgerock.http.routing.ApiVersionRouterContext;
import org.forgerock.http.routing.DefaultVersionBehaviour;
import org.forgerock.http.routing.Version;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;

class ResourceApiVersionRouteMatcher
extends RouteMatcher<Version> {
    private final Version routeVersion;

    ResourceApiVersionRouteMatcher(Version routeVersion) {
        this.routeVersion = routeVersion;
    }

    @Override
    public RouteMatch evaluate(Context context, Version requestedVersion) {
        DefaultVersionBehaviour behaviour = this.getRoutingBehaviour(context);
        if (requestedVersion == null && DefaultVersionBehaviour.NONE.equals((Object)behaviour)) {
            return null;
        }
        if (requestedVersion == null) {
            return new ApiVersionRouteMatch(this.routeVersion, behaviour);
        }
        if (this.routeVersion.isCompatibleWith(requestedVersion)) {
            return new ApiVersionRouteMatch(this.routeVersion, DefaultVersionBehaviour.NONE);
        }
        return null;
    }

    private DefaultVersionBehaviour getRoutingBehaviour(Context context) {
        DefaultVersionBehaviour behaviour = null;
        if (context.containsContext(ApiVersionRouterContext.class)) {
            behaviour = context.asContext(ApiVersionRouterContext.class).getDefaultVersionBehaviour();
        }
        if (behaviour == null) {
            behaviour = DefaultVersionBehaviour.LATEST;
        }
        return behaviour;
    }

    @Override
    public String toString() {
        return this.routeVersion.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceApiVersionRouteMatcher that = (ResourceApiVersionRouteMatcher)o;
        return Objects.equals(this.routeVersion, that.routeVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.routeVersion);
    }

    private static final class ApiVersionRouteMatch
    implements RouteMatch {
        private final Version resourceVersion;
        private final DefaultVersionBehaviour behaviour;

        private ApiVersionRouteMatch(Version resourceVersion, DefaultVersionBehaviour behaviour) {
            this.resourceVersion = resourceVersion;
            this.behaviour = behaviour;
        }

        @Override
        public boolean isBetterMatchThan(RouteMatch routeMatch) throws IncomparableRouteMatchException {
            if (routeMatch == null) {
                return true;
            }
            if (!(routeMatch instanceof ApiVersionRouteMatch)) {
                throw new IncomparableRouteMatchException(this, routeMatch);
            }
            ApiVersionRouteMatch result = (ApiVersionRouteMatch)routeMatch;
            switch (this.behaviour) {
                case OLDEST: {
                    return this.resourceVersion.compareTo(result.resourceVersion) <= 0;
                }
            }
            return this.resourceVersion.compareTo(result.resourceVersion) >= 0;
        }

        @Override
        public Context decorateContext(Context context) {
            ApiVersionRouterContext apiVersionRouterContext;
            if (!context.containsContext(ApiVersionRouterContext.class)) {
                apiVersionRouterContext = new ApiVersionRouterContext(context);
                context = apiVersionRouterContext;
            } else {
                apiVersionRouterContext = context.asContext(ApiVersionRouterContext.class);
            }
            apiVersionRouterContext.setResourceVersion(this.resourceVersion);
            return context;
        }

        public String toString() {
            return "version=" + this.resourceVersion + ", behaviour=" + (Object)((Object)this.behaviour);
        }
    }
}

