/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import java.util.Arrays;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.OverflowException;

final class MemoryBuffer
implements Buffer {
    byte[] data;
    private final int limit;
    private int length = 0;

    MemoryBuffer(int initial, int limit) {
        this.data = new byte[initial];
        this.limit = limit;
    }

    @Override
    public int read(int pos, byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int n = 0;
        if (pos < this.length) {
            n = Math.min(len, this.length - pos);
            System.arraycopy(this.data, pos, b, off, n);
        }
        return n;
    }

    @Override
    public void append(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        int end = this.length + len;
        if (end > this.limit) {
            throw new OverflowException();
        }
        if (this.data.length < end) {
            this.data = Arrays.copyOf(this.data, Math.max(end, Math.min(this.limit, this.data.length << 1)));
        }
        System.arraycopy(b, off, this.data, this.length, len);
        this.length += len;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void close() {
        this.data = null;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void notClosed() throws IOException {
        if (this.data == null) {
            throw new IOException("buffer is closed");
        }
    }
}

