/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.opendj.ldap.AttributeDescription;

public enum WritabilityPolicy {
    READ_ONLY(false),
    READ_ONLY_DISCARD_WRITES(true),
    CREATE_ONLY(false),
    CREATE_ONLY_DISCARD_WRITES(true),
    READ_WRITE(false);

    private final boolean discardWrites;

    private WritabilityPolicy(boolean discardWrites) {
        this.discardWrites = discardWrites;
    }

    boolean canCreate(AttributeDescription attribute) {
        return this != READ_ONLY && !attribute.getAttributeType().isNoUserModification();
    }

    boolean canWrite(AttributeDescription attribute) {
        return this == READ_WRITE && !attribute.getAttributeType().isNoUserModification();
    }

    boolean discardWrites() {
        return this.discardWrites;
    }
}

