/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.rest2ldap.AbstractLDAPAttributeMapper;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public final class ReferenceAttributeMapper
extends AbstractLDAPAttributeMapper<ReferenceAttributeMapper> {
    private static final int SEARCH_MAX_CANDIDATES = 1000;
    private final DN baseDN;
    private Filter filter;
    private final AttributeMapper mapper;
    private final AttributeDescription primaryKey;
    private SearchScope scope = SearchScope.WHOLE_SUBTREE;

    ReferenceAttributeMapper(AttributeDescription ldapAttributeName, DN baseDN, AttributeDescription primaryKey, AttributeMapper mapper) {
        super(ldapAttributeName);
        this.baseDN = baseDN;
        this.primaryKey = primaryKey;
        this.mapper = mapper;
    }

    public ReferenceAttributeMapper searchFilter(Filter filter) {
        this.filter = Utils.ensureNotNull(filter);
        return this;
    }

    public ReferenceAttributeMapper searchFilter(String filter) {
        return this.searchFilter(Filter.valueOf((String)filter));
    }

    public ReferenceAttributeMapper searchScope(SearchScope scope) {
        this.scope = Utils.ensureNotNull(scope);
        return this;
    }

    public String toString() {
        return "reference(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLDAPFilter(final RequestState requestState, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        return this.mapper.getLDAPFilter(requestState, path, subPath, type, operator, valueAssertion).thenAsync((AsyncFunction)new AsyncFunction<Filter, Filter, ResourceException>(){

            public Promise<Filter, ResourceException> apply(Filter result) {
                final SearchRequest request = ReferenceAttributeMapper.this.createSearchRequest(result);
                final LinkedList subFilters = new LinkedList();
                return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, Filter, ResourceException>(){

                    public Promise<Filter, ResourceException> apply(Connection connection) throws ResourceException {
                        return connection.searchAsync(request, new SearchResultHandler(){

                            public boolean handleEntry(SearchResultEntry entry) {
                                if (subFilters.size() < 1000) {
                                    subFilters.add(Filter.equality((String)ReferenceAttributeMapper.this.ldapAttributeName.toString(), (Object)entry.getName()));
                                    return true;
                                }
                                return false;
                            }

                            public boolean handleReference(SearchResultReference reference) {
                                return true;
                            }
                        }).then((Function)new Function<Result, Filter, ResourceException>(){

                            public Filter apply(Result result) throws ResourceException {
                                if (subFilters.size() >= 1000) {
                                    throw Rest2LDAP.asResourceException(LdapException.newLdapException((ResultCode)ResultCode.ADMIN_LIMIT_EXCEEDED));
                                }
                                if (subFilters.size() == 1) {
                                    return (Filter)subFilters.get(0);
                                }
                                return Filter.or((Collection)subFilters);
                            }
                        }, (Function)new Function<LdapException, Filter, ResourceException>(){

                            public Filter apply(LdapException exception) throws ResourceException {
                                throw Rest2LDAP.asResourceException(exception);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    Promise<Attribute, ResourceException> getNewLDAPAttributes(final RequestState requestState, final JsonPointer path, List<Object> newValues) {
        LinkedAttribute newLDAPAttribute = new LinkedAttribute(this.ldapAttributeName);
        AtomicInteger pendingSearches = new AtomicInteger(newValues.size());
        AtomicReference exception = new AtomicReference();
        final PromiseImpl promise = PromiseImpl.create();
        for (Object value : newValues) {
            this.mapper.create(requestState, path, new JsonValue(value)).thenOnResult((ResultHandler)new ResultHandler<List<Attribute>>((Attribute)newLDAPAttribute, exception, pendingSearches){
                final /* synthetic */ Attribute val$newLDAPAttribute;
                final /* synthetic */ AtomicReference val$exception;
                final /* synthetic */ AtomicInteger val$pendingSearches;
                {
                    this.val$newLDAPAttribute = attribute;
                    this.val$exception = atomicReference;
                    this.val$pendingSearches = atomicInteger;
                }

                public void handleResult(List<Attribute> result) {
                    Attribute primaryKeyAttribute = null;
                    for (Attribute attribute : result) {
                        if (!attribute.getAttributeDescription().equals((Object)ReferenceAttributeMapper.this.primaryKey)) continue;
                        primaryKeyAttribute = attribute;
                        break;
                    }
                    if (primaryKeyAttribute == null || primaryKeyAttribute.isEmpty()) {
                        promise.handleException((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because the reference field '%s' contains a value which does not contain a primary key", path)));
                    }
                    if (primaryKeyAttribute.size() > 1) {
                        promise.handleException((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because the reference field '%s' contains a value which contains multiple primary keys", path)));
                    }
                    final ByteString primaryKeyValue = primaryKeyAttribute.firstValue();
                    Filter filter = Filter.equality((String)ReferenceAttributeMapper.this.primaryKey.toString(), (Object)primaryKeyValue);
                    final SearchRequest search = ReferenceAttributeMapper.this.createSearchRequest(filter);
                    requestState.getConnection().thenOnResult((ResultHandler)new ResultHandler<Connection>(){

                        public void handleResult(Connection connection) {
                            connection.searchSingleEntryAsync(search).thenOnResult((ResultHandler)new ResultHandler<SearchResultEntry>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void handleResult(SearchResultEntry result) {
                                    Attribute attribute = val$newLDAPAttribute;
                                    synchronized (attribute) {
                                        val$newLDAPAttribute.add(new Object[]{result.getName()});
                                    }
                                    this.completeIfNecessary();
                                }
                            }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                                public void handleException(LdapException error) {
                                    ResourceException re;
                                    try {
                                        throw error;
                                    }
                                    catch (EntryNotFoundException e) {
                                        re = new BadRequestException(Utils.i18n("The request cannot be processed because the resource '%s' referenced in field '%s' does not exist", primaryKeyValue.toString(), path));
                                    }
                                    catch (MultipleEntriesFoundException e) {
                                        re = new BadRequestException(Utils.i18n("The request cannot be processed because the resource '%s' referenced in field '%s' is ambiguous", primaryKeyValue.toString(), path));
                                    }
                                    catch (LdapException e) {
                                        re = Rest2LDAP.asResourceException(e);
                                    }
                                    val$exception.compareAndSet(null, re);
                                    this.completeIfNecessary();
                                }
                            });
                        }
                    });
                }

                private void completeIfNecessary() {
                    if (this.val$pendingSearches.decrementAndGet() == 0) {
                        if (this.val$exception.get() != null) {
                            promise.handleException((Exception)this.val$exception.get());
                        } else {
                            promise.handleResult((Object)this.val$newLDAPAttribute);
                        }
                    }
                }
            });
        }
        return promise;
    }

    @Override
    ReferenceAttributeMapper getThis() {
        return this;
    }

    @Override
    Promise<JsonValue, ResourceException> read(RequestState c, JsonPointer path, Entry e) {
        Attribute attribute = e.getAttribute(this.ldapAttributeName);
        if (attribute == null || attribute.isEmpty()) {
            return Promises.newResultPromise(null);
        }
        if (this.attributeIsSingleValued()) {
            try {
                DN dn = attribute.parse().usingSchema(c.getConfig().schema()).asDN();
                return this.readEntry(c, path, dn);
            }
            catch (Exception ex) {
                return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
            }
        }
        try {
            Set dns = attribute.parse().usingSchema(c.getConfig().schema()).asSetOfDN();
            ArrayList<Promise<JsonValue, ResourceException>> promises = new ArrayList<Promise<JsonValue, ResourceException>>(dns.size());
            for (DN dn : dns) {
                promises.add(this.readEntry(c, path, dn));
            }
            return Promises.when(promises).then((Function)new Function<List<JsonValue>, JsonValue, ResourceException>(){

                public JsonValue apply(List<JsonValue> value) {
                    if (value.isEmpty()) {
                        return null;
                    }
                    ArrayList<Object> result = new ArrayList<Object>(value.size());
                    for (JsonValue e : value) {
                        if (e == null) continue;
                        result.add(e.getObject());
                    }
                    return result.isEmpty() ? null : new JsonValue(result);
                }
            });
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
        }
    }

    private SearchRequest createSearchRequest(Filter result) {
        Filter searchFilter = this.filter != null ? Filter.and((Filter[])new Filter[]{this.filter, result}) : result;
        return Requests.newSearchRequest((DN)this.baseDN, (SearchScope)this.scope, (Filter)searchFilter, (String[])new String[]{"1.1"});
    }

    private Promise<JsonValue, ResourceException> readEntry(final RequestState requestState, final JsonPointer path, final DN dn) {
        final LinkedHashSet<String> requestedLDAPAttributes = new LinkedHashSet<String>();
        this.mapper.getLDAPAttributes(requestState, path, new JsonPointer(), requestedLDAPAttributes);
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, JsonValue, ResourceException>(){

            public Promise<JsonValue, ResourceException> apply(Connection connection) throws ResourceException {
                Filter searchFilter = ReferenceAttributeMapper.this.filter != null ? ReferenceAttributeMapper.this.filter : Filter.alwaysTrue();
                String[] attributes = requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
                SearchRequest request = Requests.newSearchRequest((DN)dn, (SearchScope)SearchScope.BASE_OBJECT, (Filter)searchFilter, (String[])attributes);
                return connection.searchSingleEntryAsync(request).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, JsonValue, ResourceException>(){

                    public Promise<JsonValue, ResourceException> apply(SearchResultEntry result) {
                        return ReferenceAttributeMapper.this.mapper.read(requestState, path, (Entry)result);
                    }
                }, (AsyncFunction)new AsyncFunction<LdapException, JsonValue, ResourceException>(){

                    public Promise<JsonValue, ResourceException> apply(LdapException error) {
                        if (error instanceof EntryNotFoundException) {
                            return Promises.newResultPromise(null);
                        }
                        return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException((Throwable)error)));
                    }
                });
            }
        });
    }
}

