/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.NameStrategy;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

final class LDAPCollectionResourceProvider
implements CollectionResourceProvider {
    private static final ResourceException SUCCESS = new UncategorizedException(0, null, null);
    private static final DecodeOptions DECODE_OPTIONS = new DecodeOptions();
    private final List<Attribute> additionalLDAPAttributes;
    private final AttributeMapper attributeMapper;
    private final DN baseDN;
    private final Config config;
    private final AttributeDescription etagAttribute;
    private final NameStrategy nameStrategy;

    LDAPCollectionResourceProvider(DN baseDN, AttributeMapper mapper, NameStrategy nameStrategy, AttributeDescription etagAttribute, Config config, List<Attribute> additionalLDAPAttributes) {
        this.baseDN = baseDN;
        this.attributeMapper = mapper;
        this.config = config;
        this.nameStrategy = nameStrategy;
        this.etagAttribute = etagAttribute;
        this.additionalLDAPAttributes = additionalLDAPAttributes;
    }

    public Promise<ActionResponse, ResourceException> actionCollection(Context context, ActionRequest request) {
        return Promises.newExceptionPromise((Exception)new NotSupportedException("Not yet implemented"));
    }

    public Promise<ActionResponse, ResourceException> actionInstance(Context context, String resourceId, ActionRequest request) {
        String actionId = request.getAction();
        if (actionId.equals("passwordModify")) {
            return this.passwordModify(context, resourceId, request);
        }
        return Promises.newExceptionPromise((Exception)new NotSupportedException("The action '" + actionId + "' is not supported"));
    }

    private Promise<ActionResponse, ResourceException> passwordModify(Context context, final String resourceId, ActionRequest request) {
        String newPassword;
        String oldPassword;
        if (!context.containsContext(ClientContext.class) || !((ClientContext)context.asContext(ClientContext.class)).isSecure()) {
            return Promises.newExceptionPromise((Exception)((Object)ResourceException.newResourceException((int)403, (String)"Password modify requires a secure connection.")));
        }
        if (!context.containsContext(SecurityContext.class) || ((SecurityContext)context.asContext(SecurityContext.class)).getAuthenticationId() == null) {
            return Promises.newExceptionPromise((Exception)((Object)ResourceException.newResourceException((int)403, (String)"Password modify requires user to be authenticated.")));
        }
        JsonValue jsonContent = request.getContent();
        try {
            oldPassword = jsonContent.get("oldPassword").asString();
            newPassword = jsonContent.get("newPassword").asString();
        }
        catch (JsonValueException e) {
            return Promises.newExceptionPromise((Exception)((Object)ResourceException.newResourceException((int)400, (String)e.getLocalizedMessage(), (Throwable)e)));
        }
        final RequestState requestState = this.wrap(context);
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, ActionResponse, ResourceException>(){

            public Promise<ActionResponse, ResourceException> apply(final Connection connection) throws ResourceException {
                List attrs = Collections.emptyList();
                return connection.searchSingleEntryAsync(LDAPCollectionResourceProvider.this.searchRequest(requestState, resourceId, attrs)).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, ActionResponse, ResourceException>(){

                    public Promise<ActionResponse, ResourceException> apply(SearchResultEntry entry) {
                        PasswordModifyExtendedRequest pwdModifyRequest = Requests.newPasswordModifyExtendedRequest();
                        pwdModifyRequest.setUserIdentity((Object)("dn: " + entry.getName()));
                        pwdModifyRequest.setOldPassword(LDAPCollectionResourceProvider.this.asBytes(oldPassword));
                        pwdModifyRequest.setNewPassword(LDAPCollectionResourceProvider.this.asBytes(newPassword));
                        return connection.extendedRequestAsync((ExtendedRequest)pwdModifyRequest).thenAsync((AsyncFunction)new AsyncFunction<PasswordModifyExtendedResult, ActionResponse, ResourceException>(){

                            public Promise<ActionResponse, ResourceException> apply(PasswordModifyExtendedResult value) throws ResourceException {
                                JsonValue result = new JsonValue(new LinkedHashMap());
                                byte[] generatedPwd = value.getGeneratedPassword();
                                if (generatedPwd != null) {
                                    result = result.put("generatedPassword", (Object)ByteString.valueOfBytes((byte[])generatedPwd).toString());
                                }
                                return Responses.newActionResponse((JsonValue)result).asPromise();
                            }
                        }, this.ldapExceptionToResourceException());
                    }
                }, this.ldapExceptionToResourceException());
            }

            private AsyncFunction<LdapException, ActionResponse, ResourceException> ldapExceptionToResourceException() {
                return LDAPCollectionResourceProvider.this.ldapToResourceException();
            }
        }).thenFinally(this.close(requestState));
    }

    private byte[] asBytes(String s) {
        return s != null ? s.getBytes(StandardCharsets.UTF_8) : null;
    }

    public Promise<ResourceResponse, ResourceException> createInstance(Context context, final CreateRequest request) {
        final RequestState requestState = this.wrap(context);
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(final Connection connection) throws ResourceException {
                return LDAPCollectionResourceProvider.this.attributeMapper.create(requestState, new JsonPointer(), request.getContent()).thenAsync((AsyncFunction)new AsyncFunction<List<Attribute>, ResourceResponse, ResourceException>(){

                    public Promise<ResourceResponse, ResourceException> apply(List<Attribute> attributes) {
                        AddRequest addRequest = Requests.newAddRequest((DN)DN.rootDN());
                        for (Attribute attribute : LDAPCollectionResourceProvider.this.additionalLDAPAttributes) {
                            addRequest.addAttribute(attribute);
                        }
                        for (Attribute attribute : attributes) {
                            addRequest.addAttribute(attribute);
                        }
                        try {
                            LDAPCollectionResourceProvider.this.nameStrategy.setResourceId(requestState, LDAPCollectionResourceProvider.this.getBaseDN(), request.getNewResourceId(), (Entry)addRequest);
                        }
                        catch (ResourceException e) {
                            return Promises.newExceptionPromise((Exception)((Object)e));
                        }
                        if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                            addRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])LDAPCollectionResourceProvider.this.getLDAPAttributes(requestState, request.getFields())));
                        }
                        return connection.applyChangeAsync((ChangeRecord)addRequest).thenAsync(LDAPCollectionResourceProvider.this.postUpdateResultAsyncFunction(requestState), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
                    }
                });
            }
        }).thenFinally(this.close(requestState));
    }

    public Promise<ResourceResponse, ResourceException> deleteInstance(Context context, String resourceId, final org.forgerock.json.resource.DeleteRequest request) {
        final RequestState requestState = this.wrap(context);
        final AtomicReference<Connection> connectionHolder = new AtomicReference<Connection>();
        return requestState.getConnection().thenOnResult(this.saveConnection(connectionHolder)).thenAsync(this.doUpdateFunction(requestState, resourceId, request.getRevision())).thenAsync((AsyncFunction)new AsyncFunction<DN, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(DN dn) throws ResourceException {
                try {
                    DeleteRequest deleteRequest = Requests.newDeleteRequest((DN)dn);
                    if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                        String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(requestState, request.getFields());
                        deleteRequest.addControl((Control)PreReadRequestControl.newControl((boolean)false, (String[])attributes));
                    }
                    if (LDAPCollectionResourceProvider.this.config.useSubtreeDelete()) {
                        deleteRequest.addControl((Control)SubtreeDeleteRequestControl.newControl((boolean)true));
                    }
                    LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)deleteRequest, request.getRevision());
                    return ((Connection)connectionHolder.get()).applyChangeAsync((ChangeRecord)deleteRequest).thenAsync(LDAPCollectionResourceProvider.this.postUpdateResultAsyncFunction(requestState), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
                }
                catch (Exception e) {
                    return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
                }
            }
        }).thenFinally(this.close(requestState));
    }

    public Promise<ResourceResponse, ResourceException> patchInstance(Context context, String resourceId, final PatchRequest request) {
        final RequestState requestState = this.wrap(context);
        if (request.getPatchOperations().isEmpty()) {
            return this.emptyPatchInstance(requestState, resourceId, request);
        }
        final AtomicReference<Connection> connectionHolder = new AtomicReference<Connection>();
        return requestState.getConnection().thenOnResult(this.saveConnection(connectionHolder)).thenAsync(this.doUpdateFunction(requestState, resourceId, request.getRevision())).thenAsync((AsyncFunction)new AsyncFunction<DN, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(final DN dn) throws ResourceException {
                ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>(request.getPatchOperations().size());
                for (PatchOperation operation : request.getPatchOperations()) {
                    promises.add(LDAPCollectionResourceProvider.this.attributeMapper.patch(requestState, new JsonPointer(), operation));
                }
                return Promises.when(promises).thenAsync((AsyncFunction)new AsyncFunction<List<List<Modification>>, ResourceResponse, ResourceException>(){

                    public Promise<ResourceResponse, ResourceException> apply(List<List<Modification>> result) {
                        try {
                            ModifyRequest modifyRequest = Requests.newModifyRequest((DN)dn);
                            for (List<Modification> modifications : result) {
                                if (modifications == null) continue;
                                modifyRequest.getModifications().addAll(modifications);
                            }
                            List<String> attributes = Arrays.asList(LDAPCollectionResourceProvider.this.getLDAPAttributes(requestState, request.getFields()));
                            if (modifyRequest.getModifications().isEmpty()) {
                                return ((Connection)connectionHolder.get()).readEntryAsync(dn, attributes).thenAsync(LDAPCollectionResourceProvider.this.postEmptyPatchAsyncFunction(requestState, request), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
                            }
                            if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, attributes));
                            }
                            if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                            }
                            LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                            return ((Connection)connectionHolder.get()).applyChangeAsync((ChangeRecord)modifyRequest).thenAsync(LDAPCollectionResourceProvider.this.postUpdateResultAsyncFunction(requestState), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
                        }
                        catch (Exception e) {
                            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
                        }
                    }
                });
            }
        }).thenFinally(this.close(requestState));
    }

    private Promise<ResourceResponse, ResourceException> emptyPatchInstance(final RequestState requestState, final String resourceId, final PatchRequest request) {
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(Connection connection) throws ResourceException {
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.searchRequest(requestState, resourceId, request.getFields());
                return connection.searchSingleEntryAsync(searchRequest).thenAsync(LDAPCollectionResourceProvider.this.postEmptyPatchAsyncFunction(requestState, request), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
            }
        });
    }

    private AsyncFunction<SearchResultEntry, ResourceResponse, ResourceException> postEmptyPatchAsyncFunction(final RequestState requestState, final PatchRequest request) {
        return new AsyncFunction<SearchResultEntry, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                try {
                    LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, request.getRevision());
                    return LDAPCollectionResourceProvider.this.adaptEntry(requestState, (Entry)entry);
                }
                catch (Exception e) {
                    return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
                }
            }
        };
    }

    public Promise<QueryResponse, ResourceException> queryCollection(Context context, final QueryRequest request, final QueryResourceHandler resourceHandler) {
        final RequestState requestState = this.wrap(context);
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, QueryResponse, ResourceException>(){

            public Promise<QueryResponse, ResourceException> apply(Connection connection) throws ResourceException {
                return LDAPCollectionResourceProvider.this.getLDAPFilter(requestState, (QueryFilter<JsonPointer>)request.getQueryFilter()).thenAsync(LDAPCollectionResourceProvider.this.runQuery(request, resourceHandler, requestState, connection));
            }
        }).thenFinally(this.close(requestState));
    }

    private Promise<Filter, ResourceException> getLDAPFilter(final RequestState requestState, QueryFilter<JsonPointer> queryFilter) {
        QueryFilterVisitor<Promise<Filter, ResourceException>, Void, JsonPointer> visitor = new QueryFilterVisitor<Promise<Filter, ResourceException>, Void, JsonPointer>(){

            public Promise<Filter, ResourceException> visitAndFilter(Void unused, List<QueryFilter<JsonPointer>> subFilters) {
                ArrayList<Object> promises = new ArrayList<Object>(subFilters.size());
                for (QueryFilter<JsonPointer> subFilter : subFilters) {
                    promises.add(subFilter.accept((QueryFilterVisitor)this, (Object)unused));
                }
                return Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                return Filter.alwaysFalse();
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            i.remove();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysTrue();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.and(value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitBooleanLiteralFilter(Void unused, boolean value) {
                return Promises.newResultPromise((Object)Utils.toFilter(value));
            }

            public Promise<Filter, ResourceException> visitContainsFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.CONTAINS, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitEqualsFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitExtendedMatchFilter(Void unused, JsonPointer field, String operator, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.EXTENDED, operator, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitGreaterThanFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.GREATER_THAN, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitGreaterThanOrEqualToFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.GREATER_THAN_OR_EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitLessThanFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.LESS_THAN, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitLessThanOrEqualToFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.LESS_THAN_OR_EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitNotFilter(Void unused, QueryFilter<JsonPointer> subFilter) {
                return ((Promise)subFilter.accept((QueryFilterVisitor)this, (Object)unused)).then((Function)new Function<Filter, Filter, ResourceException>(){

                    public Filter apply(Filter value) {
                        if (value == null || value == Filter.alwaysFalse()) {
                            return Filter.alwaysTrue();
                        }
                        if (value == Filter.alwaysTrue()) {
                            return Filter.alwaysFalse();
                        }
                        return Filter.not((Filter)value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitOrFilter(Void unused, List<QueryFilter<JsonPointer>> subFilters) {
                ArrayList<Object> promises = new ArrayList<Object>(subFilters.size());
                for (QueryFilter<JsonPointer> subFilter : subFilters) {
                    promises.add(subFilter.accept((QueryFilterVisitor)this, (Object)unused));
                }
                return Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                i.remove();
                                continue;
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            return Filter.alwaysTrue();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysFalse();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.or(value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitPresentFilter(Void unused, JsonPointer field) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.PRESENT, null, null);
            }

            public Promise<Filter, ResourceException> visitStartsWithFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return LDAPCollectionResourceProvider.this.attributeMapper.getLDAPFilter(requestState, new JsonPointer(), field, FilterType.STARTS_WITH, null, valueAssertion);
            }
        };
        return (Promise)queryFilter.accept((QueryFilterVisitor)visitor, null);
    }

    private AsyncFunction<Filter, QueryResponse, ResourceException> runQuery(final QueryRequest request, final QueryResourceHandler resourceHandler, final RequestState requestState, final Connection connection) {
        return new AsyncFunction<Filter, QueryResponse, ResourceException>(){
            private final Object sequenceLock = new Object();
            private String cookie;
            private ResourceException pendingResult;
            private int pendingResourceCount;
            private boolean resultSent;
            private int totalResourceCount;

            public Promise<QueryResponse, ResourceException> apply(Filter ldapFilter) {
                int pageResultStartIndex;
                if (ldapFilter == null || ldapFilter == Filter.alwaysFalse()) {
                    return Promises.newResultPromise((Object)Responses.newQueryResponse());
                }
                final PromiseImpl promise = PromiseImpl.create();
                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(requestState, request.getFields());
                Filter searchFilter = ldapFilter == Filter.alwaysTrue() ? Filter.objectClassPresent() : ldapFilter;
                SearchRequest searchRequest = Requests.newSearchRequest((DN)LDAPCollectionResourceProvider.this.getBaseDN(), (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)searchFilter, (String[])attributes);
                int pageSize = request.getPageSize();
                if (request.getPageSize() > 0) {
                    int pageResultEndIndex;
                    if (request.getPagedResultsOffset() > 0) {
                        pageResultStartIndex = request.getPagedResultsOffset() * pageSize;
                        pageResultEndIndex = pageResultStartIndex + pageSize;
                    } else {
                        pageResultStartIndex = 0;
                        pageResultEndIndex = pageSize;
                    }
                    ByteString cookie = request.getPagedResultsCookie() != null ? ByteString.valueOfBase64((String)request.getPagedResultsCookie()) : ByteString.empty();
                    SimplePagedResultsControl control = SimplePagedResultsControl.newControl((boolean)true, (int)pageResultEndIndex, (ByteString)cookie);
                    searchRequest.addControl((Control)control);
                } else {
                    pageResultStartIndex = 0;
                }
                connection.searchAsync(searchRequest, new SearchResultHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean handleEntry(SearchResultEntry entry) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            if (pendingResult != null) {
                                return false;
                            }
                            if (totalResourceCount++ < pageResultStartIndex) {
                                return true;
                            }
                            pendingResourceCount++;
                        }
                        final String id = LDAPCollectionResourceProvider.this.nameStrategy.getResourceId(requestState, (Entry)entry);
                        final String revision = LDAPCollectionResourceProvider.this.getRevisionFromEntry((Entry)entry);
                        LDAPCollectionResourceProvider.this.attributeMapper.read(requestState, new JsonPointer(), (Entry)entry).thenOnResult((ResultHandler)new ResultHandler<JsonValue>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleResult(JsonValue result) {
                                Object object = sequenceLock;
                                synchronized (object) {
                                    pendingResourceCount--;
                                    if (!resultSent) {
                                        resourceHandler.handleResource(Responses.newResourceResponse((String)id, (String)revision, (JsonValue)result));
                                    }
                                    this.completeIfNecessary((PromiseImpl<QueryResponse, ResourceException>)promise);
                                }
                            }
                        }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleException(ResourceException exception) {
                                Object object = sequenceLock;
                                synchronized (object) {
                                    pendingResourceCount--;
                                    this.completeIfNecessary(exception, (PromiseImpl<QueryResponse, ResourceException>)promise);
                                }
                            }
                        });
                        return true;
                    }

                    public boolean handleReference(SearchResultReference reference) {
                        return true;
                    }
                }).thenOnResult((ResultHandler)new ResultHandler<Result>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleResult(Result result) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            if (request.getPageSize() > 0) {
                                try {
                                    SimplePagedResultsControl control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, DECODE_OPTIONS);
                                    if (control != null && !control.getCookie().isEmpty()) {
                                        cookie = control.getCookie().toBase64String();
                                    }
                                }
                                catch (DecodeException decodeException) {
                                    // empty catch block
                                }
                            }
                            this.completeIfNecessary(SUCCESS, (PromiseImpl<QueryResponse, ResourceException>)promise);
                        }
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleException(LdapException exception) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            this.completeIfNecessary(Rest2LDAP.asResourceException((Throwable)exception), (PromiseImpl<QueryResponse, ResourceException>)promise);
                        }
                    }
                });
                return promise;
            }

            private void completeIfNecessary(ResourceException e, PromiseImpl<QueryResponse, ResourceException> handler) {
                if (this.pendingResult == null) {
                    this.pendingResult = e;
                }
                this.completeIfNecessary(handler);
            }

            private void completeIfNecessary(PromiseImpl<QueryResponse, ResourceException> handler) {
                if (this.pendingResourceCount == 0 && this.pendingResult != null && !this.resultSent) {
                    if (this.pendingResult == SUCCESS) {
                        handler.handleResult((Object)Responses.newQueryResponse((String)this.cookie));
                    } else {
                        handler.handleException((Exception)((Object)this.pendingResult));
                    }
                    this.resultSent = true;
                }
            }
        };
    }

    public Promise<ResourceResponse, ResourceException> readInstance(Context context, final String resourceId, final ReadRequest request) {
        final RequestState requestState = this.wrap(context);
        return requestState.getConnection().thenAsync((AsyncFunction)new AsyncFunction<Connection, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(Connection connection) throws ResourceException {
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.searchRequest(requestState, resourceId, request.getFields());
                return connection.searchSingleEntryAsync(searchRequest).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, ResourceResponse, ResourceException>(){

                    public Promise<ResourceResponse, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                        return LDAPCollectionResourceProvider.this.adaptEntry(requestState, (Entry)entry);
                    }
                }, LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
            }
        }).thenFinally(this.close(requestState));
    }

    public Promise<ResourceResponse, ResourceException> updateInstance(Context context, final String resourceId, final UpdateRequest request) {
        final RequestState requestState = this.wrap(context);
        AtomicReference<Connection> connectionHolder = new AtomicReference<Connection>();
        return requestState.getConnection().thenOnResult(this.saveConnection(connectionHolder)).thenAsync((AsyncFunction)new AsyncFunction<Connection, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(final Connection connection) throws ResourceException {
                List attrs = Collections.emptyList();
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.searchRequest(requestState, resourceId, attrs);
                return connection.searchSingleEntryAsync(searchRequest).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, ResourceResponse, ResourceException>(){

                    public Promise<ResourceResponse, ResourceException> apply(final SearchResultEntry entry) {
                        try {
                            LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, request.getRevision());
                            final ModifyRequest modifyRequest = Requests.newModifyRequest((DN)entry.getName());
                            if (LDAPCollectionResourceProvider.this.config.readOnUpdatePolicy() == ReadOnUpdatePolicy.CONTROLS) {
                                String[] attributes = LDAPCollectionResourceProvider.this.getLDAPAttributes(requestState, request.getFields());
                                modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (String[])attributes));
                            }
                            if (LDAPCollectionResourceProvider.this.config.usePermissiveModify()) {
                                modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                            }
                            LDAPCollectionResourceProvider.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                            return LDAPCollectionResourceProvider.this.attributeMapper.update(requestState, new JsonPointer(), (Entry)entry, request.getContent()).thenAsync((AsyncFunction)new AsyncFunction<List<Modification>, ResourceResponse, ResourceException>(){

                                public Promise<ResourceResponse, ResourceException> apply(List<Modification> modifications) throws ResourceException {
                                    if (modifications.isEmpty()) {
                                        return LDAPCollectionResourceProvider.this.adaptEntry(requestState, (Entry)entry);
                                    }
                                    modifyRequest.getModifications().addAll(modifications);
                                    return connection.applyChangeAsync((ChangeRecord)modifyRequest).thenAsync(LDAPCollectionResourceProvider.this.postUpdateResultAsyncFunction(requestState), LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
                                }
                            });
                        }
                        catch (Exception e) {
                            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
                        }
                    }
                }, LDAPCollectionResourceProvider.this.ldapExceptionToResourceException());
            }
        }).thenFinally(this.close(requestState));
    }

    private Promise<ResourceResponse, ResourceException> adaptEntry(RequestState requestState, Entry entry) {
        final String actualResourceId = this.nameStrategy.getResourceId(requestState, entry);
        final String revision = this.getRevisionFromEntry(entry);
        return this.attributeMapper.read(requestState, new JsonPointer(), entry).then((Function)new Function<JsonValue, ResourceResponse, ResourceException>(){

            public ResourceResponse apply(JsonValue value) {
                return Responses.newResourceResponse((String)actualResourceId, (String)revision, (JsonValue)new JsonValue((Object)value));
            }
        });
    }

    private void addAssertionControl(ChangeRecord request, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            request.addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)Filter.equality((String)this.etagAttribute.toString(), (Object)expectedRevision)));
        }
    }

    private AsyncFunction<Connection, DN, ResourceException> doUpdateFunction(final RequestState requestState, final String resourceId, final String revision) {
        return new AsyncFunction<Connection, DN, ResourceException>(){

            public Promise<DN, ResourceException> apply(Connection connection) {
                String ldapAttribute = LDAPCollectionResourceProvider.this.etagAttribute != null && revision != null ? LDAPCollectionResourceProvider.this.etagAttribute.toString() : "1.1";
                SearchRequest searchRequest = LDAPCollectionResourceProvider.this.nameStrategy.createSearchRequest(requestState, LDAPCollectionResourceProvider.this.getBaseDN(), resourceId).addAttribute(new String[]{ldapAttribute});
                if (searchRequest.getScope().equals((Object)SearchScope.BASE_OBJECT)) {
                    return Promises.newResultPromise((Object)searchRequest.getName());
                }
                return connection.searchSingleEntryAsync(searchRequest).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, DN, ResourceException>(){

                    public Promise<DN, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                        try {
                            LDAPCollectionResourceProvider.this.ensureMVCCVersionMatches((Entry)entry, revision);
                            return Promises.newResultPromise((Object)entry.getName());
                        }
                        catch (Exception e) {
                            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
                        }
                    }
                }, (AsyncFunction)new AsyncFunction<LdapException, DN, ResourceException>(){

                    public Promise<DN, ResourceException> apply(LdapException ldapException) throws ResourceException {
                        return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException((Throwable)ldapException)));
                    }
                });
            }
        };
    }

    private void ensureMVCCSupported() throws NotSupportedException {
        if (this.etagAttribute == null) {
            throw new NotSupportedException(Utils.i18n("Multi-version concurrency control is not supported by this resource", new Object[0]));
        }
    }

    private void ensureMVCCVersionMatches(Entry entry, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMVCCSupported();
            String actualRevision = entry.parseAttribute(this.etagAttribute).asString();
            if (actualRevision == null) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because it did not contain any version information, when the version '%s' was expected", expectedRevision));
            }
            if (!expectedRevision.equals(actualRevision)) {
                throw new PreconditionFailedException(Utils.i18n("The resource could not be accessed because the expected version '%s' does not match the current version '%s'", expectedRevision, actualRevision));
            }
        }
    }

    private DN getBaseDN() {
        return this.baseDN;
    }

    private String[] getLDAPAttributes(RequestState requestState, Collection<JsonPointer> requestedAttributes) {
        LinkedHashSet<String> requestedLDAPAttributes;
        if (requestedAttributes.isEmpty()) {
            requestedLDAPAttributes = new LinkedHashSet<String>();
            this.attributeMapper.getLDAPAttributes(requestState, new JsonPointer(), new JsonPointer(), requestedLDAPAttributes);
        } else {
            requestedLDAPAttributes = new LinkedHashSet(requestedAttributes.size());
            for (JsonPointer requestedAttribute : requestedAttributes) {
                this.attributeMapper.getLDAPAttributes(requestState, new JsonPointer(), requestedAttribute, requestedLDAPAttributes);
            }
        }
        this.nameStrategy.getLDAPAttributes(requestState, requestedLDAPAttributes);
        if (this.etagAttribute != null) {
            requestedLDAPAttributes.add(this.etagAttribute.toString());
        }
        return requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
    }

    private String getRevisionFromEntry(Entry entry) {
        return this.etagAttribute != null ? entry.parseAttribute(this.etagAttribute).asString() : null;
    }

    private AsyncFunction<Result, ResourceResponse, ResourceException> postUpdateResultAsyncFunction(final RequestState requestState) {
        return new AsyncFunction<Result, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(Result result) throws ResourceException {
                Object entry;
                try {
                    PreReadResponseControl preReadControl;
                    PostReadResponseControl postReadControl = (PostReadResponseControl)result.getControl(PostReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions());
                    entry = postReadControl != null ? postReadControl.getEntry() : ((preReadControl = (PreReadResponseControl)result.getControl(PreReadResponseControl.DECODER, LDAPCollectionResourceProvider.this.config.decodeOptions())) != null ? preReadControl.getEntry() : null);
                }
                catch (DecodeException e) {
                    entry = null;
                }
                if (entry != null) {
                    return LDAPCollectionResourceProvider.this.adaptEntry(requestState, entry);
                }
                return Promises.newResultPromise((Object)Responses.newResourceResponse(null, null, (JsonValue)new JsonValue(Collections.emptyMap())));
            }
        };
    }

    private AsyncFunction<LdapException, ResourceResponse, ResourceException> ldapExceptionToResourceException() {
        return this.ldapToResourceException();
    }

    private <R> AsyncFunction<LdapException, R, ResourceException> ldapToResourceException() {
        return new AsyncFunction<LdapException, R, ResourceException>(){

            public Promise<R, ResourceException> apply(LdapException ldapException) throws ResourceException {
                return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException((Throwable)ldapException)));
            }
        };
    }

    private SearchRequest searchRequest(RequestState requestState, String resourceId, List<JsonPointer> requestedAttributes) {
        String[] attributes = this.getLDAPAttributes(requestState, requestedAttributes);
        return this.nameStrategy.createSearchRequest(requestState, this.getBaseDN(), resourceId).addAttribute(attributes);
    }

    private RequestState wrap(Context context) {
        return new RequestState(this.config, context);
    }

    private Runnable close(final RequestState requestState) {
        return new Runnable(){

            @Override
            public void run() {
                requestState.close();
            }
        };
    }

    private ResultHandler<Connection> saveConnection(final AtomicReference<Connection> connectionHolder) {
        return new ResultHandler<Connection>(){

            public void handleResult(Connection connection) {
                connectionHolder.set(connection);
            }
        };
    }
}

