/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class JSONConstantAttributeMapper
extends AttributeMapper {
    private final JsonValue value;

    JSONConstantAttributeMapper(Object value) {
        this.value = new JsonValue(value);
    }

    public String toString() {
        return "constant(" + this.value + ")";
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(RequestState requestState, JsonPointer path, JsonValue v) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to create the read-only field '%s'", path)));
        }
        return Promises.newResultPromise(Collections.emptyList());
    }

    @Override
    void getLDAPAttributes(RequestState requestState, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
    }

    @Override
    Promise<Filter, ResourceException> getLDAPFilter(RequestState requestState, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        Filter filter;
        JsonValue subValue = this.value.get(subPath);
        if (subValue == null) {
            filter = Filter.alwaysFalse();
        } else if (type == FilterType.PRESENT) {
            filter = Filter.alwaysTrue();
        } else if (this.value.isString() && valueAssertion instanceof String) {
            String v1 = Utils.toLowerCase(this.value.asString());
            String v2 = Utils.toLowerCase((String)valueAssertion);
            switch (type) {
                case CONTAINS: {
                    filter = Utils.toFilter(v1.contains(v2));
                    break;
                }
                case STARTS_WITH: {
                    filter = Utils.toFilter(v1.startsWith(v2));
                    break;
                }
                default: {
                    filter = this.compare(type, v1, v2);
                    break;
                }
            }
        } else if (this.value.isNumber() && valueAssertion instanceof Number) {
            Double v1 = this.value.asDouble();
            Double v2 = ((Number)valueAssertion).doubleValue();
            filter = this.compare(type, v1, v2);
        } else if (this.value.isBoolean() && valueAssertion instanceof Boolean) {
            Boolean v1 = this.value.asBoolean();
            Boolean v2 = (Boolean)valueAssertion;
            filter = this.compare(type, v1, v2);
        } else {
            filter = Filter.alwaysFalse();
        }
        return Promises.newResultPromise((Object)filter);
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(RequestState requestState, JsonPointer path, PatchOperation operation) {
        return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to patch the read-only field '%s'", path)));
    }

    @Override
    Promise<JsonValue, ResourceException> read(RequestState requestState, JsonPointer path, Entry e) {
        return Promises.newResultPromise((Object)this.value.copy());
    }

    @Override
    Promise<List<Modification>, ResourceException> update(RequestState requestState, JsonPointer path, Entry e, JsonValue v) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path)));
        }
        return Promises.newResultPromise(Collections.emptyList());
    }

    private <T extends Comparable<T>> Filter compare(FilterType type, T v1, T v2) {
        switch (type) {
            case EQUAL_TO: {
                return Utils.toFilter(v1.equals(v2));
            }
            case GREATER_THAN: {
                return Utils.toFilter(v1.compareTo(v2) > 0);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return Utils.toFilter(v1.compareTo(v2) >= 0);
            }
            case LESS_THAN: {
                return Utils.toFilter(v1.compareTo(v2) < 0);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return Utils.toFilter(v1.compareTo(v2) <= 0);
            }
        }
        return Filter.alwaysFalse();
    }
}

