/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.WritabilityPolicy;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

abstract class AbstractLDAPAttributeMapper<T extends AbstractLDAPAttributeMapper<T>>
extends AttributeMapper {
    List<Object> defaultJSONValues = Collections.emptyList();
    final AttributeDescription ldapAttributeName;
    private boolean isRequired;
    private boolean isSingleValued;
    private WritabilityPolicy writabilityPolicy = WritabilityPolicy.READ_WRITE;

    AbstractLDAPAttributeMapper(AttributeDescription ldapAttributeName) {
        this.ldapAttributeName = ldapAttributeName;
    }

    public final T isRequired() {
        this.isRequired = true;
        return this.getThis();
    }

    public final T isSingleValued() {
        this.isSingleValued = true;
        return this.getThis();
    }

    public final T writability(WritabilityPolicy policy) {
        this.writabilityPolicy = policy;
        return this.getThis();
    }

    boolean attributeIsSingleValued() {
        return this.isSingleValued || this.ldapAttributeName.getAttributeType().isSingleValue();
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(RequestState requestState, final JsonPointer path, JsonValue v) {
        return this.getNewLDAPAttributes(requestState, path, v).then((Function)new Function<Attribute, List<Attribute>, ResourceException>(){

            public List<Attribute> apply(Attribute newLDAPAttribute) throws ResourceException {
                if (!AbstractLDAPAttributeMapper.this.writabilityPolicy.canCreate(AbstractLDAPAttributeMapper.this.ldapAttributeName)) {
                    if (!newLDAPAttribute.isEmpty() && !AbstractLDAPAttributeMapper.this.writabilityPolicy.discardWrites()) {
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to create the read-only field '%s'", path));
                    }
                    return Collections.emptyList();
                }
                if (newLDAPAttribute.isEmpty()) {
                    if (AbstractLDAPAttributeMapper.this.isRequired) {
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path));
                    }
                    return Collections.emptyList();
                }
                return Collections.singletonList(newLDAPAttribute);
            }
        });
    }

    @Override
    void getLDAPAttributes(RequestState requestState, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        ldapAttributes.add(this.ldapAttributeName.toString());
    }

    abstract Promise<Attribute, ResourceException> getNewLDAPAttributes(RequestState var1, JsonPointer var2, List<Object> var3);

    abstract T getThis();

    @Override
    Promise<List<Modification>, ResourceException> patch(RequestState requestState, JsonPointer path, PatchOperation operation) {
        try {
            ModificationType modType;
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (!this.writabilityPolicy.canWrite(this.ldapAttributeName)) {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path));
            }
            switch (field.size()) {
                case 0: {
                    if (this.attributeIsSingleValued()) {
                        if (!v.isList()) break;
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was provided for the single valued field '%s'", path));
                    }
                    if (v.isList() || operation.isIncrement() || v.isNull() && (operation.isReplace() || operation.isRemove())) break;
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was not provided for the multi-valued field '%s'", path));
                }
                case 1: {
                    String fieldName = field.get(0);
                    if (fieldName.equals("-") && operation.isAdd()) {
                        if (this.attributeIsSingleValued()) {
                            throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to append a value to the single valued field '%s'", path));
                        }
                        if (!v.isList()) break;
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to perform an indexed append of an array of values to the multi-valued field '%s'", path.child(fieldName)));
                    }
                    if (fieldName.matches("[0-9]+")) {
                        throw new NotSupportedException(Utils.i18n("The request cannot be processed because it included an indexed patch operation '%s' which is not supported by this resource provider", path.child(fieldName)));
                    }
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(fieldName)));
                }
                default: {
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(field.get(0))));
                }
            }
            List<Object> newValues = this.asList(v, Collections.emptyList());
            if (operation.isAdd()) {
                ModificationType modificationType = modType = this.attributeIsSingleValued() ? ModificationType.REPLACE : ModificationType.ADD;
                if (newValues.isEmpty()) {
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an add patch operation but no value(s) for field '%s'", path.child(field.get(0))));
                }
            } else if (operation.isRemove()) {
                modType = ModificationType.DELETE;
            } else if (operation.isReplace()) {
                modType = ModificationType.REPLACE;
            } else if (operation.isIncrement()) {
                modType = ModificationType.INCREMENT;
            } else {
                throw new NotSupportedException(Utils.i18n("The request cannot be processed because it included an unsupported type of patch operation '%s'", operation.getOperation()));
            }
            if (newValues.isEmpty()) {
                if (this.isRequired) {
                    return Promises.newExceptionPromise((Exception)new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path)));
                }
                return Promises.newResultPromise(Collections.singletonList(new Modification(modType, Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName))));
            }
            return this.getNewLDAPAttributes(requestState, path, newValues).then((Function)new Function<Attribute, List<Modification>, ResourceException>(){

                public List<Modification> apply(Attribute value) {
                    return Collections.singletonList(new Modification(modType, value));
                }
            });
        }
        catch (RuntimeException e) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)((Object)e));
        }
    }

    @Override
    Promise<List<Modification>, ResourceException> update(RequestState requestState, final JsonPointer path, final Entry e, JsonValue v) {
        return this.getNewLDAPAttributes(requestState, path, v).then((Function)new Function<Attribute, List<Modification>, ResourceException>(){

            public List<Modification> apply(Attribute newLDAPAttribute) throws ResourceException {
                Attribute oldLDAPAttribute;
                Attribute tmp = e.getAttribute(AbstractLDAPAttributeMapper.this.ldapAttributeName);
                Attribute attribute = oldLDAPAttribute = tmp != null ? tmp : Attributes.emptyAttribute((AttributeDescription)AbstractLDAPAttributeMapper.this.ldapAttributeName);
                if (!AbstractLDAPAttributeMapper.this.writabilityPolicy.canWrite(AbstractLDAPAttributeMapper.this.ldapAttributeName)) {
                    if (newLDAPAttribute.isEmpty() || newLDAPAttribute.equals((Object)oldLDAPAttribute) || AbstractLDAPAttributeMapper.this.writabilityPolicy.discardWrites()) {
                        return Collections.emptyList();
                    }
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to modify the read-only field '%s'", path));
                }
                if (oldLDAPAttribute.isEmpty() && newLDAPAttribute.isEmpty()) {
                    return Collections.emptyList();
                }
                if (oldLDAPAttribute.isEmpty()) {
                    return Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                }
                if (newLDAPAttribute.isEmpty()) {
                    if (AbstractLDAPAttributeMapper.this.isRequired) {
                        throw new BadRequestException(Utils.i18n("The request cannot be processed because it attempts to remove the required field '%s'", path));
                    }
                    return Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                }
                ArrayList<Modification> modifications = new ArrayList<Modification>(2);
                LinkedAttribute deletedValues = new LinkedAttribute(oldLDAPAttribute);
                deletedValues.removeAll((Collection)newLDAPAttribute);
                if (!deletedValues.isEmpty()) {
                    modifications.add(new Modification(ModificationType.DELETE, (Attribute)deletedValues));
                }
                LinkedAttribute addedValues = new LinkedAttribute(newLDAPAttribute);
                addedValues.removeAll((Collection)oldLDAPAttribute);
                if (!addedValues.isEmpty()) {
                    modifications.add(new Modification(ModificationType.ADD, (Attribute)addedValues));
                }
                return modifications;
            }
        });
    }

    private List<Object> asList(JsonValue v, List<Object> defaultValues) {
        if (Utils.isNullOrEmpty(v)) {
            return defaultValues;
        }
        if (v.isList()) {
            return v.asList();
        }
        return Collections.singletonList(v.getObject());
    }

    private void checkSchema(JsonPointer path, JsonValue v) throws BadRequestException {
        if (this.attributeIsSingleValued()) {
            if (v != null && v.isList()) {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was provided for the single valued field '%s'", path));
            }
        } else if (v != null && !v.isList()) {
            throw new BadRequestException(Utils.i18n("The request cannot be processed because an array of values was not provided for the multi-valued field '%s'", path));
        }
    }

    private Promise<Attribute, ResourceException> getNewLDAPAttributes(RequestState requestState, JsonPointer path, JsonValue v) {
        try {
            this.checkSchema(path, v);
            List<Object> newValues = this.asList(v, this.defaultJSONValues);
            if (newValues.isEmpty()) {
                return Promises.newResultPromise((Object)Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName));
            }
            return this.getNewLDAPAttributes(requestState, path, newValues);
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
        }
    }
}

