/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class MatchingRuleUse
extends SchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> attributeOIDs;
    private MatchingRule matchingRule;
    private Set<AttributeType> attributes = Collections.emptySet();

    private MatchingRuleUse(Builder builder) {
        super(builder);
        Reject.ifNull((Object)builder.oid);
        this.oid = builder.oid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.attributeOIDs = SchemaUtils.unmodifiableCopyOfSet(builder.attributeOIDs);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchingRuleUse) {
            MatchingRuleUse other = (MatchingRuleUse)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Set<AttributeType> getAttributes() {
        return this.attributes;
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public String getMatchingRuleOID() {
        return this.oid;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.contains(attributeType);
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.oid.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.attributeOIDs.isEmpty()) {
            iterator = this.attributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" APPLIES ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" APPLIES ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema) throws SchemaException {
        try {
            this.matchingRule = schema.getMatchingRule(this.oid);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE1.get((Object)this.getNameOrOID(), (Object)this.oid);
            throw new SchemaException(message, (Throwable)((Object)e));
        }
        this.attributes = new HashSet<AttributeType>(this.attributeOIDs.size());
        for (String attribute : this.attributeOIDs) {
            try {
                this.attributes.add(schema.getAttributeType(attribute));
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR1.get((Object)this.getNameOrOID(), (Object)attribute);
                throw new SchemaException(message, (Throwable)((Object)e));
            }
        }
        this.attributes = Collections.unmodifiableSet(this.attributes);
    }

    public static final class Builder
    extends SchemaElement.SchemaElementBuilder<Builder> {
        private String oid;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private final Set<String> attributeOIDs = new LinkedHashSet<String>();

        Builder(MatchingRuleUse mru, SchemaBuilder builder) {
            super(builder, mru);
            this.oid = mru.oid;
            this.names.addAll(mru.names);
            this.isObsolete = mru.isObsolete;
            this.attributeOIDs.addAll(mru.attributeOIDs);
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid = oid;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addMatchingRuleUse(new MatchingRuleUse(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addMatchingRuleUse(new MatchingRuleUse(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        public Builder attributes(Collection<String> attributeOIDs) {
            this.attributeOIDs.addAll(attributeOIDs);
            return this;
        }

        public Builder attributes(String ... attributeOIDs) {
            this.attributeOIDs.addAll(Arrays.asList(attributeOIDs));
            return this;
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder removeAllAttributes() {
            this.attributeOIDs.clear();
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAttribute(String attributeOID) {
            this.attributeOIDs.remove(attributeOID);
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }
    }
}

