/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class IntegerSyntaxImpl
extends AbstractSyntaxImpl {
    IntegerSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.14";
    }

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.15";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.7";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString();
        int length = valueString.length();
        if (length == 0) {
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_EMPTY_VALUE.get((Object)valueString));
            return false;
        }
        if (length == 1) {
            switch (valueString.charAt(0)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
                case '-': {
                    invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_DASH_NEEDS_VALUE.get((Object)valueString));
                    return false;
                }
            }
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER.get((Object)valueString, (Object)Character.valueOf(valueString.charAt(0)), (Object)0));
            return false;
        }
        boolean negative = false;
        switch (valueString.charAt(0)) {
            case '0': {
                invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO.get((Object)valueString));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            case '-': {
                negative = true;
                break;
            }
            default: {
                invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER.get((Object)valueString, (Object)Character.valueOf(valueString.charAt(0)), (Object)0));
                return false;
            }
        }
        switch (valueString.charAt(1)) {
            case '0': {
                if (!negative) break;
                invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INITIAL_ZERO.get((Object)valueString));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER.get((Object)valueString, (Object)Character.valueOf(valueString.charAt(0)), (Object)0));
                return false;
            }
        }
        block16: for (int i = 2; i < length; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block16;
                }
                default: {
                    invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_INTEGER_INVALID_CHARACTER.get((Object)valueString, (Object)Character.valueOf(valueString.charAt(0)), (Object)0));
                    return false;
                }
            }
        }
        return true;
    }
}

