/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaOptions;

final class CertificateSyntaxImpl
extends AbstractSyntaxImpl {
    CertificateSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.34";
    }

    @Override
    public String getName() {
        return "Certificate";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.18";
    }

    @Override
    public boolean isBEREncodingRequired() {
        return true;
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        if (schema.getOption(SchemaOptions.ALLOW_MALFORMED_CERTIFICATES).booleanValue()) {
            return true;
        }
        ASN1Reader reader = ASN1.getReader(value);
        try {
            reader.readStartSequence((byte)48);
            reader.readStartSequence((byte)48);
            long x509Version = 0L;
            if (reader.hasNextElement() && reader.peekType() == -96) {
                reader.readStartExplicitTag((byte)-96);
                x509Version = reader.readInteger((byte)2);
                if (x509Version < 0L || x509Version > 2L) {
                    invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_INVALID_VERSION.get((Object)x509Version));
                    return false;
                }
                if (x509Version == 0L) {
                    invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_INVALID_DER.get());
                    return false;
                }
                reader.readEndExplicitTag();
            }
            reader.skipElement((byte)2);
            reader.skipElement((byte)48);
            reader.skipElement((byte)48);
            reader.skipElement((byte)48);
            reader.skipElement((byte)48);
            reader.skipElement((byte)48);
            if (reader.hasNextElement() && reader.peekType() == -127) {
                if (x509Version < 1L) {
                    invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_ONLY_VALID_V23.get((Object)"issuerUniqueIdentifier"));
                    return false;
                }
                reader.skipElement();
            }
            if (reader.hasNextElement() && reader.peekType() == -126) {
                if (x509Version < 1L) {
                    invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_ONLY_VALID_V23.get((Object)"subjectUniqueIdentifier"));
                    return false;
                }
                reader.skipElement();
            }
            if (reader.hasNextElement() && reader.peekType() == -93) {
                if (x509Version < 2L) {
                    invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_ONLY_VALID_V3.get((Object)"extensions"));
                    return false;
                }
                reader.readStartExplicitTag((byte)-93);
                reader.skipElement((byte)48);
                reader.readEndExplicitTag();
            }
            if (reader.hasNextElement()) {
                invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_NO_ELEMENT_EXPECTED.get());
                return false;
            }
            reader.readEndSequence();
            reader.skipElement((byte)48);
            reader.skipElement((byte)3);
            if (reader.hasNextElement()) {
                invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_NO_ELEMENT_EXPECTED.get());
                return false;
            }
            reader.readEndSequence();
            if (reader.hasNextElement()) {
                invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_NO_ELEMENT_EXPECTED.get());
                return false;
            }
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_SYNTAX_CERTIFICATE_NOTVALID.get((Object)de));
            return false;
        }
        catch (IOException e) {
            invalidReason.append(StaticUtils.getExceptionMessage(e));
            return false;
        }
        return true;
    }
}

