/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import java.util.Collection;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.responses.AbstractResponseImpl;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

final class SearchResultEntryImpl
extends AbstractResponseImpl<SearchResultEntry>
implements SearchResultEntry {
    private final Entry entry;

    SearchResultEntryImpl(Entry entry) {
        this.entry = entry;
    }

    SearchResultEntryImpl(SearchResultEntry searchResultEntry) {
        super(searchResultEntry);
        this.entry = LinkedHashMapEntry.deepCopyOfEntry(searchResultEntry);
    }

    @Override
    public boolean addAttribute(Attribute attribute) {
        return this.entry.addAttribute(attribute);
    }

    @Override
    public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
        return this.entry.addAttribute(attribute, duplicateValues);
    }

    @Override
    public SearchResultEntry addAttribute(String attributeDescription, Object ... values) {
        this.entry.addAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public SearchResultEntry clearAttributes() {
        this.entry.clearAttributes();
        return this;
    }

    @Override
    public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return this.entry.containsAttribute(attribute, missingValues);
    }

    @Override
    public boolean containsAttribute(String attributeDescription, Object ... values) {
        return this.entry.containsAttribute(attributeDescription, values);
    }

    @Override
    public boolean equals(Object object) {
        return this.entry.equals(object);
    }

    @Override
    public Iterable<Attribute> getAllAttributes() {
        return this.entry.getAllAttributes();
    }

    @Override
    public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
        return this.entry.getAllAttributes(attributeDescription);
    }

    @Override
    public Iterable<Attribute> getAllAttributes(String attributeDescription) {
        return this.entry.getAllAttributes(attributeDescription);
    }

    @Override
    public Attribute getAttribute(AttributeDescription attributeDescription) {
        return this.entry.getAttribute(attributeDescription);
    }

    @Override
    public Attribute getAttribute(String attributeDescription) {
        return this.entry.getAttribute(attributeDescription);
    }

    @Override
    public int getAttributeCount() {
        return this.entry.getAttributeCount();
    }

    @Override
    public DN getName() {
        return this.entry.getName();
    }

    @Override
    public int hashCode() {
        return this.entry.hashCode();
    }

    @Override
    public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
        return this.entry.parseAttribute(attributeDescription);
    }

    @Override
    public AttributeParser parseAttribute(String attributeDescription) {
        return this.entry.parseAttribute(attributeDescription);
    }

    @Override
    public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return this.entry.removeAttribute(attribute, missingValues);
    }

    @Override
    public boolean removeAttribute(AttributeDescription attributeDescription) {
        return this.entry.removeAttribute(attributeDescription);
    }

    @Override
    public SearchResultEntry removeAttribute(String attributeDescription, Object ... values) {
        this.entry.removeAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public boolean replaceAttribute(Attribute attribute) {
        return this.entry.replaceAttribute(attribute);
    }

    @Override
    public SearchResultEntry replaceAttribute(String attributeDescription, Object ... values) {
        this.entry.replaceAttribute(attributeDescription, values);
        return this;
    }

    @Override
    public SearchResultEntry setName(DN dn) {
        this.entry.setName(dn);
        return this;
    }

    @Override
    public SearchResultEntry setName(String dn) {
        this.entry.setName(dn);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchResultEntry(name=");
        builder.append(this.getName());
        builder.append(", attributes=");
        builder.append(this.getAllAttributes());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    SearchResultEntry getThis() {
        return this;
    }
}

