/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Collections2;
import java.util.Collections;
import java.util.List;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;

abstract class AbstractUnmodifiableRequest<R extends Request>
implements Request {
    protected final R impl;

    AbstractUnmodifiableRequest(R impl) {
        this.impl = impl;
    }

    public final R addControl(Control control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsControl(String oid) {
        return this.impl.containsControl(oid);
    }

    @Override
    public final <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
        Reject.ifNull((Object[])new Object[]{decoder, options});
        List<Control> controls = this.impl.getControls();
        Control control = AbstractRequestImpl.getControl(controls, decoder.getOID());
        if (control == null) {
            return null;
        }
        C decodedControl = decoder.decodeControl(control, options);
        if (decodedControl != control) {
            return decodedControl;
        }
        if (decodedControl instanceof GenericControl) {
            return decodedControl;
        }
        GenericControl genericControl = GenericControl.newControl(control);
        return decoder.decodeControl(genericControl, options);
    }

    @Override
    public final List<Control> getControls() {
        Function<Control, Control, NeverThrowsException> function = new Function<Control, Control, NeverThrowsException>(){

            public Control apply(Control value) {
                return GenericControl.newControl(value);
            }
        };
        List<Control> unmodifiableControls = Collections2.transformedList(this.impl.getControls(), function, Functions.identityFunction());
        return Collections.unmodifiableList(unmodifiableControls);
    }

    public final String toString() {
        return this.impl.toString();
    }
}

