/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class ProxiedAuthV1RequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "2.16.840.1.113730.3.4.12";
    public static final ControlDecoder<ProxiedAuthV1RequestControl> DECODER = new ControlDecoder<ProxiedAuthV1RequestControl>(){

        @Override
        public ProxiedAuthV1RequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            DN authorizationDN;
            String authorizationDNString;
            Reject.ifNull((Object)control);
            if (control instanceof ProxiedAuthV1RequestControl) {
                return (ProxiedAuthV1RequestControl)control;
            }
            if (!control.getOID().equals(ProxiedAuthV1RequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH1_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)ProxiedAuthV1RequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.isCritical()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH1_CONTROL_NOT_CRITICAL.get();
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH1_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                authorizationDNString = reader.readOctetStringAsString();
                reader.readEndSequence();
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw((CharSequence)"Unable to read sequence", (Object[])new Object[]{e}));
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH1_CANNOT_DECODE_VALUE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            Schema schema = options.getSchemaResolver().resolveSchema(authorizationDNString);
            try {
                authorizationDN = DN.valueOf(authorizationDNString, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH1_INVALID_AUTHZIDDN.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            return new ProxiedAuthV1RequestControl(authorizationDN);
        }

        @Override
        public String getOID() {
            return ProxiedAuthV1RequestControl.OID;
        }
    };
    private final DN authorizationName;

    public static ProxiedAuthV1RequestControl newControl(DN authorizationName) {
        Reject.ifNull((Object)authorizationName);
        return new ProxiedAuthV1RequestControl(authorizationName);
    }

    public static ProxiedAuthV1RequestControl newControl(String authorizationName) {
        Reject.ifNull((Object)authorizationName);
        return new ProxiedAuthV1RequestControl(DN.valueOf(authorizationName));
    }

    private ProxiedAuthV1RequestControl(DN authorizationName) {
        this.authorizationName = authorizationName;
    }

    public DN getAuthorizationDNName() {
        return this.authorizationName;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeOctetString(this.authorizationName.toString());
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ProxiedAuthorizationV1Control(oid=");
        buffer.append(this.getOID());
        buffer.append(", criticality=");
        buffer.append(this.isCritical());
        buffer.append(", proxyDN=\"");
        buffer.append(this.authorizationName);
        buffer.append("\")");
        return buffer.toString();
    }
}

