/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;

public final class ResultCode {
    private static final Map<Integer, ResultCode> ELEMENTS = new LinkedHashMap<Integer, ResultCode>();
    public static final ResultCode UNDEFINED = ResultCode.registerErrorResultCode(-1, CoreMessages.INFO_RESULT_UNDEFINED.get(), Enum.UNDEFINED);
    public static final ResultCode SUCCESS = ResultCode.registerSuccessResultCode(0, CoreMessages.INFO_RESULT_SUCCESS.get(), Enum.SUCCESS);
    public static final ResultCode OPERATIONS_ERROR = ResultCode.registerErrorResultCode(1, CoreMessages.INFO_RESULT_OPERATIONS_ERROR.get(), Enum.OPERATIONS_ERROR);
    public static final ResultCode PROTOCOL_ERROR = ResultCode.registerErrorResultCode(2, CoreMessages.INFO_RESULT_PROTOCOL_ERROR.get(), Enum.PROTOCOL_ERROR);
    public static final ResultCode TIME_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(3, CoreMessages.INFO_RESULT_TIME_LIMIT_EXCEEDED.get(), Enum.TIME_LIMIT_EXCEEDED);
    public static final ResultCode SIZE_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(4, CoreMessages.INFO_RESULT_SIZE_LIMIT_EXCEEDED.get(), Enum.SIZE_LIMIT_EXCEEDED);
    public static final ResultCode COMPARE_FALSE = ResultCode.registerSuccessResultCode(5, CoreMessages.INFO_RESULT_COMPARE_FALSE.get(), Enum.COMPARE_FALSE);
    public static final ResultCode COMPARE_TRUE = ResultCode.registerSuccessResultCode(6, CoreMessages.INFO_RESULT_COMPARE_TRUE.get(), Enum.COMPARE_TRUE);
    public static final ResultCode AUTH_METHOD_NOT_SUPPORTED = ResultCode.registerErrorResultCode(7, CoreMessages.INFO_RESULT_AUTH_METHOD_NOT_SUPPORTED.get(), Enum.AUTH_METHOD_NOT_SUPPORTED);
    public static final ResultCode STRONG_AUTH_REQUIRED = ResultCode.registerErrorResultCode(8, CoreMessages.INFO_RESULT_STRONG_AUTH_REQUIRED.get(), Enum.STRONG_AUTH_REQUIRED);
    public static final ResultCode REFERRAL = ResultCode.registerErrorResultCode(10, CoreMessages.INFO_RESULT_REFERRAL.get(), Enum.REFERRAL);
    public static final ResultCode ADMIN_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(11, CoreMessages.INFO_RESULT_ADMIN_LIMIT_EXCEEDED.get(), Enum.ADMIN_LIMIT_EXCEEDED);
    public static final ResultCode UNAVAILABLE_CRITICAL_EXTENSION = ResultCode.registerErrorResultCode(12, CoreMessages.INFO_RESULT_UNAVAILABLE_CRITICAL_EXTENSION.get(), Enum.UNAVAILABLE_CRITICAL_EXTENSION);
    public static final ResultCode CONFIDENTIALITY_REQUIRED = ResultCode.registerErrorResultCode(13, CoreMessages.INFO_RESULT_CONFIDENTIALITY_REQUIRED.get(), Enum.CONFIDENTIALITY_REQUIRED);
    public static final ResultCode SASL_BIND_IN_PROGRESS = ResultCode.registerSuccessResultCode(14, CoreMessages.INFO_RESULT_SASL_BIND_IN_PROGRESS.get(), Enum.SASL_BIND_IN_PROGRESS);
    public static final ResultCode NO_SUCH_ATTRIBUTE = ResultCode.registerErrorResultCode(16, CoreMessages.INFO_RESULT_NO_SUCH_ATTRIBUTE.get(), Enum.NO_SUCH_ATTRIBUTE);
    public static final ResultCode UNDEFINED_ATTRIBUTE_TYPE = ResultCode.registerErrorResultCode(17, CoreMessages.INFO_RESULT_UNDEFINED_ATTRIBUTE_TYPE.get(), Enum.UNDEFINED_ATTRIBUTE_TYPE);
    public static final ResultCode INAPPROPRIATE_MATCHING = ResultCode.registerErrorResultCode(18, CoreMessages.INFO_RESULT_INAPPROPRIATE_MATCHING.get(), Enum.INAPPROPRIATE_MATCHING);
    public static final ResultCode CONSTRAINT_VIOLATION = ResultCode.registerErrorResultCode(19, CoreMessages.INFO_RESULT_CONSTRAINT_VIOLATION.get(), Enum.CONSTRAINT_VIOLATION);
    public static final ResultCode ATTRIBUTE_OR_VALUE_EXISTS = ResultCode.registerErrorResultCode(20, CoreMessages.INFO_RESULT_ATTRIBUTE_OR_VALUE_EXISTS.get(), Enum.ATTRIBUTE_OR_VALUE_EXISTS);
    public static final ResultCode INVALID_ATTRIBUTE_SYNTAX = ResultCode.registerErrorResultCode(21, CoreMessages.INFO_RESULT_INVALID_ATTRIBUTE_SYNTAX.get(), Enum.INVALID_ATTRIBUTE_SYNTAX);
    public static final ResultCode NO_SUCH_OBJECT = ResultCode.registerErrorResultCode(32, CoreMessages.INFO_RESULT_NO_SUCH_OBJECT.get(), Enum.NO_SUCH_OBJECT);
    public static final ResultCode ALIAS_PROBLEM = ResultCode.registerErrorResultCode(33, CoreMessages.INFO_RESULT_ALIAS_PROBLEM.get(), Enum.ALIAS_PROBLEM);
    public static final ResultCode INVALID_DN_SYNTAX = ResultCode.registerErrorResultCode(34, CoreMessages.INFO_RESULT_INVALID_DN_SYNTAX.get(), Enum.INVALID_DN_SYNTAX);
    public static final ResultCode ALIAS_DEREFERENCING_PROBLEM = ResultCode.registerErrorResultCode(36, CoreMessages.INFO_RESULT_ALIAS_DEREFERENCING_PROBLEM.get(), Enum.ALIAS_DEREFERENCING_PROBLEM);
    public static final ResultCode INAPPROPRIATE_AUTHENTICATION = ResultCode.registerErrorResultCode(48, CoreMessages.INFO_RESULT_INAPPROPRIATE_AUTHENTICATION.get(), Enum.INAPPROPRIATE_AUTHENTICATION);
    public static final ResultCode INVALID_CREDENTIALS = ResultCode.registerErrorResultCode(49, CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get(), Enum.INVALID_CREDENTIALS);
    public static final ResultCode INSUFFICIENT_ACCESS_RIGHTS = ResultCode.registerErrorResultCode(50, CoreMessages.INFO_RESULT_INSUFFICIENT_ACCESS_RIGHTS.get(), Enum.INSUFFICIENT_ACCESS_RIGHTS);
    public static final ResultCode BUSY = ResultCode.registerErrorResultCode(51, CoreMessages.INFO_RESULT_BUSY.get(), Enum.BUSY);
    public static final ResultCode UNAVAILABLE = ResultCode.registerErrorResultCode(52, CoreMessages.INFO_RESULT_UNAVAILABLE.get(), Enum.UNAVAILABLE);
    public static final ResultCode UNWILLING_TO_PERFORM = ResultCode.registerErrorResultCode(53, CoreMessages.INFO_RESULT_UNWILLING_TO_PERFORM.get(), Enum.UNWILLING_TO_PERFORM);
    public static final ResultCode LOOP_DETECT = ResultCode.registerErrorResultCode(54, CoreMessages.INFO_RESULT_LOOP_DETECT.get(), Enum.LOOP_DETECT);
    public static final ResultCode SORT_CONTROL_MISSING = ResultCode.registerErrorResultCode(60, CoreMessages.INFO_RESULT_SORT_CONTROL_MISSING.get(), Enum.SORT_CONTROL_MISSING);
    public static final ResultCode OFFSET_RANGE_ERROR = ResultCode.registerErrorResultCode(61, CoreMessages.INFO_RESULT_OFFSET_RANGE_ERROR.get(), Enum.OFFSET_RANGE_ERROR);
    public static final ResultCode NAMING_VIOLATION = ResultCode.registerErrorResultCode(64, CoreMessages.INFO_RESULT_NAMING_VIOLATION.get(), Enum.NAMING_VIOLATION);
    public static final ResultCode OBJECTCLASS_VIOLATION = ResultCode.registerErrorResultCode(65, CoreMessages.INFO_RESULT_OBJECTCLASS_VIOLATION.get(), Enum.OBJECTCLASS_VIOLATION);
    public static final ResultCode NOT_ALLOWED_ON_NONLEAF = ResultCode.registerErrorResultCode(66, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_NONLEAF.get(), Enum.NOT_ALLOWED_ON_NONLEAF);
    public static final ResultCode NOT_ALLOWED_ON_RDN = ResultCode.registerErrorResultCode(67, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_RDN.get(), Enum.NOT_ALLOWED_ON_RDN);
    public static final ResultCode ENTRY_ALREADY_EXISTS = ResultCode.registerErrorResultCode(68, CoreMessages.INFO_RESULT_ENTRY_ALREADY_EXISTS.get(), Enum.ENTRY_ALREADY_EXISTS);
    public static final ResultCode OBJECTCLASS_MODS_PROHIBITED = ResultCode.registerErrorResultCode(69, CoreMessages.INFO_RESULT_OBJECTCLASS_MODS_PROHIBITED.get(), Enum.OBJECTCLASS_MODS_PROHIBITED);
    public static final ResultCode AFFECTS_MULTIPLE_DSAS = ResultCode.registerErrorResultCode(71, CoreMessages.INFO_RESULT_AFFECTS_MULTIPLE_DSAS.get(), Enum.AFFECTS_MULTIPLE_DSAS);
    public static final ResultCode VIRTUAL_LIST_VIEW_ERROR = ResultCode.registerErrorResultCode(76, CoreMessages.INFO_RESULT_VIRTUAL_LIST_VIEW_ERROR.get(), Enum.VIRTUAL_LIST_VIEW_ERROR);
    public static final ResultCode OTHER = ResultCode.registerErrorResultCode(80, CoreMessages.INFO_RESULT_OTHER.get(), Enum.OTHER);
    public static final ResultCode CLIENT_SIDE_SERVER_DOWN = ResultCode.registerErrorResultCode(81, CoreMessages.INFO_RESULT_CLIENT_SIDE_SERVER_DOWN.get(), Enum.CLIENT_SIDE_SERVER_DOWN);
    public static final ResultCode CLIENT_SIDE_LOCAL_ERROR = ResultCode.registerErrorResultCode(82, CoreMessages.INFO_RESULT_CLIENT_SIDE_LOCAL_ERROR.get(), Enum.CLIENT_SIDE_LOCAL_ERROR);
    public static final ResultCode CLIENT_SIDE_ENCODING_ERROR = ResultCode.registerErrorResultCode(83, CoreMessages.INFO_RESULT_CLIENT_SIDE_ENCODING_ERROR.get(), Enum.CLIENT_SIDE_ENCODING_ERROR);
    public static final ResultCode CLIENT_SIDE_DECODING_ERROR = ResultCode.registerErrorResultCode(84, CoreMessages.INFO_RESULT_CLIENT_SIDE_DECODING_ERROR.get(), Enum.CLIENT_SIDE_DECODING_ERROR);
    public static final ResultCode CLIENT_SIDE_TIMEOUT = ResultCode.registerErrorResultCode(85, CoreMessages.INFO_RESULT_CLIENT_SIDE_TIMEOUT.get(), Enum.CLIENT_SIDE_TIMEOUT);
    public static final ResultCode CLIENT_SIDE_AUTH_UNKNOWN = ResultCode.registerErrorResultCode(86, CoreMessages.INFO_RESULT_CLIENT_SIDE_AUTH_UNKNOWN.get(), Enum.CLIENT_SIDE_AUTH_UNKNOWN);
    public static final ResultCode CLIENT_SIDE_FILTER_ERROR = ResultCode.registerErrorResultCode(87, CoreMessages.INFO_RESULT_CLIENT_SIDE_FILTER_ERROR.get(), Enum.CLIENT_SIDE_FILTER_ERROR);
    public static final ResultCode CLIENT_SIDE_USER_CANCELLED = ResultCode.registerErrorResultCode(88, CoreMessages.INFO_RESULT_CLIENT_SIDE_USER_CANCELLED.get(), Enum.CLIENT_SIDE_USER_CANCELLED);
    public static final ResultCode CLIENT_SIDE_PARAM_ERROR = ResultCode.registerErrorResultCode(89, CoreMessages.INFO_RESULT_CLIENT_SIDE_PARAM_ERROR.get(), Enum.CLIENT_SIDE_PARAM_ERROR);
    public static final ResultCode CLIENT_SIDE_NO_MEMORY = ResultCode.registerErrorResultCode(90, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_MEMORY.get(), Enum.CLIENT_SIDE_NO_MEMORY);
    public static final ResultCode CLIENT_SIDE_CONNECT_ERROR = ResultCode.registerErrorResultCode(91, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get(), Enum.CLIENT_SIDE_CONNECT_ERROR);
    public static final ResultCode CLIENT_SIDE_NOT_SUPPORTED = ResultCode.registerErrorResultCode(92, CoreMessages.INFO_RESULT_CLIENT_SIDE_NOT_SUPPORTED.get(), Enum.CLIENT_SIDE_NOT_SUPPORTED);
    public static final ResultCode CLIENT_SIDE_CONTROL_NOT_FOUND = ResultCode.registerErrorResultCode(93, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONTROL_NOT_FOUND.get(), Enum.CLIENT_SIDE_CONTROL_NOT_FOUND);
    public static final ResultCode CLIENT_SIDE_NO_RESULTS_RETURNED = ResultCode.registerErrorResultCode(94, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_RESULTS_RETURNED.get(), Enum.CLIENT_SIDE_NO_RESULTS_RETURNED);
    public static final ResultCode CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED = ResultCode.registerErrorResultCode(95, CoreMessages.INFO_RESULT_CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED.get(), Enum.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED);
    public static final ResultCode CLIENT_SIDE_CLIENT_LOOP = ResultCode.registerErrorResultCode(96, CoreMessages.INFO_RESULT_CLIENT_SIDE_CLIENT_LOOP.get(), Enum.CLIENT_SIDE_CLIENT_LOOP);
    public static final ResultCode CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(97, CoreMessages.INFO_RESULT_CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED.get(), Enum.CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED);
    public static final ResultCode CANCELLED = ResultCode.registerErrorResultCode(118, CoreMessages.INFO_RESULT_CANCELED.get(), Enum.CANCELLED);
    public static final ResultCode NO_SUCH_OPERATION = ResultCode.registerErrorResultCode(119, CoreMessages.INFO_RESULT_NO_SUCH_OPERATION.get(), Enum.NO_SUCH_OPERATION);
    public static final ResultCode TOO_LATE = ResultCode.registerErrorResultCode(120, CoreMessages.INFO_RESULT_TOO_LATE.get(), Enum.TOO_LATE);
    public static final ResultCode CANNOT_CANCEL = ResultCode.registerErrorResultCode(121, CoreMessages.INFO_RESULT_CANNOT_CANCEL.get(), Enum.CANNOT_CANCEL);
    public static final ResultCode ASSERTION_FAILED = ResultCode.registerErrorResultCode(122, CoreMessages.INFO_RESULT_ASSERTION_FAILED.get(), Enum.ASSERTION_FAILED);
    public static final ResultCode AUTHORIZATION_DENIED = ResultCode.registerErrorResultCode(123, CoreMessages.INFO_RESULT_AUTHORIZATION_DENIED.get(), Enum.AUTHORIZATION_DENIED);
    public static final ResultCode NO_OPERATION = ResultCode.registerSuccessResultCode(16654, CoreMessages.INFO_RESULT_NO_OPERATION.get(), Enum.NO_OPERATION);
    private static final List<ResultCode> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(new ArrayList<ResultCode>(ELEMENTS.values()));
    private final int intValue;
    private final LocalizableMessage name;
    private final boolean exceptional;
    private final Enum resultCodeEnum;

    public static ResultCode valueOf(int intValue) {
        ResultCode result = ELEMENTS.get(intValue);
        if (result == null) {
            result = new ResultCode(intValue, LocalizableMessage.raw((CharSequence)("unknown(" + intValue + ")"), (Object[])new Object[0]), true, Enum.UNKNOWN);
        }
        return result;
    }

    public static List<ResultCode> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static ResultCode registerErrorResultCode(int intValue, LocalizableMessage name, Enum resultCodeEnum) {
        ResultCode t = new ResultCode(intValue, name, true, resultCodeEnum);
        ELEMENTS.put(intValue, t);
        return t;
    }

    private static ResultCode registerSuccessResultCode(int intValue, LocalizableMessage name, Enum resultCodeEnum) {
        ResultCode t = new ResultCode(intValue, name, false, resultCodeEnum);
        ELEMENTS.put(intValue, t);
        return t;
    }

    private ResultCode(int intValue, LocalizableMessage name, boolean exceptional, Enum resultCodeEnum) {
        this.intValue = intValue;
        this.name = name;
        this.exceptional = exceptional;
        this.resultCodeEnum = resultCodeEnum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResultCode) {
            return this.intValue == ((ResultCode)obj).intValue;
        }
        return false;
    }

    public LocalizableMessage getName() {
        return this.name;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public Enum asEnum() {
        return this.resultCodeEnum;
    }

    public boolean isExceptional() {
        return this.exceptional;
    }

    public String toString() {
        return this.name.toString();
    }

    public static enum Enum {
        UNDEFINED,
        SUCCESS,
        OPERATIONS_ERROR,
        PROTOCOL_ERROR,
        TIME_LIMIT_EXCEEDED,
        SIZE_LIMIT_EXCEEDED,
        COMPARE_FALSE,
        COMPARE_TRUE,
        AUTH_METHOD_NOT_SUPPORTED,
        STRONG_AUTH_REQUIRED,
        REFERRAL,
        ADMIN_LIMIT_EXCEEDED,
        UNAVAILABLE_CRITICAL_EXTENSION,
        CONFIDENTIALITY_REQUIRED,
        SASL_BIND_IN_PROGRESS,
        NO_SUCH_ATTRIBUTE,
        UNDEFINED_ATTRIBUTE_TYPE,
        INAPPROPRIATE_MATCHING,
        CONSTRAINT_VIOLATION,
        ATTRIBUTE_OR_VALUE_EXISTS,
        INVALID_ATTRIBUTE_SYNTAX,
        NO_SUCH_OBJECT,
        ALIAS_PROBLEM,
        INVALID_DN_SYNTAX,
        ALIAS_DEREFERENCING_PROBLEM,
        INAPPROPRIATE_AUTHENTICATION,
        INVALID_CREDENTIALS,
        INSUFFICIENT_ACCESS_RIGHTS,
        BUSY,
        UNAVAILABLE,
        UNWILLING_TO_PERFORM,
        LOOP_DETECT,
        SORT_CONTROL_MISSING,
        OFFSET_RANGE_ERROR,
        NAMING_VIOLATION,
        OBJECTCLASS_VIOLATION,
        NOT_ALLOWED_ON_NONLEAF,
        NOT_ALLOWED_ON_RDN,
        ENTRY_ALREADY_EXISTS,
        OBJECTCLASS_MODS_PROHIBITED,
        AFFECTS_MULTIPLE_DSAS,
        VIRTUAL_LIST_VIEW_ERROR,
        OTHER,
        CLIENT_SIDE_SERVER_DOWN,
        CLIENT_SIDE_LOCAL_ERROR,
        CLIENT_SIDE_ENCODING_ERROR,
        CLIENT_SIDE_DECODING_ERROR,
        CLIENT_SIDE_TIMEOUT,
        CLIENT_SIDE_AUTH_UNKNOWN,
        CLIENT_SIDE_FILTER_ERROR,
        CLIENT_SIDE_USER_CANCELLED,
        CLIENT_SIDE_PARAM_ERROR,
        CLIENT_SIDE_NO_MEMORY,
        CLIENT_SIDE_CONNECT_ERROR,
        CLIENT_SIDE_NOT_SUPPORTED,
        CLIENT_SIDE_CONTROL_NOT_FOUND,
        CLIENT_SIDE_NO_RESULTS_RETURNED,
        CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED,
        CLIENT_SIDE_CLIENT_LOOP,
        CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED,
        CANCELLED,
        NO_SUCH_OPERATION,
        TOO_LATE,
        CANNOT_CANCEL,
        ASSERTION_FAILED,
        AUTHORIZATION_DENIED,
        NO_OPERATION,
        UNKNOWN;

    }
}

