/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

public final class LDAPUrl {
    private final boolean isSecured;
    private final String host;
    private final int port;
    private final DN name;
    private final SearchScope scope;
    private final Filter filter;
    private final List<String> attributes;
    private final String urlString;
    private String normalizedURL;
    private static final String DEFAULT_URL_SCHEME = "ldap";
    private static final String SSL_URL_SCHEME = "ldaps";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 389;
    private static final int DEFAULT_SSL_PORT = 636;
    private static final Filter DEFAULT_FILTER;
    private static final SearchScope DEFAULT_SCOPE;
    private static final DN DEFAULT_DN;
    private static final char PERCENT_ENCODING_CHAR = '%';
    private static final char QUESTION_CHAR = '?';
    private static final char SLASH_CHAR = '/';
    private static final char COMMA_CHAR = ',';
    private static final char COLON_CHAR = ':';
    private static final Set<Character> VALID_CHARS;

    public static LDAPUrl valueOf(String url) {
        return LDAPUrl.valueOf(url, Schema.getDefaultSchema());
    }

    public static LDAPUrl valueOf(String url, Schema schema) {
        Reject.ifNull((Object[])new Object[]{url, schema});
        return new LDAPUrl(url, schema);
    }

    private static int decodeHex(String url, int index, char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        LocalizableMessage msg = CoreMessages.ERR_LDAPURL_INVALID_HEX_BYTE.get((Object)url, (Object)index);
        throw new LocalizedIllegalArgumentException(msg);
    }

    private static void percentDecoder(String urlString, int index, String s, StringBuilder decoded) {
        Reject.ifNull((Object)s);
        Reject.ifNull((Object)decoded);
        decoded.append(s);
        int srcPos = 0;
        int dstPos = 0;
        while (srcPos < decoded.length()) {
            if (decoded.charAt(srcPos) != '%') {
                if (srcPos != dstPos) {
                    decoded.setCharAt(dstPos, decoded.charAt(srcPos));
                }
                ++srcPos;
                ++dstPos;
                continue;
            }
            int i = LDAPUrl.decodeHex(urlString, index + srcPos + 1, decoded.charAt(srcPos + 1)) << 4;
            int j = LDAPUrl.decodeHex(urlString, index + srcPos + 2, decoded.charAt(srcPos + 2));
            decoded.setCharAt(dstPos, (char)(i | j));
            ++dstPos;
            srcPos += 3;
        }
        decoded.setLength(dstPos);
    }

    private static void percentEncoder(String urlElement, StringBuilder encodedBuffer) {
        Reject.ifNull((Object)urlElement);
        for (int count = 0; count < urlElement.length(); ++count) {
            char c = urlElement.charAt(count);
            if (VALID_CHARS.contains(Character.valueOf(c))) {
                encodedBuffer.append(c);
                continue;
            }
            encodedBuffer.append('%');
            encodedBuffer.append(Integer.toHexString(c));
        }
    }

    public LDAPUrl(boolean isSecured, String host, Integer port, DN name) {
        this(isSecured, host, port, name, DEFAULT_SCOPE, DEFAULT_FILTER, new String[0]);
    }

    public LDAPUrl(boolean isSecured, String host, Integer port, DN name, SearchScope scope, Filter filter, String ... attributes) {
        StringBuilder urlBuffer = new StringBuilder();
        this.isSecured = isSecured;
        if (this.isSecured) {
            urlBuffer.append(SSL_URL_SCHEME);
        } else {
            urlBuffer.append(DEFAULT_URL_SCHEME);
        }
        urlBuffer.append("://");
        if (host == null) {
            this.host = DEFAULT_HOST;
        } else {
            this.host = host;
            urlBuffer.append(this.host);
        }
        int listenPort = 389;
        if (port == null) {
            listenPort = isSecured ? 636 : 389;
        } else {
            listenPort = port;
            if (listenPort < 1 || listenPort > 65535) {
                LocalizableMessage msg = CoreMessages.ERR_LDAPURL_BAD_PORT.get((Object)listenPort);
                throw new LocalizedIllegalArgumentException(msg);
            }
            urlBuffer.append(':');
            urlBuffer.append(listenPort);
        }
        this.port = listenPort;
        urlBuffer.append('/');
        if (name != null) {
            this.name = name;
            LDAPUrl.percentEncoder(name.toString(), urlBuffer);
        } else {
            this.name = DEFAULT_DN;
        }
        urlBuffer.append('?');
        switch (attributes.length) {
            case 0: {
                this.attributes = Collections.emptyList();
                break;
            }
            case 1: {
                this.attributes = Collections.singletonList(attributes[0]);
                urlBuffer.append(attributes[0]);
                break;
            }
            default: {
                this.attributes = Collections.unmodifiableList(Arrays.asList(attributes));
                urlBuffer.append(attributes[0]);
                for (int i = 1; i < attributes.length; ++i) {
                    urlBuffer.append(',');
                    urlBuffer.append(attributes[i]);
                }
            }
        }
        urlBuffer.append('?');
        if (scope != null) {
            this.scope = scope;
            urlBuffer.append(scope);
        } else {
            this.scope = DEFAULT_SCOPE;
        }
        urlBuffer.append('?');
        if (filter != null) {
            this.filter = filter;
            urlBuffer.append(this.filter);
        } else {
            this.filter = DEFAULT_FILTER;
        }
        this.urlString = urlBuffer.toString();
    }

    private LDAPUrl(String urlString, Schema schema) {
        this.urlString = urlString;
        int schemeIdx = urlString.indexOf("://");
        if (schemeIdx < 0) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_LDAPURL_NO_SCHEME.get((Object)urlString));
        }
        String scheme = StaticUtils.toLowerCase(urlString.substring(0, schemeIdx));
        if (DEFAULT_URL_SCHEME.equalsIgnoreCase(scheme)) {
            this.isSecured = false;
        } else if (SSL_URL_SCHEME.equalsIgnoreCase(scheme)) {
            this.isSecured = true;
        } else {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_LDAPURL_BAD_SCHEME.get((Object)urlString, (Object)scheme));
        }
        int urlLength = urlString.length();
        int hostPortIdx = urlString.indexOf(47, schemeIdx + 3);
        StringBuilder builder = new StringBuilder();
        if (hostPortIdx < 0) {
            if (urlLength > schemeIdx + 3) {
                String hostAndPort = urlString.substring(schemeIdx + 3, urlLength);
                this.port = this.parseHostPort(urlString, hostAndPort, builder);
                this.host = builder.toString();
                builder.setLength(0);
            } else {
                this.host = DEFAULT_HOST;
                this.port = this.isSecured ? 636 : 389;
            }
            this.name = DEFAULT_DN;
            this.scope = DEFAULT_SCOPE;
            this.filter = DEFAULT_FILTER;
            this.attributes = Collections.emptyList();
            return;
        }
        String hostAndPort = urlString.substring(schemeIdx + 3, hostPortIdx);
        this.port = this.parseHostPort(urlString, hostAndPort, builder);
        this.host = builder.toString();
        builder.setLength(0);
        DN parsedDN = null;
        int dnIdx = urlString.indexOf(63, hostPortIdx + 1);
        if (dnIdx < 0) {
            String dnStr = urlString.substring(hostPortIdx + 1, urlLength);
            LDAPUrl.percentDecoder(urlString, hostPortIdx + 1, dnStr, builder);
            try {
                parsedDN = DN.valueOf(builder.toString(), schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage msg = CoreMessages.ERR_LDAPURL_INVALID_DN.get((Object)urlString, (Object)e.getMessageObject());
                throw new LocalizedIllegalArgumentException(msg);
            }
            builder.setLength(0);
            this.name = parsedDN;
            this.scope = DEFAULT_SCOPE;
            this.filter = DEFAULT_FILTER;
            this.attributes = Collections.emptyList();
            return;
        }
        String dnStr = urlString.substring(hostPortIdx + 1, dnIdx);
        if (dnStr.length() == 0) {
            parsedDN = DEFAULT_DN;
        } else {
            LDAPUrl.percentDecoder(urlString, hostPortIdx + 1, dnStr, builder);
            try {
                parsedDN = DN.valueOf(builder.toString(), schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage msg = CoreMessages.ERR_LDAPURL_INVALID_DN.get((Object)urlString, (Object)e.getMessageObject());
                throw new LocalizedIllegalArgumentException(msg);
            }
            builder.setLength(0);
        }
        this.name = parsedDN;
        int attrIdx = urlString.indexOf(63, dnIdx + 1);
        if (attrIdx < 0) {
            this.attributes = Collections.emptyList();
            this.scope = DEFAULT_SCOPE;
            this.filter = DEFAULT_FILTER;
            return;
        }
        this.attributes = this.parseAttributes(urlString.substring(dnIdx + 1, attrIdx));
        int scopeIdx = urlString.indexOf(63, attrIdx + 1);
        if (scopeIdx < 0) {
            this.scope = DEFAULT_SCOPE;
            this.filter = DEFAULT_FILTER;
            return;
        }
        this.scope = this.parseScope(urlString.substring(attrIdx + 1, scopeIdx));
        String parsedFilter = urlString.substring(scopeIdx + 1, urlLength);
        if (parsedFilter.length() > 0) {
            builder.setLength(0);
            LDAPUrl.percentDecoder(urlString, scopeIdx + 1, parsedFilter, builder);
            try {
                this.filter = Filter.valueOf(builder.toString());
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage msg = CoreMessages.ERR_LDAPURL_INVALID_FILTER.get((Object)urlString, (Object)e.getMessageObject());
                throw new LocalizedIllegalArgumentException(msg);
            }
        } else {
            this.filter = DEFAULT_FILTER;
        }
    }

    private List<String> parseAttributes(String attrDesc) {
        StringTokenizer token = new StringTokenizer(attrDesc, String.valueOf(','));
        ArrayList<String> parsedAttrs = new ArrayList<String>(token.countTokens());
        while (token.hasMoreElements()) {
            parsedAttrs.add(token.nextToken());
        }
        return Collections.unmodifiableList(parsedAttrs);
    }

    private SearchScope parseScope(String scopeDef) {
        String scope = StaticUtils.toLowerCase(scopeDef);
        for (SearchScope sscope : SearchScope.values()) {
            if (!sscope.toString().equals(scope)) continue;
            return sscope;
        }
        return SearchScope.BASE_OBJECT;
    }

    public SearchRequest asSearchRequest() {
        SearchRequest request = Requests.newSearchRequest(this.name, this.scope, this.filter, new String[0]);
        for (String a : this.attributes) {
            request.addAttribute(a);
        }
        return request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LDAPUrl) {
            String s1 = this.toNormalizedString();
            String s2 = ((LDAPUrl)o).toNormalizedString();
            return s1.equals(s2);
        }
        return false;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public DN getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public int hashCode() {
        String s = this.toNormalizedString();
        return s.hashCode();
    }

    public boolean isSecure() {
        return this.isSecured;
    }

    public String toString() {
        return this.urlString;
    }

    private int parseHostPort(String urlString, String hostAndPort, StringBuilder host) {
        int urlPort;
        Reject.ifNull((Object)urlString);
        Reject.ifNull((Object)hostAndPort);
        Reject.ifNull((Object)host);
        int n = urlPort = this.isSecured ? 636 : 389;
        if (hostAndPort.length() == 0) {
            host.append(DEFAULT_HOST);
            return urlPort;
        }
        int colonIdx = hostAndPort.indexOf(58);
        if (colonIdx < 0) {
            host.append(hostAndPort);
            return urlPort;
        }
        String s = hostAndPort.substring(0, colonIdx);
        if (s.length() == 0) {
            host.append(DEFAULT_HOST);
        } else {
            host.append(s);
        }
        s = hostAndPort.substring(colonIdx + 1, hostAndPort.length());
        try {
            urlPort = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_LDAPURL_CANNOT_DECODE_PORT.get((Object)urlString, (Object)s));
        }
        if (urlPort < 1 || urlPort > 65535) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_LDAPURL_INVALID_PORT.get((Object)urlString, (Object)urlPort));
        }
        return urlPort;
    }

    private String toNormalizedString() {
        if (this.normalizedURL == null) {
            StringBuilder builder = new StringBuilder();
            if (this.isSecured) {
                builder.append(SSL_URL_SCHEME);
            } else {
                builder.append(DEFAULT_URL_SCHEME);
            }
            builder.append("://");
            builder.append(this.host);
            builder.append(':');
            builder.append(this.port);
            builder.append('/');
            LDAPUrl.percentEncoder(this.name.toString(), builder);
            builder.append('?');
            int sz = this.attributes.size();
            for (int i = 0; i < sz; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(this.attributes.get(i));
            }
            builder.append('?');
            builder.append(this.scope);
            builder.append('?');
            LDAPUrl.percentEncoder(this.filter.toString(), builder);
            this.normalizedURL = builder.toString();
        }
        return this.normalizedURL;
    }

    static {
        char c;
        char[] delims;
        DEFAULT_FILTER = Filter.objectClassPresent();
        DEFAULT_SCOPE = SearchScope.BASE_OBJECT;
        DEFAULT_DN = DN.rootDN();
        VALID_CHARS = new HashSet<Character>();
        for (char c2 : delims = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '.', '-', '_', '~'}) {
            VALID_CHARS.add(Character.valueOf(c2));
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            VALID_CHARS.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            VALID_CHARS.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            VALID_CHARS.add(Character.valueOf(c));
        }
    }
}

