/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.forgerock.opendj.ldap.AbstractEntry;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;

public final class AttributeFilter {
    private boolean includeAllOperationalAttributes;
    private boolean includeAllUserAttributes;
    private boolean typesOnly;
    private Map<AttributeDescription, AttributeDescription> requestedAttributes = Collections.emptyMap();

    public AttributeFilter() {
        this.includeAllUserAttributes = true;
    }

    public AttributeFilter(Collection<String> attributeDescriptions) {
        this(attributeDescriptions, Schema.getDefaultSchema());
    }

    public AttributeFilter(Collection<String> attributeDescriptions, Schema schema) {
        if (attributeDescriptions == null || attributeDescriptions.isEmpty()) {
            this.includeAllUserAttributes = true;
        } else {
            for (String attribute : attributeDescriptions) {
                this.includeAttribute(attribute, schema);
            }
        }
    }

    public AttributeFilter(String ... attributeDescriptions) {
        this(Arrays.asList(attributeDescriptions));
    }

    public Entry filteredCopyOf(Entry entry) {
        return new LinkedHashMapEntry(this.filteredViewOf(entry));
    }

    public Entry filteredViewOf(final Entry entry) {
        return new AbstractEntry(){

            @Override
            public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Entry clearAttributes() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterable<Attribute> getAllAttributes() {
                return new Iterable<Attribute>(){
                    private boolean hasNextMustIterate = true;
                    private final Iterator<Attribute> iterator;
                    private Attribute next;
                    {
                        this.iterator = entry.getAllAttributes().iterator();
                        this.next = null;
                    }

                    @Override
                    public Iterator<Attribute> iterator() {
                        return new Iterator<Attribute>(){

                            @Override
                            public boolean hasNext() {
                                if (hasNextMustIterate) {
                                    hasNextMustIterate = false;
                                    while (iterator.hasNext()) {
                                        Attribute attribute = (Attribute)iterator.next();
                                        AttributeDescription ad = attribute.getAttributeDescription();
                                        AttributeType at = ad.getAttributeType();
                                        AttributeDescription requestedAd = (AttributeDescription)AttributeFilter.this.requestedAttributes.get(ad);
                                        if (requestedAd != null) {
                                            next = Attributes.renameAttribute(attribute, requestedAd);
                                            return true;
                                        }
                                        if ((!at.isOperational() || !AttributeFilter.this.includeAllOperationalAttributes) && (at.isOperational() || !AttributeFilter.this.includeAllUserAttributes)) continue;
                                        next = attribute;
                                        return true;
                                    }
                                    next = null;
                                    return false;
                                }
                                return next != null;
                            }

                            @Override
                            public Attribute next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                hasNextMustIterate = true;
                                return AttributeFilter.this.filterAttribute(next);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    public String toString() {
                        return Iterables.toString(this);
                    }
                };
            }

            @Override
            public Attribute getAttribute(AttributeDescription attributeDescription) {
                Attribute attribute = entry.getAttribute(attributeDescription);
                if (attribute != null) {
                    AttributeDescription ad = attribute.getAttributeDescription();
                    AttributeType at = ad.getAttributeType();
                    AttributeDescription requestedAd = (AttributeDescription)AttributeFilter.this.requestedAttributes.get(ad);
                    if (requestedAd != null) {
                        return AttributeFilter.this.filterAttribute(Attributes.renameAttribute(attribute, requestedAd));
                    }
                    if (at.isOperational() && AttributeFilter.this.includeAllOperationalAttributes || !at.isOperational() && AttributeFilter.this.includeAllUserAttributes) {
                        return AttributeFilter.this.filterAttribute(attribute);
                    }
                }
                return null;
            }

            @Override
            public int getAttributeCount() {
                return Iterables.size(this.getAllAttributes());
            }

            @Override
            public DN getName() {
                return entry.getName();
            }

            @Override
            public Entry setName(DN dn) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public AttributeFilter includeAllOperationalAttributes(boolean include) {
        this.includeAllOperationalAttributes = include;
        return this;
    }

    public AttributeFilter includeAllUserAttributes(boolean include) {
        this.includeAllUserAttributes = include;
        return this;
    }

    public AttributeFilter includeAttribute(AttributeDescription attributeDescription) {
        this.allocatedRequestedAttributes();
        this.requestedAttributes.put(attributeDescription, attributeDescription);
        return this;
    }

    public AttributeFilter includeAttribute(String attributeDescription) {
        return this.includeAttribute(attributeDescription, Schema.getDefaultSchema());
    }

    public AttributeFilter includeAttribute(String attributeDescription, Schema schema) {
        if (attributeDescription.equals("*")) {
            this.includeAllUserAttributes = true;
        } else if (attributeDescription.equals("+")) {
            this.includeAllOperationalAttributes = true;
        } else if (!attributeDescription.equals("1.1")) {
            if (attributeDescription.startsWith("@") && attributeDescription.length() > 1) {
                String objectClassName = attributeDescription.substring(1);
                ObjectClass objectClass = schema.getObjectClass(objectClassName);
                if (objectClass != null) {
                    AttributeDescription ad;
                    this.allocatedRequestedAttributes();
                    for (AttributeType at : objectClass.getRequiredAttributes()) {
                        ad = AttributeDescription.create(at);
                        this.requestedAttributes.put(ad, ad);
                    }
                    for (AttributeType at : objectClass.getOptionalAttributes()) {
                        ad = AttributeDescription.create(at);
                        this.requestedAttributes.put(ad, ad);
                    }
                }
            } else {
                this.allocatedRequestedAttributes();
                AttributeDescription ad = AttributeDescription.valueOf(attributeDescription, schema);
                this.requestedAttributes.put(ad, ad);
            }
        }
        return this;
    }

    public String toString() {
        if (!this.includeAllOperationalAttributes && !this.includeAllUserAttributes && this.requestedAttributes.isEmpty()) {
            return "1.1";
        }
        StringBuilder builder = new StringBuilder();
        if (this.includeAllUserAttributes) {
            builder.append('*');
        }
        if (this.includeAllOperationalAttributes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('+');
        }
        for (AttributeDescription requestedAttribute : this.requestedAttributes.keySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(requestedAttribute);
        }
        return builder.toString();
    }

    public AttributeFilter typesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
        return this;
    }

    private void allocatedRequestedAttributes() {
        if (this.requestedAttributes.isEmpty()) {
            this.requestedAttributes = new HashMap<AttributeDescription, AttributeDescription>();
        }
    }

    private Attribute filterAttribute(Attribute attribute) {
        return this.typesOnly ? Attributes.emptyAttribute(attribute.getAttributeDescription()) : attribute;
    }
}

