/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import java.io.IOException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResult;
import org.forgerock.util.Reject;

public final class GetConnectionIDExtendedResult
extends AbstractExtendedResult<GetConnectionIDExtendedResult> {
    private int connectionID = -1;

    public static GetConnectionIDExtendedResult newResult(ResultCode resultCode) {
        Reject.ifNull((Object)resultCode);
        return new GetConnectionIDExtendedResult(resultCode);
    }

    private GetConnectionIDExtendedResult(ResultCode resultCode) {
        super(resultCode);
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.6.2";
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder(6);
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeInteger(this.connectionID);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public GetConnectionIDExtendedResult setConnectionID(int connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetConnectionIDExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        builder.append(", responseName=");
        builder.append(this.getOID());
        builder.append(", connectionID=");
        builder.append(this.connectionID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

