/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Persistit;
import com.persistit.Transaction;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.Version;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.RollbackException;
import com.persistit.exception.TimeoutException;
import com.persistit.exception.WWRetryException;
import java.util.ArrayList;

public class TimelyResource<V extends Version> {
    private final Persistit _persistit;
    private volatile Entry _first;

    public TimelyResource(Persistit persistit) {
        this._persistit = persistit;
        this._persistit.addTimelyResource(this);
    }

    private long tss2v(Transaction txn) {
        if (txn == null || !txn.isActive()) {
            return TransactionIndex.tss2vh(this._persistit.getTimestampAllocator().updateTimestamp(), 0);
        }
        return TransactionIndex.tss2vh(txn.getStartTimestamp(), txn.getStep());
    }

    public synchronized void delete() throws RollbackException, PersistitException {
        if (this._first == null) {
            throw new IllegalStateException("There is no resource to delete");
        }
        if (!this._first.isDeleted()) {
            Transaction txn = this._persistit.getTransaction();
            long version = this.tss2v(txn);
            if (version == this._first.getVersion()) {
                this._first.setDeleted();
            } else {
                Version resource = this._first.getResource();
                Entry entry = new Entry(this, version, resource);
                entry.setDeleted();
                this.addVersion(entry, txn);
            }
        }
    }

    public void addVersion(V resource, Transaction txn) throws PersistitInterruptedException, RollbackException {
        if (resource == null) {
            throw new NullPointerException("Null resource");
        }
        this.addVersion(new Entry(this, this.tss2v(txn), (Version)resource), txn);
    }

    public V getVersion() throws TimeoutException, PersistitInterruptedException {
        Entry first = this._first;
        if (first != null && first.getVersion() == 0L) {
            return (V)first.getResource();
        }
        Transaction txn = this._persistit.getTransaction();
        return this.getVersion(this.tss2v(txn));
    }

    public V getVersion(Version.VersionCreator<V> creator) throws PersistitException, RollbackException {
        Entry first = this._first;
        if (first != null && first.getVersion() == 0L) {
            return (V)first.getResource();
        }
        Transaction txn = this._persistit.getTransaction();
        Object version = this.getVersion(this.tss2v(txn));
        if (version == null) {
            version = (Version)creator.createVersion(this);
            this.addVersion(version, txn);
        }
        return version;
    }

    public boolean isEmpty() throws TimeoutException, PersistitInterruptedException {
        Entry first = this._first;
        if (first == null) {
            return true;
        }
        if (first.getVersion() == 0L) {
            return false;
        }
        first = this.getEntry(this.tss2v(this._persistit.getTransaction()));
        if (first == null) {
            return true;
        }
        return first.isDeleted();
    }

    public boolean isTransactionPrivate(boolean byStep) throws TimeoutException, PersistitInterruptedException {
        Entry entry = this._first;
        if (entry != null && entry.getVersion() == 0L) {
            return false;
        }
        Transaction txn = this._persistit.getTransaction();
        long versionHandle = this.tss2v(txn);
        entry = this.getEntry(versionHandle);
        if (entry == null) {
            return true;
        }
        if (byStep) {
            return entry.getVersion() == versionHandle;
        }
        return TransactionIndex.vh2ts(entry.getVersion()) == TransactionIndex.vh2ts(versionHandle);
    }

    int getVersionCount() {
        int count = 0;
        Entry e = this._first;
        while (e != null) {
            ++count;
            e = e._previous;
        }
        return count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimelyResource(");
        boolean first = true;
        Entry entry = this._first;
        while (entry != null) {
            if (sb.length() > 1000) {
                sb.append("...");
                break;
            }
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(entry);
            entry = entry.getPrevious();
        }
        sb.append(')');
        return sb.toString();
    }

    synchronized void setPrimordial() {
        if (this._first == null || this._first.getPrevious() != null) {
            throw new IllegalStateException("Cannot be made primordial: " + this);
        }
        this._first.setPrimordial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prune() throws TimeoutException, PersistitException {
        ArrayList<Entry> entriesToPrune = new ArrayList<Entry>();
        Version.PrunableVersion versionToVacate = null;
        TransactionIndex ti = this._persistit.getTransactionIndex();
        TimelyResource timelyResource = this;
        synchronized (timelyResource) {
            try {
                Entry newer = null;
                Entry latest = null;
                boolean isPrimordial = true;
                long lastCommit = Long.MAX_VALUE;
                Entry entry = this._first;
                while (entry != null) {
                    boolean keepIt = false;
                    long versionHandle = entry.getVersion();
                    long tc = ti.commitStatus(versionHandle, Long.MAX_VALUE, 0);
                    if (tc >= 0L) {
                        if (tc == Long.MAX_VALUE) {
                            keepIt = true;
                            isPrimordial = false;
                        } else {
                            boolean hasConcurrent = ti.hasConcurrentTransaction(tc, lastCommit);
                            if (latest == null || hasConcurrent) {
                                keepIt = true;
                                if (latest == null) {
                                    latest = entry;
                                }
                            }
                            if (keepIt && ti.hasConcurrentTransaction(0L, tc)) {
                                isPrimordial = false;
                            }
                        }
                        lastCommit = tc;
                    } else assert (tc == Long.MIN_VALUE);
                    if (keepIt) {
                        newer = entry;
                    } else {
                        if (tc == Long.MIN_VALUE ^ entry.isDeleted()) {
                            entriesToPrune.add(entry);
                        }
                        if (newer == null) {
                            this._first = entry.getPrevious();
                        } else {
                            newer.setPrevious(entry.getPrevious());
                        }
                    }
                    entry = entry.getPrevious();
                }
                if (isPrimordial && this._first != null) {
                    assert (this._first.getPrevious() == null);
                    if (this._first.isDeleted()) {
                        Version version = this._first.getResource();
                        if (version instanceof Version.PrunableVersion) {
                            versionToVacate = (Version.PrunableVersion)version;
                        }
                        entriesToPrune.add(this._first);
                        this._first = null;
                    } else {
                        this._first.setPrimordial();
                    }
                }
            }
            catch (InterruptedException ie) {
                throw new PersistitInterruptedException(ie);
            }
        }
        for (Entry e : entriesToPrune) {
            if (versionToVacate != null) {
                versionToVacate.vacate();
            }
            e.prune();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVersion(Entry entry, Transaction txn) throws PersistitInterruptedException, RollbackException {
        TransactionIndex ti = this._persistit.getTransactionIndex();
        while (true) {
            try {
                TimelyResource timelyResource = this;
                synchronized (timelyResource) {
                    if (this._first != null) {
                        if (this._first.getVersion() > entry.getVersion()) {
                            throw new RollbackException();
                        }
                        if (txn.isActive()) {
                            Entry e = this._first;
                            while (e != null) {
                                long version = e.getVersion();
                                long depends = ti.wwDependency(version, txn.getTransactionStatus(), 0L);
                                if (depends == -9223372036854775807L) {
                                    throw new WWRetryException(version);
                                }
                                if (depends != 0L && depends != Long.MIN_VALUE) {
                                    throw new RollbackException();
                                }
                                e = e.getPrevious();
                            }
                        }
                    }
                    entry.setPrevious(this._first);
                    this._first = entry;
                }
            }
            catch (WWRetryException re) {
                try {
                    long depends;
                    if ((depends = this._persistit.getTransactionIndex().wwDependency(re.getVersionHandle(), txn.getTransactionStatus(), 60000L)) == 0L || depends == Long.MIN_VALUE) continue;
                    throw new RollbackException();
                }
                catch (InterruptedException ie) {
                    throw new PersistitInterruptedException(ie);
                }
            }
            catch (InterruptedException ie) {
                throw new PersistitInterruptedException(ie);
            }
            break;
        }
    }

    V getVersion(long version) throws TimeoutException, PersistitInterruptedException {
        Entry e = this.getEntry(version);
        return (V)(e == null ? null : e.getResource());
    }

    Entry getEntry(long version) throws TimeoutException, PersistitInterruptedException {
        TransactionIndex ti = this._persistit.getTransactionIndex();
        try {
            Entry e = this._first;
            while (e != null) {
                long commitTs = ti.commitStatus(e.getVersion(), TransactionIndex.vh2ts(version), TransactionIndex.vh2step(version));
                if (commitTs >= 0L && commitTs != Long.MAX_VALUE) {
                    if (e.isDeleted()) {
                        return null;
                    }
                    return e;
                }
                e = e._previous;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new PersistitInterruptedException(e);
        }
    }

    private class Entry {
        private long _version;
        private V _resource;
        private volatile boolean _deleted;
        private volatile Entry _previous;
        final /* synthetic */ TimelyResource this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Entry(long resource, V v) {
            void versionHandle;
            this.this$0 = (TimelyResource)l;
            this._version = versionHandle;
            this._resource = resource;
        }

        private V getResource() {
            return this._resource;
        }

        private void setResource(V resource) {
            this._resource = resource;
        }

        private Entry getPrevious() {
            return this._previous;
        }

        private void setPrevious(Entry tr) {
            this._previous = tr;
        }

        private long getVersion() {
            return this._version;
        }

        private void setPrimordial() {
            this._version = 0L;
        }

        private void setDeleted() {
            this._deleted = true;
        }

        private boolean isDeleted() {
            return this._deleted;
        }

        private boolean prune() throws PersistitException {
            if (this._resource instanceof Version.PrunableVersion) {
                return ((Version.PrunableVersion)this._resource).prune();
            }
            return true;
        }

        public String toString() {
            String tcStatus;
            try {
                long tc = this.this$0._persistit.getTransactionIndex().commitStatus(this._version, Long.MAX_VALUE, 0);
                tcStatus = TransactionStatus.tcString(tc);
            }
            catch (Exception e) {
                tcStatus = e.toString();
            }
            return String.format("(ts=%s tc=%s)->%s%s", TransactionStatus.versionString(this._version), tcStatus, this._resource, this._previous != null ? "*" : "");
        }
    }
}

