/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n.slf4j;

import java.util.Locale;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalizedLoggerFactory {
    private final Locale locale;

    public static LocalizedLoggerFactory getInstance() {
        return new LocalizedLoggerFactory(Locale.getDefault());
    }

    public static LocalizedLoggerFactory getInstance(Locale locale) {
        return new LocalizedLoggerFactory(locale);
    }

    private LocalizedLoggerFactory(Locale locale) {
        this.locale = locale;
    }

    public LocalizedLogger getLocalizedLogger(Class<?> clazz) {
        Logger logger = LoggerFactory.getLogger(clazz);
        return new LocalizedLogger(logger, this.locale);
    }

    public LocalizedLogger getLocalizedLogger(Logger logger) {
        return new LocalizedLogger(logger, this.locale);
    }

    public LocalizedLogger getLocalizedLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new LocalizedLogger(logger, this.locale);
    }
}

