/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.Config;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestState
implements Closeable {
    private final Map<DN, CachedRead> cachedReads = new LinkedHashMap<DN, CachedRead>(){
        private static final int MAX_CACHED_ENTRIES = 32;

        @Override
        protected boolean removeEldestEntry(Map.Entry<DN, CachedRead> eldest) {
            return this.size() > 32;
        }
    };
    private final Config config;
    private final Context context;
    private Connection connection;
    private Control proxiedAuthzControl;

    RequestState(Config config, Context context) {
        this.config = config;
        this.context = context;
        this.connection = config.getAuthorizationPolicy() != AuthorizationPolicy.NONE && context.containsContext(AuthenticatedConnectionContext.class) ? this.wrap(((AuthenticatedConnectionContext)context.asContext(AuthenticatedConnectionContext.class)).getConnection()) : null;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    Config getConfig() {
        return this.config;
    }

    Context getContext() {
        return this.context;
    }

    Promise<Connection, ResourceException> getConnection() {
        if (this.connection == null && this.config.getAuthorizationPolicy() == AuthorizationPolicy.PROXY) {
            if (this.context.containsContext(SecurityContext.class)) {
                try {
                    SecurityContext securityContext = (SecurityContext)this.context.asContext(SecurityContext.class);
                    String authzId = this.config.getProxiedAuthorizationTemplate().formatAsAuthzId(securityContext.getAuthorization(), this.config.schema());
                    this.proxiedAuthzControl = ProxiedAuthV2RequestControl.newControl((String)authzId);
                }
                catch (ResourceException e) {
                    return Promises.newExceptionPromise((Exception)((Object)e));
                }
            } else {
                return Promises.newExceptionPromise((Exception)new InternalServerErrorException(Utils.i18n("The request could not be authorized because it did not contain a security context", new Object[0])));
            }
        }
        if (this.connection != null) {
            return Promises.newResultPromise((Object)this.connection);
        }
        if (this.config.connectionFactory() != null) {
            final PromiseImpl promise = PromiseImpl.create();
            this.config.connectionFactory().getConnectionAsync().thenOnResult((ResultHandler)new ResultHandler<Connection>(){

                public final void handleResult(Connection result) {
                    RequestState.this.connection = RequestState.this.wrap(result);
                    promise.handleResult((Object)RequestState.this.connection);
                }
            }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                public final void handleException(LdapException exception) {
                    promise.handleException((Exception)((Object)Rest2LDAP.asResourceException(exception)));
                }
            });
            return promise;
        }
        return Promises.newExceptionPromise((Exception)new InternalServerErrorException(Utils.i18n("The request could not be processed because there was no LDAP connection available for use", new Object[0])));
    }

    private Connection wrap(final Connection connection) {
        return new AbstractAsynchronousConnection(){

            public LdapPromise<Void> abandonAsync(AbandonRequest request) {
                return connection.abandonAsync(request);
            }

            public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                return connection.addAsync(this.withControls(request), intermediateResponseHandler);
            }

            public void addConnectionEventListener(ConnectionEventListener listener) {
                connection.addConnectionEventListener(listener);
            }

            public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                this.evictAll();
                return connection.bindAsync(request, intermediateResponseHandler);
            }

            public void close() {
                connection.close();
            }

            public void close(UnbindRequest request, String reason) {
                connection.close(request, reason);
            }

            public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                return connection.compareAsync(this.withControls(request), intermediateResponseHandler);
            }

            public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                this.evict(request.getName());
                return connection.deleteAsync(this.withControls(request), intermediateResponseHandler);
            }

            public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
                this.evictAll();
                return connection.extendedRequestAsync(this.withControls((R)request), intermediateResponseHandler);
            }

            public boolean isClosed() {
                return connection.isClosed();
            }

            public boolean isValid() {
                return connection.isValid();
            }

            public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                this.evict(request.getName());
                return connection.modifyAsync(this.withControls(request), intermediateResponseHandler);
            }

            public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
                this.evictAll();
                return connection.modifyDNAsync(this.withControls(request), intermediateResponseHandler);
            }

            public void removeConnectionEventListener(ConnectionEventListener listener) {
                connection.removeConnectionEventListener(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
                CachedRead cachedRead;
                if (!request.getScope().equals((Object)SearchScope.BASE_OBJECT) || intermediateResponseHandler != null) {
                    return connection.searchAsync(this.withControls(request), intermediateResponseHandler, entryHandler);
                }
                Map map = RequestState.this.cachedReads;
                synchronized (map) {
                    cachedRead = (CachedRead)RequestState.this.cachedReads.get(request.getName());
                }
                if (cachedRead != null && cachedRead.isMatchingRead(request)) {
                    cachedRead.addResultHandler(entryHandler);
                    return cachedRead.getPromise();
                }
                CachedRead pendingCachedRead = new CachedRead(request, entryHandler);
                Map map2 = RequestState.this.cachedReads;
                synchronized (map2) {
                    RequestState.this.cachedReads.put(request.getName(), pendingCachedRead);
                }
                LdapPromise promise = connection.searchAsync(this.withControls(request), intermediateResponseHandler, (SearchResultHandler)pendingCachedRead).thenOnResult((ResultHandler)pendingCachedRead).thenOnException((ExceptionHandler)pendingCachedRead);
                pendingCachedRead.setPromise((LdapPromise<Result>)promise);
                return promise;
            }

            public String toString() {
                return connection.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void evict(DN name) {
                Map map = RequestState.this.cachedReads;
                synchronized (map) {
                    RequestState.this.cachedReads.remove(name);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void evictAll() {
                Map map = RequestState.this.cachedReads;
                synchronized (map) {
                    RequestState.this.cachedReads.clear();
                }
            }

            private <R extends Request> R withControls(R request) {
                if (RequestState.this.proxiedAuthzControl != null) {
                    request.addControl(RequestState.this.proxiedAuthzControl);
                }
                return request;
            }
        };
    }

    private static final class CachedRead
    implements SearchResultHandler,
    LdapResultHandler<Result> {
        private SearchResultEntry cachedEntry;
        private final String cachedFilterString;
        private LdapPromise<Result> cachedPromise;
        private final CountDownLatch cachedPromiseLatch = new CountDownLatch(1);
        private final SearchRequest cachedRequest;
        private volatile Result cachedResult;
        private final ConcurrentLinkedQueue<SearchResultHandler> waitingResultHandlers = new ConcurrentLinkedQueue();

        CachedRead(SearchRequest request, SearchResultHandler resultHandler) {
            this.cachedRequest = request;
            this.cachedFilterString = request.getFilter().toString();
            this.waitingResultHandlers.add(resultHandler);
        }

        public boolean handleEntry(SearchResultEntry entry) {
            this.cachedEntry = entry;
            return true;
        }

        public void handleException(LdapException exception) {
            this.handleResult(exception.getResult());
        }

        public boolean handleReference(SearchResultReference reference) {
            return true;
        }

        public void handleResult(Result result) {
            this.cachedResult = result;
            this.drainQueue();
        }

        void addResultHandler(SearchResultHandler resultHandler) {
            if (this.cachedResult != null) {
                this.invokeResultHandler(resultHandler);
                return;
            }
            this.waitingResultHandlers.add(resultHandler);
            if (this.cachedResult != null) {
                this.drainQueue();
            }
        }

        LdapPromise<Result> getPromise() {
            boolean wasInterrupted = false;
            while (true) {
                try {
                    this.cachedPromiseLatch.await();
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.cachedPromise;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                    continue;
                }
                break;
            }
        }

        boolean isMatchingRead(SearchRequest request) {
            return request.getScope().equals((Object)SearchScope.BASE_OBJECT) && request.getFilter().toString().equals(this.cachedFilterString) && request.getAttributes().equals(this.cachedRequest.getAttributes());
        }

        void setPromise(LdapPromise<Result> promise) {
            this.cachedPromise = promise;
            this.cachedPromiseLatch.countDown();
        }

        private void drainQueue() {
            SearchResultHandler resultHandler;
            while ((resultHandler = this.waitingResultHandlers.poll()) != null) {
                this.invokeResultHandler(resultHandler);
            }
        }

        private void invokeResultHandler(SearchResultHandler searchResultHandler) {
            if (this.cachedEntry != null) {
                searchResultHandler.handleEntry(this.cachedEntry);
            }
        }
    }
}

