/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.json.resource.ForbiddenException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.Utils;

final class AuthzIdTemplate {
    private static final Impl DN_IMPL = new Impl(){

        @Override
        public String formatAsAuthzId(AuthzIdTemplate t, Object[] templateVariables, Schema schema) throws ResourceException {
            String authzId = String.format(Locale.ENGLISH, t.formatString, templateVariables);
            try {
                DN.valueOf((String)authzId.substring(3), (Schema)schema);
            }
            catch (IllegalArgumentException e) {
                throw new ForbiddenException(Utils.i18n("The request could not be authorized because the required security principal was not a valid LDAP DN", new Object[0]));
            }
            return authzId;
        }
    };
    private static final Pattern DN_PATTERN = Pattern.compile("^dn:\\{[^}]+\\}$");
    private static final Impl DN_TEMPLATE_IMPL = new Impl(){

        @Override
        public String formatAsAuthzId(AuthzIdTemplate t, Object[] templateVariables, Schema schema) throws ResourceException {
            return "dn:" + DN.format((String)t.dnFormatString, (Schema)schema, (Object[])templateVariables);
        }
    };
    private static final Pattern KEY_RE = Pattern.compile("\\{([^}]+)\\}");
    private static final Impl UID_TEMPLATE_IMPL = new Impl(){

        @Override
        public String formatAsAuthzId(AuthzIdTemplate t, Object[] templateVariables, Schema schema) throws ResourceException {
            return String.format(Locale.ENGLISH, t.formatString, templateVariables);
        }
    };
    private final String dnFormatString;
    private final String formatString;
    private final List<String> keys = new ArrayList<String>();
    private final Impl pimpl;
    private final String template;

    AuthzIdTemplate(String template) {
        if (!template.startsWith("u:") && !template.startsWith("dn:")) {
            throw new IllegalArgumentException("Invalid authorization ID template: " + template);
        }
        Matcher matcher = KEY_RE.matcher(template);
        StringBuffer buffer = new StringBuffer(template.length());
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "%s");
            this.keys.add(matcher.group(1));
        }
        matcher.appendTail(buffer);
        this.formatString = buffer.toString();
        this.template = template;
        if (template.startsWith("dn:")) {
            this.pimpl = DN_PATTERN.matcher(template).matches() ? DN_IMPL : DN_TEMPLATE_IMPL;
            this.dnFormatString = this.formatString.substring(3);
        } else {
            this.pimpl = UID_TEMPLATE_IMPL;
            this.dnFormatString = null;
        }
    }

    public String toString() {
        return this.template;
    }

    String formatAsAuthzId(Map<String, Object> principals, Schema schema) throws ResourceException {
        Object[] templateVariables = this.getPrincipalsForFormatting(principals);
        return this.pimpl.formatAsAuthzId(this, templateVariables, schema);
    }

    private String[] getPrincipalsForFormatting(Map<String, Object> principals) throws ForbiddenException {
        String[] values = new String[this.keys.size()];
        for (int i = 0; i < values.length; ++i) {
            String key = this.keys.get(i);
            Object value = principals.get(key);
            if (!Utils.isJSONPrimitive(value)) {
                if (value != null) {
                    throw new ForbiddenException(Utils.i18n("The request could not be authorized because the required security principal '%s' had an invalid data type", key));
                }
                throw new ForbiddenException(Utils.i18n("The request could not be authorized because the required security principal '%s' could not be determined", key));
            }
            values[i] = String.valueOf(value);
        }
        return values;
    }

    private static interface Impl {
        public String formatAsAuthzId(AuthzIdTemplate var1, Object[] var2, Schema var3) throws ResourceException;
    }
}

