/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.cli.ValidationCallback;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.Console;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;

public abstract class ConsoleApplication {
    private static final int PROGRESS_LINE = 70;
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private final InputStream in = System.in;
    private final PrintStream out;
    private final PrintStream err;
    private final Console console = System.console();
    private boolean isProgressSuite;

    public ConsoleApplication() {
        this(System.out, System.err);
    }

    public ConsoleApplication(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public final PrintStream getErrorStream() {
        return this.err;
    }

    public final InputStream getInputStream() {
        return this.in;
    }

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean isQuiet() {
        return false;
    }

    public boolean isScriptFriendly() {
        return false;
    }

    public boolean isVerbose() {
        return false;
    }

    public boolean isAdvancedMode() {
        return false;
    }

    public boolean isMenuDrivenMode() {
        return false;
    }

    public final void pressReturnToContinue() {
        try {
            this.readLineOfInput(CliMessages.INFO_MENU_PROMPT_RETURN_TO_CONTINUE.get());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public final void errPrint(LocalizableMessage msg) {
        this.getErrStream().print(this.wrap(msg));
    }

    public final void errPrintln() {
        this.getErrStream().println();
    }

    public final void errPrintln(LocalizableMessage msg) {
        this.getErrStream().println(this.wrap(msg));
    }

    public final void errPrintln(LocalizableMessage msg, int indent) {
        this.getErrStream().println(Utils.wrapText(msg, Utils.MAX_LINE_WIDTH, indent));
    }

    public final void errPrintVerboseMessage(LocalizableMessage msg) {
        if (this.isVerbose()) {
            this.getErrStream().println(this.wrap(msg));
        }
    }

    public final void print(LocalizableMessage msg) {
        if (!this.isQuiet()) {
            this.out.print(this.wrap(msg));
        }
    }

    public final void println() {
        if (!this.isQuiet()) {
            this.out.println();
        }
    }

    public final void println(LocalizableMessage msg) {
        if (!this.isQuiet()) {
            this.out.println(this.wrap(msg));
        }
    }

    public final void println(LocalizableMessage msg, int indent) {
        if (!this.isQuiet()) {
            this.out.println(Utils.wrapText(msg, Utils.MAX_LINE_WIDTH, indent));
        }
    }

    private final void printProgressBar(int linePos, int progress) {
        if (!this.isQuiet()) {
            int spacesLeft = Utils.MAX_LINE_WIDTH - linePos - 10;
            StringBuilder bar = new StringBuilder();
            if (progress != 0) {
                for (int i = 0; i < 70; ++i) {
                    if (i >= Math.abs(progress) * spacesLeft / 100 || bar.length() >= spacesLeft) continue;
                    bar.append(".");
                }
            }
            bar.append(".   ");
            if (progress >= 0) {
                bar.append(progress).append("%     ");
            } else {
                bar.append("FAIL");
                this.isProgressSuite = false;
            }
            int endBuilder = linePos + bar.length();
            for (int i = 0; i < endBuilder; ++i) {
                bar.append("\b");
            }
            if (progress >= 100 || progress < 0) {
                bar.append(StaticUtils.EOL);
                this.isProgressSuite = false;
            }
            this.out.print(bar);
        }
    }

    public final void printProgressBar(String msg, int progress, int indent) {
        if (!this.isQuiet()) {
            String msgToDisplay = Utils.wrapText(msg, 70, indent);
            if (msgToDisplay.length() > 70) {
                String[] msgWrapped = msgToDisplay.split(Utils.LINE_SEPARATOR);
                if (!this.isProgressSuite) {
                    for (int pos = 0; pos < msgWrapped.length - 1; ++pos) {
                        this.println(LocalizableMessage.raw((CharSequence)msgWrapped[pos], (Object[])new Object[0]));
                    }
                    this.isProgressSuite = true;
                }
                msgToDisplay = msgWrapped[msgWrapped.length - 1];
            }
            this.print(LocalizableMessage.raw((CharSequence)msgToDisplay, (Object[])new Object[0]));
            this.printProgressBar(msgToDisplay.length(), progress);
        }
    }

    public final void println(Style msgStyle, LocalizableMessage msg, int indent) {
        if (!this.isQuiet()) {
            switch (msgStyle) {
                case TITLE: {
                    this.out.println();
                    this.out.println(">>>> " + Utils.wrapText(msg, Utils.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case SUBTITLE: {
                    this.out.println(Utils.wrapText(msg, Utils.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case NOTICE: {
                    this.out.println(Utils.wrapText("* " + msg, Utils.MAX_LINE_WIDTH, indent));
                    break;
                }
                case ERROR: {
                    this.out.println();
                    this.out.println(Utils.wrapText("** " + msg, Utils.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case WARNING: {
                    this.out.println(Utils.wrapText("[!] " + msg, Utils.MAX_LINE_WIDTH, indent));
                    break;
                }
                default: {
                    this.out.println(Utils.wrapText(msg, Utils.MAX_LINE_WIDTH, indent));
                }
            }
        }
    }

    public final void printVerboseMessage(LocalizableMessage msg) {
        if (this.isVerbose()) {
            this.out.println(this.wrap(msg));
        }
    }

    public final String readInput(LocalizableMessage prompt, String defaultValue) throws ClientException {
        return this.readInput(prompt, defaultValue, null);
    }

    public final String readInput(LocalizableMessage prompt, String defaultValue, Style msgStyle) throws ClientException {
        if (msgStyle != null && msgStyle == Style.TITLE) {
            this.println();
        }
        if (defaultValue != null) {
            prompt = CliMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt, (Object)defaultValue);
        }
        String response = this.readLineOfInput(prompt);
        if (msgStyle != null && (msgStyle == Style.TITLE || msgStyle == Style.SUBTITLE)) {
            this.println();
        }
        if ("".equals(response)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            this.println(CliMessages.INFO_ERROR_EMPTY_RESPONSE.get());
        }
        return response;
    }

    public final char[] readPassword(LocalizableMessage prompt) throws ClientException {
        if (this.console != null) {
            if (prompt != null) {
                this.out.print(this.wrap(prompt));
                this.out.print(" ");
            }
            try {
                char[] password = this.console.readPassword();
                if (password == null) {
                    throw new EOFException("End of input");
                }
                return password;
            }
            catch (Throwable e) {
                throw ClientException.adaptInputException(e);
            }
        }
        return this.readLineOfInput(prompt).toCharArray();
    }

    public static char[] readPassword() throws ClientException {
        try {
            return System.console().readPassword();
        }
        catch (IOError e) {
            throw ClientException.adaptInputException(e);
        }
    }

    public final String readLineOfInput(LocalizableMessage prompt) throws ClientException {
        if (prompt != null) {
            this.out.print(this.wrap(prompt));
            this.out.print(" ");
        }
        try {
            String s = this.reader.readLine();
            if (s == null) {
                throw ClientException.adaptInputException(new EOFException("End of input"));
            }
            return s;
        }
        catch (IOException e) {
            throw ClientException.adaptInputException(e);
        }
    }

    public final int readPort(LocalizableMessage prompt, int defaultValue) throws ClientException {
        if (defaultValue != -1) {
            prompt = CliMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt, (Object)defaultValue);
        }
        return this.readValidatedInput(prompt, Utils.portValidationCallback(defaultValue), 5);
    }

    public final <T> T readValidatedInput(LocalizableMessage prompt, ValidationCallback<T> validator) throws ClientException {
        String response;
        T value;
        while ((value = validator.validate(this, response = this.readLineOfInput(prompt))) == null) {
        }
        return value;
    }

    public final <T> T readValidatedInput(LocalizableMessage prompt, ValidationCallback<T> validator, int maxTries) throws ClientException {
        for (int nTries = 0; nTries < maxTries; ++nTries) {
            String response = this.readLineOfInput(prompt);
            T value = validator.validate(this, response);
            if (value == null) continue;
            return value;
        }
        throw new ClientException(ReturnCode.ERROR_USER_DATA, CliMessages.ERR_TRIES_LIMIT_REACHED.get((Object)maxTries));
    }

    private String wrap(LocalizableMessage msg) {
        return Utils.wrapText(msg, Utils.MAX_LINE_WIDTH);
    }

    protected PrintStream getErrStream() {
        if (this.isInteractive()) {
            return this.out;
        }
        return this.err;
    }

    protected final boolean askConfirmation(LocalizableMessage prompt, boolean defaultValue, LocalizedLogger logger) throws ClientException {
        for (int nTries = 0; nTries < 5; ++nTries) {
            try {
                return this.confirmAction(prompt, defaultValue);
            }
            catch (ClientException ce) {
                if (ce.getMessageObject().toString().contains((CharSequence)CliMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get((Object)nTries))) {
                    throw ce;
                }
                logger.warn(LocalizableMessage.raw((CharSequence)("Error reading input: " + ce), (Object[])new Object[]{ce}));
                this.println();
                continue;
            }
        }
        throw new ClientException(ReturnCode.ERROR_USER_DATA, CliMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get((Object)5));
    }

    public final boolean confirmAction(LocalizableMessage prompt, final boolean defaultValue) throws ClientException {
        if (!this.isInteractive()) {
            return defaultValue;
        }
        final LocalizableMessage yes = CliMessages.INFO_GENERAL_YES.get();
        final LocalizableMessage no = CliMessages.INFO_GENERAL_NO.get();
        final LocalizableMessage errMsg = CliMessages.ERR_CONSOLE_APP_CONFIRM.get((Object)yes, (Object)no);
        prompt = CliMessages.INFO_MENU_PROMPT_CONFIRM.get((Object)prompt, (Object)yes, (Object)no, (Object)(defaultValue ? yes : no));
        ValidationCallback<Boolean> validator = new ValidationCallback<Boolean>(){

            @Override
            public Boolean validate(ConsoleApplication app, String input) {
                String ninput = input.toLowerCase().trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                if (no.toString().toLowerCase().startsWith(ninput)) {
                    return false;
                }
                if (yes.toString().toLowerCase().startsWith(ninput)) {
                    return true;
                }
                app.println();
                app.println(errMsg);
                app.println();
                return null;
            }
        };
        return this.readValidatedInput(prompt, validator, 5);
    }

    protected int askPort(LocalizableMessage prompt, int defaultValue, LocalizedLogger logger) {
        while (true) {
            try {
                int port;
                while ((port = this.readPort(prompt, defaultValue)) == -1) {
                }
                return port;
            }
            catch (ClientException ce) {
                logger.warn(LocalizableMessage.raw((CharSequence)("Error reading input: " + ce), (Object[])new Object[]{ce}));
                continue;
            }
            break;
        }
    }

    void printHeader(LocalizableMessage header) {
        this.println();
        this.println();
        this.println(header);
        this.println();
    }

    public static enum Style {
        TITLE,
        SUBTITLE,
        NOTICE,
        NORMAL,
        ERROR,
        WARNING;

    }
}

