/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.TraditionalWorkQueueCfgClient;
import org.forgerock.opendj.server.config.meta.WorkQueueCfgDefn;
import org.forgerock.opendj.server.config.server.TraditionalWorkQueueCfg;
import org.forgerock.opendj.server.config.server.WorkQueueCfg;

public final class TraditionalWorkQueueCfgDefn
extends ManagedObjectDefinition<TraditionalWorkQueueCfgClient, TraditionalWorkQueueCfg> {
    private static final TraditionalWorkQueueCfgDefn INSTANCE = new TraditionalWorkQueueCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_MAX_WORK_QUEUE_CAPACITY;
    private static final IntegerPropertyDefinition PD_NUM_WORKER_THREADS;

    public static TraditionalWorkQueueCfgDefn getInstance() {
        return INSTANCE;
    }

    private TraditionalWorkQueueCfgDefn() {
        super("traditional-work-queue", WorkQueueCfgDefn.getInstance());
    }

    @Override
    public TraditionalWorkQueueCfgClient createClientConfiguration(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
        return new TraditionalWorkQueueCfgClientImpl(impl);
    }

    @Override
    public TraditionalWorkQueueCfg createServerConfiguration(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
        return new TraditionalWorkQueueCfgServerImpl(impl);
    }

    @Override
    public Class<TraditionalWorkQueueCfg> getServerConfigurationClass() {
        return TraditionalWorkQueueCfg.class;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getMaxWorkQueueCapacityPropertyDefinition() {
        return PD_MAX_WORK_QUEUE_CAPACITY;
    }

    public IntegerPropertyDefinition getNumWorkerThreadsPropertyDefinition() {
        return PD_NUM_WORKER_THREADS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.TraditionalWorkQueue");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.WorkQueue");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-work-queue-capacity");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-work-queue-capacity"));
        provider = new DefinedDefaultBehaviorProvider("1000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_MAX_WORK_QUEUE_CAPACITY = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_WORK_QUEUE_CAPACITY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "num-worker-threads");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "num-worker-threads"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "num-worker-threads"));
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_NUM_WORKER_THREADS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NUM_WORKER_THREADS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class TraditionalWorkQueueCfgServerImpl
    implements TraditionalWorkQueueCfg {
        private ServerManagedObject<? extends TraditionalWorkQueueCfg> impl;
        private final String pJavaClass;
        private final int pMaxWorkQueueCapacity;
        private final Integer pNumWorkerThreads;

        private TraditionalWorkQueueCfgServerImpl(ServerManagedObject<? extends TraditionalWorkQueueCfg> impl) {
            this.impl = impl;
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMaxWorkQueueCapacity = impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
            this.pNumWorkerThreads = impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void addTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeTraditionalChangeListener(ConfigurationChangeListener<TraditionalWorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<WorkQueueCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public int getMaxWorkQueueCapacity() {
            return this.pMaxWorkQueueCapacity;
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.pNumWorkerThreads;
        }

        @Override
        public Class<? extends TraditionalWorkQueueCfg> configurationClass() {
            return TraditionalWorkQueueCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class TraditionalWorkQueueCfgClientImpl
    implements TraditionalWorkQueueCfgClient {
        private ManagedObject<? extends TraditionalWorkQueueCfgClient> impl;

        private TraditionalWorkQueueCfgClientImpl(ManagedObject<? extends TraditionalWorkQueueCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public int getMaxWorkQueueCapacity() {
            return this.impl.getPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition());
        }

        @Override
        public void setMaxWorkQueueCapacity(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxWorkQueueCapacityPropertyDefinition(), value);
        }

        @Override
        public Integer getNumWorkerThreads() {
            return this.impl.getPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition());
        }

        @Override
        public void setNumWorkerThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getNumWorkerThreadsPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends TraditionalWorkQueueCfgClient, ? extends TraditionalWorkQueueCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

