/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.BackendIndexCfgClient;
import org.forgerock.opendj.server.config.client.BackendVLVIndexCfgClient;
import org.forgerock.opendj.server.config.client.PDBBackendCfgClient;
import org.forgerock.opendj.server.config.meta.BackendCfgDefn;
import org.forgerock.opendj.server.config.meta.PluggableBackendCfgDefn;
import org.forgerock.opendj.server.config.server.BackendCfg;
import org.forgerock.opendj.server.config.server.BackendIndexCfg;
import org.forgerock.opendj.server.config.server.BackendVLVIndexCfg;
import org.forgerock.opendj.server.config.server.PDBBackendCfg;
import org.forgerock.opendj.server.config.server.PluggableBackendCfg;

public final class PDBBackendCfgDefn
extends ManagedObjectDefinition<PDBBackendCfgClient, PDBBackendCfg> {
    private static final PDBBackendCfgDefn INSTANCE = new PDBBackendCfgDefn();
    private static final IntegerPropertyDefinition PD_DB_CACHE_PERCENT;
    private static final SizePropertyDefinition PD_DB_CACHE_SIZE;
    private static final DurationPropertyDefinition PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    private static final StringPropertyDefinition PD_DB_DIRECTORY;
    private static final StringPropertyDefinition PD_DB_DIRECTORY_PERMISSIONS;
    private static final BooleanPropertyDefinition PD_DB_TXN_NO_SYNC;
    private static final SizePropertyDefinition PD_DISK_FULL_THRESHOLD;
    private static final SizePropertyDefinition PD_DISK_LOW_THRESHOLD;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static PDBBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private PDBBackendCfgDefn() {
        super("pdb-backend", PluggableBackendCfgDefn.getInstance());
    }

    @Override
    public PDBBackendCfgClient createClientConfiguration(ManagedObject<? extends PDBBackendCfgClient> impl) {
        return new PDBBackendCfgClientImpl(impl);
    }

    @Override
    public PDBBackendCfg createServerConfiguration(ServerManagedObject<? extends PDBBackendCfg> impl) {
        return new PDBBackendCfgServerImpl(impl);
    }

    @Override
    public Class<PDBBackendCfg> getServerConfigurationClass() {
        return PDBBackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public BooleanPropertyDefinition getCompactEncodingPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getCompactEncodingPropertyDefinition();
    }

    public IntegerPropertyDefinition getDBCachePercentPropertyDefinition() {
        return PD_DB_CACHE_PERCENT;
    }

    public SizePropertyDefinition getDBCacheSizePropertyDefinition() {
        return PD_DB_CACHE_SIZE;
    }

    public DurationPropertyDefinition getDBCheckpointerWakeupIntervalPropertyDefinition() {
        return PD_DB_CHECKPOINTER_WAKEUP_INTERVAL;
    }

    public StringPropertyDefinition getDBDirectoryPropertyDefinition() {
        return PD_DB_DIRECTORY;
    }

    public StringPropertyDefinition getDBDirectoryPermissionsPropertyDefinition() {
        return PD_DB_DIRECTORY_PERMISSIONS;
    }

    public BooleanPropertyDefinition getDBTxnNoSyncPropertyDefinition() {
        return PD_DB_TXN_NO_SYNC;
    }

    public SizePropertyDefinition getDiskFullThresholdPropertyDefinition() {
        return PD_DISK_FULL_THRESHOLD;
    }

    public SizePropertyDefinition getDiskLowThresholdPropertyDefinition() {
        return PD_DISK_LOW_THRESHOLD;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getEntriesCompressedPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getEntriesCompressedPropertyDefinition();
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexEntryLimitPropertyDefinition();
    }

    public BooleanPropertyDefinition getIndexFilterAnalyzerEnabledPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexFilterAnalyzerEnabledPropertyDefinition();
    }

    public IntegerPropertyDefinition getIndexFilterAnalyzerMaxFiltersPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getIndexFilterAnalyzerMaxFiltersPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public DurationPropertyDefinition getPreloadTimeLimitPropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getPreloadTimeLimitPropertyDefinition();
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PluggableBackendCfgDefn.getInstance().getWritabilityModePropertyDefinition();
    }

    public InstantiableRelationDefinition<BackendIndexCfgClient, BackendIndexCfg> getBackendIndexesRelationDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendIndexesRelationDefinition();
    }

    public InstantiableRelationDefinition<BackendVLVIndexCfgClient, BackendVLVIndexCfg> getBackendVLVIndexesRelationDefinition() {
        return PluggableBackendCfgDefn.getInstance().getBackendVLVIndexesRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "db-cache-percent");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-percent"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("50");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_DB_CACHE_PERCENT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_PERCENT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "db-cache-size");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-cache-size"));
        provider = new DefinedDefaultBehaviorProvider("0 MB");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0 MB");
        PD_DB_CACHE_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CACHE_SIZE);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "db-checkpointer-wakeup-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-checkpointer-wakeup-interval"));
        provider = new DefinedDefaultBehaviorProvider("15s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("3600");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("10");
        PD_DB_CHECKPOINTER_WAKEUP_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_CHECKPOINTER_WAKEUP_INTERVAL);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "db-directory"));
        provider = new DefinedDefaultBehaviorProvider("db");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "db-directory-permissions");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "db-directory-permissions"));
        provider = new DefinedDefaultBehaviorProvider("700");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^7[0-7][0-7]$", "MODE");
        PD_DB_DIRECTORY_PERMISSIONS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_DIRECTORY_PERMISSIONS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "db-txn-no-sync");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "db-txn-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_DB_TXN_NO_SYNC = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DB_TXN_NO_SYNC);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "disk-full-threshold");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disk-full-threshold"));
        provider = new DefinedDefaultBehaviorProvider("100 megabytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_DISK_FULL_THRESHOLD = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISK_FULL_THRESHOLD);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "disk-low-threshold");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disk-low-threshold"));
        provider = new DefinedDefaultBehaviorProvider("200 megabytes");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_DISK_LOW_THRESHOLD = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISK_LOW_THRESHOLD);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.pdb.PDBBackend");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class PDBBackendCfgServerImpl
    implements PDBBackendCfg {
        private ServerManagedObject<? extends PDBBackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final boolean pCompactEncoding;
        private final int pDBCachePercent;
        private final long pDBCacheSize;
        private final long pDBCheckpointerWakeupInterval;
        private final String pDBDirectory;
        private final String pDBDirectoryPermissions;
        private final boolean pDBTxnNoSync;
        private final long pDiskFullThreshold;
        private final long pDiskLowThreshold;
        private final boolean pEnabled;
        private final boolean pEntriesCompressed;
        private final int pIndexEntryLimit;
        private final boolean pIndexFilterAnalyzerEnabled;
        private final int pIndexFilterAnalyzerMaxFilters;
        private final String pJavaClass;
        private final long pPreloadTimeLimit;
        private final BackendCfgDefn.WritabilityMode pWritabilityMode;

        private PDBBackendCfgServerImpl(ServerManagedObject<? extends PDBBackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pCompactEncoding = impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
            this.pDBCachePercent = impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
            this.pDBCacheSize = impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
            this.pDBCheckpointerWakeupInterval = impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
            this.pDBDirectory = impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
            this.pDBDirectoryPermissions = impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
            this.pDBTxnNoSync = impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
            this.pDiskFullThreshold = impl.getPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition());
            this.pDiskLowThreshold = impl.getPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pEntriesCompressed = impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
            this.pIndexEntryLimit = impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
            this.pIndexFilterAnalyzerEnabled = impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition());
            this.pIndexFilterAnalyzerMaxFilters = impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pPreloadTimeLimit = impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addPDBChangeListener(ConfigurationChangeListener<PDBBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePDBChangeListener(ConfigurationChangeListener<PDBBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addPluggableChangeListener(ConfigurationChangeListener<PluggableBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePluggableChangeListener(ConfigurationChangeListener<PluggableBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isCompactEncoding() {
            return this.pCompactEncoding;
        }

        @Override
        public int getDBCachePercent() {
            return this.pDBCachePercent;
        }

        @Override
        public long getDBCacheSize() {
            return this.pDBCacheSize;
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.pDBCheckpointerWakeupInterval;
        }

        @Override
        public String getDBDirectory() {
            return this.pDBDirectory;
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.pDBDirectoryPermissions;
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.pDBTxnNoSync;
        }

        @Override
        public long getDiskFullThreshold() {
            return this.pDiskFullThreshold;
        }

        @Override
        public long getDiskLowThreshold() {
            return this.pDiskLowThreshold;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.pEntriesCompressed;
        }

        @Override
        public int getIndexEntryLimit() {
            return this.pIndexEntryLimit;
        }

        @Override
        public boolean isIndexFilterAnalyzerEnabled() {
            return this.pIndexFilterAnalyzerEnabled;
        }

        @Override
        public int getIndexFilterAnalyzerMaxFilters() {
            return this.pIndexFilterAnalyzerMaxFilters;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.pPreloadTimeLimit;
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public String[] listBackendIndexes() {
            return this.impl.listChildren(INSTANCE.getBackendIndexesRelationDefinition());
        }

        @Override
        public BackendIndexCfg getBackendIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getBackendIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addBackendIndexAddListener(ConfigurationAddListener<BackendIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendIndexAddListener(ConfigurationAddListener<BackendIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void addBackendIndexDeleteListener(ConfigurationDeleteListener<BackendIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendIndexDeleteListener(ConfigurationDeleteListener<BackendIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getBackendIndexesRelationDefinition(), listener);
        }

        @Override
        public String[] listBackendVLVIndexes() {
            return this.impl.listChildren(INSTANCE.getBackendVLVIndexesRelationDefinition());
        }

        @Override
        public BackendVLVIndexCfg getBackendVLVIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addBackendVLVIndexAddListener(ConfigurationAddListener<BackendVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendVLVIndexAddListener(ConfigurationAddListener<BackendVLVIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void addBackendVLVIndexDeleteListener(ConfigurationDeleteListener<BackendVLVIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeBackendVLVIndexDeleteListener(ConfigurationDeleteListener<BackendVLVIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getBackendVLVIndexesRelationDefinition(), listener);
        }

        @Override
        public Class<? extends PDBBackendCfg> configurationClass() {
            return PDBBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class PDBBackendCfgClientImpl
    implements PDBBackendCfgClient {
        private ManagedObject<? extends PDBBackendCfgClient> impl;

        private PDBBackendCfgClientImpl(ManagedObject<? extends PDBBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public boolean isCompactEncoding() {
            return this.impl.getPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition());
        }

        @Override
        public void setCompactEncoding(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCompactEncodingPropertyDefinition(), value);
        }

        @Override
        public int getDBCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition());
        }

        @Override
        public void setDBCachePercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDBCachePercentPropertyDefinition(), value);
        }

        @Override
        public long getDBCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition());
        }

        @Override
        public void setDBCacheSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCacheSizePropertyDefinition(), value);
        }

        @Override
        public long getDBCheckpointerWakeupInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition());
        }

        @Override
        public void setDBCheckpointerWakeupInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDBCheckpointerWakeupIntervalPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition());
        }

        @Override
        public void setDBDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPropertyDefinition(), value);
        }

        @Override
        public String getDBDirectoryPermissions() {
            return this.impl.getPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition());
        }

        @Override
        public void setDBDirectoryPermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getDBDirectoryPermissionsPropertyDefinition(), value);
        }

        @Override
        public boolean isDBTxnNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition());
        }

        @Override
        public void setDBTxnNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDBTxnNoSyncPropertyDefinition(), value);
        }

        @Override
        public long getDiskFullThreshold() {
            return this.impl.getPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition());
        }

        @Override
        public void setDiskFullThreshold(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiskFullThresholdPropertyDefinition(), value);
        }

        @Override
        public long getDiskLowThreshold() {
            return this.impl.getPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition());
        }

        @Override
        public void setDiskLowThreshold(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDiskLowThresholdPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isEntriesCompressed() {
            return this.impl.getPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition());
        }

        @Override
        public void setEntriesCompressed(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEntriesCompressedPropertyDefinition(), value);
        }

        @Override
        public int getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public boolean isIndexFilterAnalyzerEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition());
        }

        @Override
        public void setIndexFilterAnalyzerEnabled(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIndexFilterAnalyzerEnabledPropertyDefinition(), value);
        }

        @Override
        public int getIndexFilterAnalyzerMaxFilters() {
            return this.impl.getPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition());
        }

        @Override
        public void setIndexFilterAnalyzerMaxFilters(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexFilterAnalyzerMaxFiltersPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public long getPreloadTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition());
        }

        @Override
        public void setPreloadTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getPreloadTimeLimitPropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(BackendCfgDefn.WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public String[] listBackendIndexes() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getBackendIndexesRelationDefinition());
        }

        @Override
        public BackendIndexCfgClient getBackendIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getBackendIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends BackendIndexCfgClient> M createBackendIndex(ManagedObjectDefinition<M, ? extends BackendIndexCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((BackendIndexCfgClient)this.impl.createChild(INSTANCE.getBackendIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeBackendIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getBackendIndexesRelationDefinition(), name);
        }

        @Override
        public String[] listBackendVLVIndexes() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getBackendVLVIndexesRelationDefinition());
        }

        @Override
        public BackendVLVIndexCfgClient getBackendVLVIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends BackendVLVIndexCfgClient> M createBackendVLVIndex(ManagedObjectDefinition<M, ? extends BackendVLVIndexCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((BackendVLVIndexCfgClient)this.impl.createChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeBackendVLVIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getBackendVLVIndexesRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends PDBBackendCfgClient, ? extends PDBBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

