/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.GSSAPISASLMechanismHandlerCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.meta.SASLMechanismHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.GSSAPISASLMechanismHandlerCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;
import org.forgerock.opendj.server.config.server.SASLMechanismHandlerCfg;

public final class GSSAPISASLMechanismHandlerCfgDefn
extends ManagedObjectDefinition<GSSAPISASLMechanismHandlerCfgClient, GSSAPISASLMechanismHandlerCfg> {
    private static final GSSAPISASLMechanismHandlerCfgDefn INSTANCE = new GSSAPISASLMechanismHandlerCfgDefn();
    private static final AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> PD_IDENTITY_MAPPER;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_KDC_ADDRESS;
    private static final StringPropertyDefinition PD_KEYTAB;
    private static final StringPropertyDefinition PD_PRINCIPAL_NAME;
    private static final EnumPropertyDefinition<QualityOfProtection> PD_QUALITY_OF_PROTECTION;
    private static final StringPropertyDefinition PD_REALM;
    private static final StringPropertyDefinition PD_SERVER_FQDN;

    public static GSSAPISASLMechanismHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private GSSAPISASLMechanismHandlerCfgDefn() {
        super("gssapi-sasl-mechanism-handler", SASLMechanismHandlerCfgDefn.getInstance());
    }

    @Override
    public GSSAPISASLMechanismHandlerCfgClient createClientConfiguration(ManagedObject<? extends GSSAPISASLMechanismHandlerCfgClient> impl) {
        return new GSSAPISASLMechanismHandlerCfgClientImpl(impl);
    }

    @Override
    public GSSAPISASLMechanismHandlerCfg createServerConfiguration(ServerManagedObject<? extends GSSAPISASLMechanismHandlerCfg> impl) {
        return new GSSAPISASLMechanismHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<GSSAPISASLMechanismHandlerCfg> getServerConfigurationClass() {
        return GSSAPISASLMechanismHandlerCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return SASLMechanismHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getIdentityMapperPropertyDefinition() {
        return PD_IDENTITY_MAPPER;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getKdcAddressPropertyDefinition() {
        return PD_KDC_ADDRESS;
    }

    public StringPropertyDefinition getKeytabPropertyDefinition() {
        return PD_KEYTAB;
    }

    public StringPropertyDefinition getPrincipalNamePropertyDefinition() {
        return PD_PRINCIPAL_NAME;
    }

    public EnumPropertyDefinition<QualityOfProtection> getQualityOfProtectionPropertyDefinition() {
        return PD_QUALITY_OF_PROTECTION;
    }

    public StringPropertyDefinition getRealmPropertyDefinition() {
        return PD_REALM;
    }

    public StringPropertyDefinition getServerFqdnPropertyDefinition() {
        return PD_SERVER_FQDN;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "identity-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "identity-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("identity-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.contains("enabled", "true"));
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_IDENTITY_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IDENTITY_MAPPER);
        INSTANCE.registerConstraint(PD_IDENTITY_MAPPER.getSourceConstraint());
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.GSSAPISASLMechanismHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.SASLMechanismHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "kdc-address");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "kdc-address"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "kdc-address"));
        PD_KDC_ADDRESS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KDC_ADDRESS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "keytab");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "keytab"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "keytab"));
        PD_KEYTAB = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEYTAB);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "principal-name");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "principal-name"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "principal-name"));
        PD_PRINCIPAL_NAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRINCIPAL_NAME);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "quality-of-protection");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "quality-of-protection"));
        provider = new DefinedDefaultBehaviorProvider("none");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(QualityOfProtection.class);
        PD_QUALITY_OF_PROTECTION = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUALITY_OF_PROTECTION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "realm");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "realm"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "realm"));
        PD_REALM = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REALM);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "server-fqdn");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "server-fqdn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "server-fqdn"));
        PD_SERVER_FQDN = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SERVER_FQDN);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class GSSAPISASLMechanismHandlerCfgServerImpl
    implements GSSAPISASLMechanismHandlerCfg {
        private ServerManagedObject<? extends GSSAPISASLMechanismHandlerCfg> impl;
        private final boolean pEnabled;
        private final String pIdentityMapper;
        private final String pJavaClass;
        private final String pKdcAddress;
        private final String pKeytab;
        private final String pPrincipalName;
        private final QualityOfProtection pQualityOfProtection;
        private final String pRealm;
        private final String pServerFqdn;

        private GSSAPISASLMechanismHandlerCfgServerImpl(ServerManagedObject<? extends GSSAPISASLMechanismHandlerCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIdentityMapper = impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKdcAddress = impl.getPropertyValue(INSTANCE.getKdcAddressPropertyDefinition());
            this.pKeytab = impl.getPropertyValue(INSTANCE.getKeytabPropertyDefinition());
            this.pPrincipalName = impl.getPropertyValue(INSTANCE.getPrincipalNamePropertyDefinition());
            this.pQualityOfProtection = impl.getPropertyValue(INSTANCE.getQualityOfProtectionPropertyDefinition());
            this.pRealm = impl.getPropertyValue(INSTANCE.getRealmPropertyDefinition());
            this.pServerFqdn = impl.getPropertyValue(INSTANCE.getServerFqdnPropertyDefinition());
        }

        @Override
        public void addGSSAPIChangeListener(ConfigurationChangeListener<GSSAPISASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeGSSAPIChangeListener(ConfigurationChangeListener<GSSAPISASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<SASLMechanismHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getIdentityMapper() {
            return this.pIdentityMapper;
        }

        @Override
        public DN getIdentityMapperDN() {
            String value = this.getIdentityMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getIdentityMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKdcAddress() {
            return this.pKdcAddress;
        }

        @Override
        public String getKeytab() {
            return this.pKeytab;
        }

        @Override
        public String getPrincipalName() {
            return this.pPrincipalName;
        }

        @Override
        public QualityOfProtection getQualityOfProtection() {
            return this.pQualityOfProtection;
        }

        @Override
        public String getRealm() {
            return this.pRealm;
        }

        @Override
        public String getServerFqdn() {
            return this.pServerFqdn;
        }

        @Override
        public Class<? extends GSSAPISASLMechanismHandlerCfg> configurationClass() {
            return GSSAPISASLMechanismHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class GSSAPISASLMechanismHandlerCfgClientImpl
    implements GSSAPISASLMechanismHandlerCfgClient {
        private ManagedObject<? extends GSSAPISASLMechanismHandlerCfgClient> impl;

        private GSSAPISASLMechanismHandlerCfgClientImpl(ManagedObject<? extends GSSAPISASLMechanismHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getIdentityMapper() {
            return this.impl.getPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition());
        }

        @Override
        public void setIdentityMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getIdentityMapperPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKdcAddress() {
            return this.impl.getPropertyValue(INSTANCE.getKdcAddressPropertyDefinition());
        }

        @Override
        public void setKdcAddress(String value) {
            this.impl.setPropertyValue(INSTANCE.getKdcAddressPropertyDefinition(), value);
        }

        @Override
        public String getKeytab() {
            return this.impl.getPropertyValue(INSTANCE.getKeytabPropertyDefinition());
        }

        @Override
        public void setKeytab(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeytabPropertyDefinition(), value);
        }

        @Override
        public String getPrincipalName() {
            return this.impl.getPropertyValue(INSTANCE.getPrincipalNamePropertyDefinition());
        }

        @Override
        public void setPrincipalName(String value) {
            this.impl.setPropertyValue(INSTANCE.getPrincipalNamePropertyDefinition(), value);
        }

        @Override
        public QualityOfProtection getQualityOfProtection() {
            return this.impl.getPropertyValue(INSTANCE.getQualityOfProtectionPropertyDefinition());
        }

        @Override
        public void setQualityOfProtection(QualityOfProtection value) {
            this.impl.setPropertyValue(INSTANCE.getQualityOfProtectionPropertyDefinition(), value);
        }

        @Override
        public String getRealm() {
            return this.impl.getPropertyValue(INSTANCE.getRealmPropertyDefinition());
        }

        @Override
        public void setRealm(String value) {
            this.impl.setPropertyValue(INSTANCE.getRealmPropertyDefinition(), value);
        }

        @Override
        public String getServerFqdn() {
            return this.impl.getPropertyValue(INSTANCE.getServerFqdnPropertyDefinition());
        }

        @Override
        public void setServerFqdn(String value) {
            this.impl.setPropertyValue(INSTANCE.getServerFqdnPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends GSSAPISASLMechanismHandlerCfgClient, ? extends GSSAPISASLMechanismHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum QualityOfProtection {
        CONFIDENTIALITY("confidentiality"),
        INTEGRITY("integrity"),
        NONE("none");

        private final String name;

        private QualityOfProtection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

