/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AccessLogFilteringCriteriaCfgClient;
import org.forgerock.opendj.server.config.client.FileBasedAccessLogPublisherCfgClient;
import org.forgerock.opendj.server.config.client.LogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.client.LogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.AccessLogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.AccessLogFilteringCriteriaCfg;
import org.forgerock.opendj.server.config.server.AccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.FileBasedAccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;

public final class FileBasedAccessLogPublisherCfgDefn
extends ManagedObjectDefinition<FileBasedAccessLogPublisherCfgClient, FileBasedAccessLogPublisherCfg> {
    private static final FileBasedAccessLogPublisherCfgDefn INSTANCE = new FileBasedAccessLogPublisherCfgDefn();
    private static final BooleanPropertyDefinition PD_APPEND;
    private static final BooleanPropertyDefinition PD_ASYNCHRONOUS;
    private static final BooleanPropertyDefinition PD_AUTO_FLUSH;
    private static final SizePropertyDefinition PD_BUFFER_SIZE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final BooleanPropertyDefinition PD_LOG_CONTROL_OIDS;
    private static final StringPropertyDefinition PD_LOG_FILE;
    private static final StringPropertyDefinition PD_LOG_FILE_PERMISSIONS;
    private static final EnumPropertyDefinition<LogFormat> PD_LOG_FORMAT;
    private static final StringPropertyDefinition PD_LOG_RECORD_TIME_FORMAT;
    private static final IntegerPropertyDefinition PD_QUEUE_SIZE;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;
    private static final DurationPropertyDefinition PD_TIME_INTERVAL;

    public static FileBasedAccessLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private FileBasedAccessLogPublisherCfgDefn() {
        super("file-based-access-log-publisher", AccessLogPublisherCfgDefn.getInstance());
    }

    @Override
    public FileBasedAccessLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends FileBasedAccessLogPublisherCfgClient> impl) {
        return new FileBasedAccessLogPublisherCfgClientImpl(impl);
    }

    @Override
    public FileBasedAccessLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends FileBasedAccessLogPublisherCfg> impl) {
        return new FileBasedAccessLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<FileBasedAccessLogPublisherCfg> getServerConfigurationClass() {
        return FileBasedAccessLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getAppendPropertyDefinition() {
        return PD_APPEND;
    }

    public BooleanPropertyDefinition getAsynchronousPropertyDefinition() {
        return PD_ASYNCHRONOUS;
    }

    public BooleanPropertyDefinition getAutoFlushPropertyDefinition() {
        return PD_AUTO_FLUSH;
    }

    public SizePropertyDefinition getBufferSizePropertyDefinition() {
        return PD_BUFFER_SIZE;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public EnumPropertyDefinition<AccessLogPublisherCfgDefn.FilteringPolicy> getFilteringPolicyPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getFilteringPolicyPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public BooleanPropertyDefinition getLogControlOidsPropertyDefinition() {
        return PD_LOG_CONTROL_OIDS;
    }

    public StringPropertyDefinition getLogFilePropertyDefinition() {
        return PD_LOG_FILE;
    }

    public StringPropertyDefinition getLogFilePermissionsPropertyDefinition() {
        return PD_LOG_FILE_PERMISSIONS;
    }

    public EnumPropertyDefinition<LogFormat> getLogFormatPropertyDefinition() {
        return PD_LOG_FORMAT;
    }

    public StringPropertyDefinition getLogRecordTimeFormatPropertyDefinition() {
        return PD_LOG_RECORD_TIME_FORMAT;
    }

    public IntegerPropertyDefinition getQueueSizePropertyDefinition() {
        return PD_QUEUE_SIZE;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    public BooleanPropertyDefinition getSuppressInternalOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressInternalOperationsPropertyDefinition();
    }

    public BooleanPropertyDefinition getSuppressSynchronizationOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressSynchronizationOperationsPropertyDefinition();
    }

    public DurationPropertyDefinition getTimeIntervalPropertyDefinition() {
        return PD_TIME_INTERVAL;
    }

    public InstantiableRelationDefinition<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> getAccessLogFilteringCriteriaRelationDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getAccessLogFilteringCriteriaRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "append");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "append"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_APPEND = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_APPEND);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "asynchronous");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "asynchronous"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ASYNCHRONOUS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ASYNCHRONOUS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "auto-flush");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "auto-flush"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_AUTO_FLUSH = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTO_FLUSH);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "buffer-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("64kb");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_BUFFER_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BUFFER_SIZE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.TextAccessLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "log-control-oids");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-control-oids"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_LOG_CONTROL_OIDS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_CONTROL_OIDS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_LOG_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file-permissions");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-file-permissions"));
        provider = new DefinedDefaultBehaviorProvider("640");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-7][0-7][0-7])$", "MODE");
        PD_LOG_FILE_PERMISSIONS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE_PERMISSIONS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "log-format");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-format"));
        provider = new DefinedDefaultBehaviorProvider("multi-line");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(LogFormat.class);
        PD_LOG_FORMAT = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FORMAT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-record-time-format");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-record-time-format"));
        provider = new DefinedDefaultBehaviorProvider("dd/MMM/yyyy:HH:mm:ss Z");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_LOG_RECORD_TIME_FORMAT = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_RECORD_TIME_FORMAT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "queue-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "queue-size"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_QUEUE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUEUE_SIZE);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "time-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "time-interval"));
        provider = new DefinedDefaultBehaviorProvider("5s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_TIME_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TIME_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class FileBasedAccessLogPublisherCfgServerImpl
    implements FileBasedAccessLogPublisherCfg {
        private ServerManagedObject<? extends FileBasedAccessLogPublisherCfg> impl;
        private final boolean pAppend;
        private final boolean pAsynchronous;
        private final boolean pAutoFlush;
        private final long pBufferSize;
        private final boolean pEnabled;
        private final AccessLogPublisherCfgDefn.FilteringPolicy pFilteringPolicy;
        private final String pJavaClass;
        private final boolean pLogControlOids;
        private final String pLogFile;
        private final String pLogFilePermissions;
        private final LogFormat pLogFormat;
        private final String pLogRecordTimeFormat;
        private final int pQueueSize;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;
        private final boolean pSuppressInternalOperations;
        private final boolean pSuppressSynchronizationOperations;
        private final long pTimeInterval;

        private FileBasedAccessLogPublisherCfgServerImpl(ServerManagedObject<? extends FileBasedAccessLogPublisherCfg> impl) {
            this.impl = impl;
            this.pAppend = impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
            this.pAsynchronous = impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
            this.pAutoFlush = impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
            this.pBufferSize = impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pFilteringPolicy = impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogControlOids = impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
            this.pLogFile = impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
            this.pLogFilePermissions = impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
            this.pLogFormat = impl.getPropertyValue(INSTANCE.getLogFormatPropertyDefinition());
            this.pLogRecordTimeFormat = impl.getPropertyValue(INSTANCE.getLogRecordTimeFormatPropertyDefinition());
            this.pQueueSize = impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
            this.pSuppressInternalOperations = impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
            this.pSuppressSynchronizationOperations = impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
            this.pTimeInterval = impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void addFileBasedAccessChangeListener(ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFileBasedAccessChangeListener(ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAppend() {
            return this.pAppend;
        }

        @Override
        public boolean isAsynchronous() {
            return this.pAsynchronous;
        }

        @Override
        public boolean isAutoFlush() {
            return this.pAutoFlush;
        }

        @Override
        public long getBufferSize() {
            return this.pBufferSize;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.pFilteringPolicy;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public boolean isLogControlOids() {
            return this.pLogControlOids;
        }

        @Override
        public String getLogFile() {
            return this.pLogFile;
        }

        @Override
        public String getLogFilePermissions() {
            return this.pLogFilePermissions;
        }

        @Override
        public LogFormat getLogFormat() {
            return this.pLogFormat;
        }

        @Override
        public String getLogRecordTimeFormat() {
            return this.pLogRecordTimeFormat;
        }

        @Override
        public int getQueueSize() {
            return this.pQueueSize;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.pSuppressInternalOperations;
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.pSuppressSynchronizationOperations;
        }

        @Override
        public long getTimeInterval() {
            return this.pTimeInterval;
        }

        @Override
        public String[] listAccessLogFilteringCriteria() {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfg getAccessLogFilteringCriteria(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void addAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public Class<? extends FileBasedAccessLogPublisherCfg> configurationClass() {
            return FileBasedAccessLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class FileBasedAccessLogPublisherCfgClientImpl
    implements FileBasedAccessLogPublisherCfgClient {
        private ManagedObject<? extends FileBasedAccessLogPublisherCfgClient> impl;

        private FileBasedAccessLogPublisherCfgClientImpl(ManagedObject<? extends FileBasedAccessLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAppend() {
            return this.impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
        }

        @Override
        public void setAppend(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAppendPropertyDefinition(), value);
        }

        @Override
        public boolean isAsynchronous() {
            return this.impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
        }

        @Override
        public void setAsynchronous(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAsynchronousPropertyDefinition(), value);
        }

        @Override
        public boolean isAutoFlush() {
            return this.impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
        }

        @Override
        public void setAutoFlush(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAutoFlushPropertyDefinition(), value);
        }

        @Override
        public long getBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
        }

        @Override
        public void setBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBufferSizePropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
        }

        @Override
        public void setFilteringPolicy(AccessLogPublisherCfgDefn.FilteringPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public boolean isLogControlOids() {
            return this.impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
        }

        @Override
        public void setLogControlOids(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition(), value);
        }

        @Override
        public String getLogFile() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
        }

        @Override
        public void setLogFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePropertyDefinition(), value);
        }

        @Override
        public String getLogFilePermissions() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
        }

        @Override
        public void setLogFilePermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition(), value);
        }

        @Override
        public LogFormat getLogFormat() {
            return this.impl.getPropertyValue(INSTANCE.getLogFormatPropertyDefinition());
        }

        @Override
        public void setLogFormat(LogFormat value) {
            this.impl.setPropertyValue(INSTANCE.getLogFormatPropertyDefinition(), value);
        }

        @Override
        public String getLogRecordTimeFormat() {
            return this.impl.getPropertyValue(INSTANCE.getLogRecordTimeFormatPropertyDefinition());
        }

        @Override
        public void setLogRecordTimeFormat(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogRecordTimeFormatPropertyDefinition(), value);
        }

        @Override
        public int getQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
        }

        @Override
        public void setQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getQueueSizePropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressSynchronizationOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition(), value);
        }

        @Override
        public long getTimeInterval() {
            return this.impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void setTimeInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition(), value);
        }

        @Override
        public String[] listAccessLogFilteringCriteria() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfgClient getAccessLogFilteringCriteria(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        public <M extends AccessLogFilteringCriteriaCfgClient> M createAccessLogFilteringCriteria(ManagedObjectDefinition<M, ? extends AccessLogFilteringCriteriaCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((AccessLogFilteringCriteriaCfgClient)this.impl.createChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeAccessLogFilteringCriteria(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends FileBasedAccessLogPublisherCfgClient, ? extends FileBasedAccessLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    public static enum LogFormat {
        COMBINED("combined"),
        MULTI_LINE("multi-line");

        private final String name;

        private LogFormat(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

