/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationDefinitionVisitor;
import org.forgerock.opendj.config.RelationOption;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.dsconfig.CreateSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.DeleteSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.GetPropSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.HelpSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.ListSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SetPropSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;

final class SubCommandHandlerFactory {
    private final SortedSet<SubCommandHandler> allHandlers = new TreeSet<SubCommandHandler>();
    private final SortedSet<CreateSubCommandHandler<?, ?>> createHandlers = new TreeSet();
    private final SortedSet<DeleteSubCommandHandler> deleteHandlers = new TreeSet<DeleteSubCommandHandler>();
    private final SortedSet<GetPropSubCommandHandler> getPropHandlers = new TreeSet<GetPropSubCommandHandler>();
    private HelpSubCommandHandler helpHandler;
    private final SortedSet<ListSubCommandHandler> listHandlers = new TreeSet<ListSubCommandHandler>();
    private final SortedSet<SetPropSubCommandHandler> setPropHandlers = new TreeSet<SetPropSubCommandHandler>();
    private final SubCommandArgumentParser parser;
    private ArgumentException exception;
    private final Visitor visitor = new Visitor();

    public SubCommandHandlerFactory(SubCommandArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.helpHandler = HelpSubCommandHandler.create(parser);
        this.processPath(ManagedObjectPath.emptyPath());
        this.allHandlers.add(this.helpHandler);
        this.allHandlers.addAll(this.createHandlers);
        this.allHandlers.addAll(this.deleteHandlers);
        this.allHandlers.addAll(this.listHandlers);
        this.allHandlers.addAll(this.getPropHandlers);
        this.allHandlers.addAll(this.setPropHandlers);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public SortedSet<SubCommandHandler> getAllSubCommandHandlers() {
        return this.allHandlers;
    }

    public SortedSet<CreateSubCommandHandler<?, ?>> getCreateSubCommandHandlers() {
        return this.createHandlers;
    }

    public SortedSet<DeleteSubCommandHandler> getDeleteSubCommandHandlers() {
        return this.deleteHandlers;
    }

    public SortedSet<GetPropSubCommandHandler> getGetPropSubCommandHandlers() {
        return this.getPropHandlers;
    }

    public SortedSet<ListSubCommandHandler> getListSubCommandHandlers() {
        return this.listHandlers;
    }

    public SortedSet<SetPropSubCommandHandler> getSetPropSubCommandHandlers() {
        return this.setPropHandlers;
    }

    private void processPath(ManagedObjectPath<?, ?> path) {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        for (RelationDefinition<?, ?> r : d.getRelationDefinitions()) {
            if (r.hasOption(RelationOption.HIDDEN)) continue;
            r.accept(this.visitor, path);
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d, "DUMMY"));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c, "DUMMY"));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, SetRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, SingletonRelationDefinition<C, S> r) {
        AbstractManagedObjectDefinition d = r.getChildDefinition();
        this.helpHandler.registerManagedObjectDefinition(d);
        this.processPath(path.child(r, d));
        for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
            this.helpHandler.registerManagedObjectDefinition(c);
            this.processPath(path.child(r, c));
        }
    }

    private final class Visitor
    implements RelationDefinitionVisitor<Void, ManagedObjectPath<?, ?>> {
        private Visitor() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitInstantiable(InstantiableRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitOptional(OptionalRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSet(SetRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.createHandlers.add(CreateSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.deleteHandlers.add(DeleteSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.listHandlers.add(ListSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Void visitSingleton(SingletonRelationDefinition<C, S> rd, ManagedObjectPath<?, ?> p) {
            try {
                SubCommandHandlerFactory.this.getPropHandlers.add(GetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.setPropHandlers.add(SetPropSubCommandHandler.create(SubCommandHandlerFactory.this.parser, p, rd));
                SubCommandHandlerFactory.this.processRelation(p, rd);
            }
            catch (ArgumentException e) {
                SubCommandHandlerFactory.this.exception = e;
            }
            return null;
        }
    }
}

